/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

import com.t4login.Log;
import com.t4login.application.chart.IValueFormatter;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.studies.computations.BarTR;
import com.t4login.application.chart.studies.computations.IComputation;
import com.t4login.application.chart.studies.computations.Sum;
import com.t4login.datetime.NDateTime;

public class UltimateOscillator
implements IComputation {
    private static final String TAG = "UltimateOscillator";
    private final BarDataSeries mSeries;
    private final int mPeriods1;
    private final int mPeriods2;
    private final int mPeriods3;
    private DataSeries mData = new DataSeries();
    private BarTR mTR = null;
    private Sum mBPSum1 = null;
    private Sum mBPSum2 = null;
    private Sum mBPSum3 = null;
    private Sum mTRSum1 = null;
    private Sum mTRSum2 = null;
    private Sum mTRSum3 = null;
    private IValueFormatter mValueFormatter = new IValueFormatter(this){

        @Override
        public String formatValue(double value) {
            return String.format("%.2f", value);
        }
    };
    private DataDefinition mDataDef = null;

    public UltimateOscillator(BarDataSeries ser, int periods1, int periods2, int periods3) {
        this(ser, periods1, periods2, periods3, new DataSeries<ULTValue>());
    }

    public UltimateOscillator(BarDataSeries ser, int periods1, int periods2, int periods3, DataSeries<ULTValue> storage) {
        this.mSeries = ser;
        this.mPeriods1 = periods1;
        this.mPeriods2 = periods2;
        this.mPeriods3 = periods3;
        this.mData = storage;
    }

    public void setValueFormatter(IValueFormatter formatter) {
        this.mValueFormatter = formatter;
        this.mDataDef = null;
    }

    @Override
    public void reCompute() {
        this.mData.clear();
        this.mTR = new BarTR(this.mSeries);
        this.mBPSum1 = new Sum(this.mTR, this.mTR.getDataDefinition().getField("BP"), this.mPeriods1);
        this.mBPSum2 = new Sum(this.mTR, this.mTR.getDataDefinition().getField("BP"), this.mPeriods2);
        this.mBPSum3 = new Sum(this.mTR, this.mTR.getDataDefinition().getField("BP"), this.mPeriods3);
        this.mTRSum1 = new Sum(this.mTR, this.mTR.getDataDefinition().getField("TR"), this.mPeriods1);
        this.mTRSum2 = new Sum(this.mTR, this.mTR.getDataDefinition().getField("TR"), this.mPeriods2);
        this.mTRSum3 = new Sum(this.mTR, this.mTR.getDataDefinition().getField("TR"), this.mPeriods3);
        this.mTR.reCompute();
        this.mBPSum1.reCompute();
        this.mBPSum2.reCompute();
        this.mBPSum3.reCompute();
        this.mTRSum1.reCompute();
        this.mTRSum2.reCompute();
        this.mTRSum3.reCompute();
        this.compute(null);
    }

    @Override
    public void update() {
        if (this.mData.getCount() == 0) {
            this.mTR = new BarTR(this.mSeries);
            this.mBPSum1 = new Sum(this.mTR, this.mTR.getDataDefinition().getField("BP"), this.mPeriods1);
            this.mBPSum2 = new Sum(this.mTR, this.mTR.getDataDefinition().getField("BP"), this.mPeriods2);
            this.mBPSum3 = new Sum(this.mTR, this.mTR.getDataDefinition().getField("BP"), this.mPeriods3);
            this.mTRSum1 = new Sum(this.mTR, this.mTR.getDataDefinition().getField("TR"), this.mPeriods1);
            this.mTRSum2 = new Sum(this.mTR, this.mTR.getDataDefinition().getField("TR"), this.mPeriods2);
            this.mTRSum3 = new Sum(this.mTR, this.mTR.getDataDefinition().getField("TR"), this.mPeriods3);
            this.mTR.reCompute();
            this.mBPSum1.reCompute();
            this.mBPSum2.reCompute();
            this.mBPSum3.reCompute();
            this.mTRSum1.reCompute();
            this.mTRSum2.reCompute();
            this.mTRSum3.reCompute();
            this.compute(null);
        } else {
            this.compute((ULTValue)this.mData.getLast());
        }
    }

    @Override
    public void reset() {
        if (this.mTR != null) {
            this.mTR.reset();
            this.mBPSum1.reset();
            this.mBPSum2.reset();
            this.mBPSum3.reset();
            this.mTRSum1.reset();
            this.mTRSum2.reset();
            this.mTRSum3.reset();
        }
        this.mData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(ULTValue startpt) {
        if (this.mTR == null || this.mTR.getDataSource().getCount() < 1) {
            return;
        }
        IDataSource trData = this.mTR.getDataSource();
        int startidx = 0;
        if (startpt != null) {
            startidx = startpt.DataIndex;
        }
        this.mData.beginUpdate();
        try {
            for (int i = startidx; i < trData.getCount(); ++i) {
                BarTR.TRValue tr = (BarTR.TRValue)trData.get(i);
                Sum.SumValue bpsum1 = (Sum.SumValue)this.mBPSum1.getDataSource().get(tr.Time);
                Sum.SumValue bpsum2 = (Sum.SumValue)this.mBPSum2.getDataSource().get(tr.Time);
                Sum.SumValue bpsum3 = (Sum.SumValue)this.mBPSum3.getDataSource().get(tr.Time);
                Sum.SumValue trsum1 = (Sum.SumValue)this.mTRSum1.getDataSource().get(tr.Time);
                Sum.SumValue trsum2 = (Sum.SumValue)this.mTRSum2.getDataSource().get(tr.Time);
                Sum.SumValue trsum3 = (Sum.SumValue)this.mTRSum3.getDataSource().get(tr.Time);
                if (bpsum1 == null || bpsum2 == null || bpsum3 == null || trsum1 == null || trsum2 == null || trsum3 == null) continue;
                if (trsum1.Sum == 0.0 || trsum2.Sum == 0.0 || trsum3.Sum == 0.0) {
                    this.mData.addDataPoint(new ULTValue(tr.Time, 50.0, i));
                    continue;
                }
                double rawult = 4.0 * (bpsum1.Sum / trsum1.Sum) + 2.0 * (bpsum2.Sum / trsum2.Sum) + bpsum3.Sum / trsum3.Sum;
                double ult = 100.0 * (rawult / 7.0);
                this.mData.addDataPoint(new ULTValue(tr.Time, ult, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "compute(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDataDef == null) {
            this.mDataDef = new DataDefinition("Difference");
            this.mDataDef.addField(new DataField("ULT", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof ULTValue) {
                        ULTValue sumdp = (ULTValue)dp;
                        return sumdp.ULT;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    return UltimateOscillator.this.mValueFormatter.formatValue(value);
                }
            }, true, true));
        }
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    public static class ULTValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double ULT;
        public final int DataIndex;

        public ULTValue(NDateTime time, double ult, int idx) {
            this.Time = time;
            this.ULT = ult;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.ULT;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

