/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

import com.t4login.Log;
import com.t4login.application.chart.IValueFormatter;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataProvider;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.studies.computations.IComputation;
import com.t4login.datetime.NDateTime;

public class Sum
implements IComputation {
    private static final String TAG = "Sum";
    private IDataProvider mProvider = null;
    private DataField mField = null;
    private final int mPeriods;
    private DataSeries mData = new DataSeries();
    private IValueFormatter mValueFormatter = new IValueFormatter(this){

        @Override
        public String formatValue(double value) {
            return Double.toString(value);
        }
    };
    private DataDefinition mDataDef = null;

    public Sum(IDataProvider provider, DataField field, int periods) {
        this.mProvider = provider;
        this.mField = field;
        this.mPeriods = periods;
    }

    public Sum(IDataProvider provider, DataField field, DataSeries storage, int periods) {
        this(provider, field, periods);
        this.mData = storage;
    }

    public void setValueFormatter(IValueFormatter formatter) {
        this.mValueFormatter = formatter;
        this.mDataDef = null;
    }

    @Override
    public void reCompute() {
        this.mData.clear();
        this.compute(null);
    }

    @Override
    public void update() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            this.compute((SumValue)this.mData.getLast());
        }
    }

    @Override
    public void reset() {
        this.mData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(SumValue startpt) {
        IDataSource ds = this.mProvider.getDataSource();
        if (ds.getCount() < this.mPeriods) {
            return;
        }
        this.mData.beginUpdate();
        try {
            int startidx = 0;
            double sum = 0.0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
                SumValue prevval = (SumValue)this.mData.getPreceeding(startpt.Time);
                sum = prevval.Sum;
            }
            for (int i = startidx; i < ds.getCount(); ++i) {
                Object dp = ds.get(i);
                double currvalue = this.mField.getDataPointValue((IDataPoint)dp);
                if (i > this.mPeriods - 1) {
                    Object topdp = ds.get(i - this.mPeriods);
                    double topvalue = this.mField.getDataPointValue((IDataPoint)topdp);
                    sum = sum + currvalue - topvalue;
                } else {
                    sum += currvalue;
                }
                if (i < this.mPeriods - 1) continue;
                this.mData.addDataPoint(new SumValue(dp.getTime(), sum, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDataDef == null) {
            this.mDataDef = new DataDefinition("Difference");
            this.mDataDef.addField(new DataField("SUM", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof SumValue) {
                        SumValue sumdp = (SumValue)dp;
                        return sumdp.Sum;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    return Sum.this.mValueFormatter.formatValue(value);
                }
            }, true, true));
        }
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    public static class SumValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double Sum;
        public final int DataIndex;

        public SumValue(NDateTime time, double sum, int idx) {
            this.Time = time;
            this.Sum = sum;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.Sum;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

