/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

import com.t4login.Log;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.studies.computations.IComputation;
import com.t4login.datetime.NDateTime;
import java.util.ArrayDeque;
import java.util.Iterator;

public class Stoch
implements IComputation {
    private static final String TAG = "Stoch";
    private final BarDataSeries mSeries;
    private final DataSeries<STOValue> mData;
    private final int mPeriods;
    private final int mKPeriods;
    private final int mDPeriods;
    private DataDefinition mDataDef = null;

    public Stoch(BarDataSeries ser, int per, int kper, int dper) {
        this(ser, per, kper, dper, new DataSeries<STOValue>());
    }

    public Stoch(BarDataSeries ser, int per, int kper, int dper, DataSeries<STOValue> storage) {
        this.mSeries = ser;
        this.mData = storage;
        this.mPeriods = per;
        this.mKPeriods = kper;
        this.mDPeriods = dper;
    }

    @Override
    public void reCompute() {
        this.mData.clear();
        this.compute(null);
    }

    @Override
    public void update() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            STOValue startpt = null;
            IBarDataPoint basept = this.mSeries.baseDataPoint;
            if (basept != null) {
                STOValue lastpt = (STOValue)this.mData.getLast();
                while (lastpt != null && lastpt.Time.compareTo(basept.getTime()) > 0) {
                    this.mData.removeDataPoint(lastpt);
                }
                startpt = lastpt = (STOValue)this.mData.getLast();
            }
            if (startpt == null) {
                startpt = (STOValue)this.mData.getLast();
            }
            this.compute(startpt);
        }
    }

    @Override
    public void reset() {
        this.mData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(STOValue startpt) {
        if (this.mSeries.getCount() < this.mPeriods) {
            return;
        }
        int startidx = 0;
        int maxper = Math.max(this.mPeriods, Math.max(this.mKPeriods, this.mDPeriods));
        int queuesz = maxper + 1;
        ArrayDeque<Double> highs = new ArrayDeque<Double>(queuesz);
        ArrayDeque<Double> lows = new ArrayDeque<Double>(queuesz);
        ArrayDeque<Double> ks = new ArrayDeque<Double>(queuesz);
        ArrayDeque<Double> ds = new ArrayDeque<Double>(queuesz);
        this.mData.beginUpdate();
        try {
            IBarDataPoint bar;
            int i;
            if (startpt != null) {
                startidx = startpt.DataIndex;
                for (i = Math.max(0, startidx - maxper + 1); i < startidx; ++i) {
                    bar = this.mSeries.get(i);
                    highs.add(bar.getHigh());
                    lows.add(bar.getLow());
                    STOValue sto = (STOValue)this.mData.get(bar.getTime());
                    if (sto == null) continue;
                    ks.add(sto.KFast);
                    if (ks.size() > this.mKPeriods) {
                        ks.remove();
                    }
                    if (!(sto.K >= 0.0)) continue;
                    ds.add(sto.K);
                    if (ds.size() <= this.mDPeriods) continue;
                    ds.remove();
                }
            }
            for (i = startidx; i < this.mSeries.getCount(); ++i) {
                bar = this.mSeries.get(i);
                highs.add(bar.getHigh());
                lows.add(bar.getLow());
                while (highs.size() > this.mPeriods) {
                    highs.remove();
                    lows.remove();
                }
                if (highs.size() != this.mPeriods) continue;
                double hhigh = (Double)highs.peek();
                for (Double highval : highs) {
                    hhigh = Math.max(hhigh, highval);
                }
                double llow = (Double)lows.peek();
                for (Double lowval : lows) {
                    llow = Math.min(llow, lowval);
                }
                double kfast = 50.0;
                if (hhigh != llow) {
                    kfast = 100.0 * ((bar.getClose() - llow) / (hhigh - llow));
                }
                ks.add(kfast);
                while (ks.size() > this.mKPeriods) {
                    ks.remove();
                }
                if (ks.size() == this.mKPeriods) {
                    double k = 0.0;
                    Iterator iterator = ks.iterator();
                    while (iterator.hasNext()) {
                        double kfval = (Double)iterator.next();
                        k += kfval;
                    }
                    ds.add(k /= (double)this.mKPeriods);
                    while (ds.size() > this.mDPeriods) {
                        ds.remove();
                    }
                    if (ds.size() == this.mDPeriods) {
                        double d = 0.0;
                        Iterator iterator2 = ds.iterator();
                        while (iterator2.hasNext()) {
                            double kval = (Double)iterator2.next();
                            d += kval;
                        }
                        this.mData.addDataPoint(new STOValue(bar.getTime(), kfast, k, d /= (double)this.mDPeriods, i));
                        continue;
                    }
                    this.mData.addDataPoint(new STOValue(bar.getTime(), kfast, k, -1.0, i));
                    continue;
                }
                this.mData.addDataPoint(new STOValue(bar.getTime(), kfast, -1.0, -1.0, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "compute(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        this.mDataDef = new DataDefinition(TAG);
        this.mDataDef.addField(new DataField("K", new DataField.DataFieldReader(this){

            @Override
            public Double getFieldValue(IDataPoint dp) {
                if (dp instanceof STOValue) {
                    STOValue trdp = (STOValue)dp;
                    return trdp.K;
                }
                return null;
            }
        }, new DataField.DataFieldFormatter(this){

            @Override
            public String getFormattedValue(double value) {
                return String.format("%.2f", value);
            }
        }, true, false));
        this.mDataDef.addField(new DataField("D", new DataField.DataFieldReader(this){

            @Override
            public Double getFieldValue(IDataPoint dp) {
                if (dp instanceof STOValue) {
                    STOValue trdp = (STOValue)dp;
                    return trdp.D;
                }
                return null;
            }
        }, new DataField.DataFieldFormatter(this){

            @Override
            public String getFormattedValue(double value) {
                return String.format("%.2f", value);
            }
        }, false, false));
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    public static class STOValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double KFast;
        public final double K;
        public final double D;
        public final int DataIndex;

        public STOValue(NDateTime time, double kfast, double k, double d, int idx) {
            this.Time = time;
            this.KFast = kfast;
            this.K = k;
            this.D = d;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.K;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

