/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

public class RunningCalc {
    private final int mCapacity;
    private double[] mValues;
    private int mCurr = -1;
    private int mCount = 0;

    public RunningCalc(int capacity) {
        this.mCapacity = capacity;
        this.mValues = new double[this.mCapacity];
    }

    public double getCurrentValue() {
        return this.mCurr >= 0 ? this.mValues[this.mCurr] : 0.0;
    }

    public double[] getValues() {
        return this.mValues;
    }

    public int getCapacity() {
        return this.mCapacity;
    }

    public int getCount() {
        return this.mCount;
    }

    public double getSum() {
        if (this.mCapacity == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < this.mCapacity; ++i) {
            sum += this.mValues[i];
        }
        return sum;
    }

    public double getAvg() {
        if (this.mCapacity == 0) {
            return 0.0;
        }
        return this.getSum() / (double)this.mCapacity;
    }

    public double getStdDev() {
        if (this.mCapacity == 0) {
            return 0.0;
        }
        double avg = this.getAvg();
        double sqdev = 0.0;
        for (int i = 0; i < this.mCapacity; ++i) {
            sqdev += Math.pow(this.mValues[i] - this.getAvg(), 2.0);
        }
        double stddev = Math.sqrt(sqdev / (double)(this.mCapacity - 1));
        return stddev;
    }

    public void add(double value) {
        if (this.mCapacity == 0) {
            return;
        }
        if (this.mCount < this.mCapacity) {
            ++this.mCount;
        }
        this.mCurr = (this.mCurr + 1) % this.mCapacity;
        this.mValues[this.mCurr] = value;
    }
}

