/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

import com.t4login.Log;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.studies.computations.IComputation;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.PriceFormat;

public class ParabolicSAR
implements IComputation {
    private static final String TAG = "ParabolicSAR";
    private final BarDataSeries mSeries;
    private final DataSeries<SARValue> mData;
    private double mAcclFactor = 0.02;
    private double mMaxAcclFactor = 0.2;
    private DataDefinition mDataDef = null;

    public ParabolicSAR(BarDataSeries ser, double af, double maxaf) {
        this(ser, af, maxaf, new DataSeries<SARValue>());
    }

    public ParabolicSAR(BarDataSeries ser, double af, double maxaf, DataSeries<SARValue> storage) {
        this.mSeries = ser;
        this.mAcclFactor = af;
        this.mMaxAcclFactor = maxaf;
        this.mData = storage;
    }

    @Override
    public void reCompute() {
        this.mData.clear();
        this.compute(null);
    }

    @Override
    public void update() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            SARValue startpt = null;
            IBarDataPoint basept = this.mSeries.baseDataPoint;
            if (basept != null) {
                SARValue lastpt = (SARValue)this.mData.getLast();
                while (lastpt != null && lastpt.Time.compareTo(basept.getTime()) > 0) {
                    this.mData.removeDataPoint(lastpt);
                }
                startpt = lastpt = (SARValue)this.mData.getLast();
            }
            if (startpt == null) {
                startpt = (SARValue)this.mData.getLast();
            }
            this.compute(startpt);
        }
    }

    @Override
    public void reset() {
        this.mData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(SARValue startpt) {
        if (this.mSeries == null || this.mSeries.getCount() < 2) {
            return;
        }
        if (this.mAcclFactor <= 0.0) {
            this.mData.clear();
            return;
        }
        this.mData.beginUpdate();
        try {
            int startidx = 1;
            double sar = 0.0;
            Position pos = Position.Long;
            double af = this.mAcclFactor;
            double hp = 0.0;
            double lp = 0.0;
            if (startpt != null) {
                SARValue prevpt = (SARValue)this.mData.getPreceeding(startpt.Time);
                startidx = prevpt.DataIndex + 1;
                sar = prevpt.SAR;
                pos = prevpt.Position;
                af = prevpt.AF;
                hp = prevpt.HighPoint;
                lp = prevpt.LowPoint;
            } else {
                IBarDataPoint firstbar = this.mSeries.get(0);
                sar = firstbar.getLow();
                hp = firstbar.getHigh();
                lp = firstbar.getLow();
                this.mData.addDataPoint(new SARValue(firstbar.getTime(), sar, pos, af, hp, lp, 0));
            }
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                IBarDataPoint bar = this.mSeries.get(i);
                double prevlow = bar.getLow();
                double prevhigh = bar.getHigh();
                if (i > 0) {
                    IBarDataPoint prevbar = this.mSeries.get(i - 1);
                    prevlow = prevbar.getLow();
                    prevhigh = prevbar.getHigh();
                }
                sar = pos == Position.Long ? (sar += af * (hp - sar)) : (sar += af * (lp - sar));
                boolean rev = false;
                if (pos == Position.Long) {
                    if (bar.getLow() < sar) {
                        pos = Position.Short;
                        rev = true;
                        sar = hp;
                        lp = bar.getLow();
                        af = this.mAcclFactor;
                    }
                } else if (bar.getHigh() > sar) {
                    pos = Position.Long;
                    rev = true;
                    sar = lp;
                    hp = bar.getHigh();
                    af = this.mAcclFactor;
                }
                if (!rev) {
                    if (pos == Position.Long) {
                        if (bar.getHigh() > hp) {
                            hp = bar.getHigh();
                            af += this.mAcclFactor;
                            af = Math.min(af, this.mMaxAcclFactor);
                        }
                        sar = Math.min(sar, bar.getLow());
                        sar = Math.min(sar, prevlow);
                    } else {
                        if (bar.getLow() < lp) {
                            lp = bar.getLow();
                            af += this.mAcclFactor;
                            af = Math.min(af, this.mMaxAcclFactor);
                        }
                        sar = Math.max(sar, bar.getHigh());
                        sar = Math.max(sar, prevhigh);
                    }
                }
                this.mData.addDataPoint(new SARValue(bar.getTime(), sar, pos, af, hp, lp, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "compute(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        this.mDataDef = new DataDefinition("PSAR");
        this.mDataDef.addField(new DataField("SAR", new DataField.DataFieldReader(this){

            @Override
            public Double getFieldValue(IDataPoint dp) {
                if (dp instanceof SARValue) {
                    SARValue trdp = (SARValue)dp;
                    return trdp.SAR;
                }
                return null;
            }
        }, new DataField.DataFieldFormatter(){

            @Override
            public String getFormattedValue(double value) {
                try {
                    return PriceFormat.convertPriceToDisplayFormat(value, ParabolicSAR.this.mSeries.getArgs().Market);
                }
                catch (Exception ex) {
                    Log.e("ParabolicSAR.DD", "getFormattedValue(), Error.", ex);
                    return Double.toString(value);
                }
            }
        }, true, true));
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    public static class SARValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double SAR;
        public final Position Position;
        public final double AF;
        public final double HighPoint;
        public final double LowPoint;
        public final int DataIndex;

        public SARValue(NDateTime time, double sar, Position pos, double af, double hp, double lp, int idx) {
            this.Time = time;
            this.SAR = sar;
            this.Position = pos;
            this.AF = af;
            this.HighPoint = hp;
            this.LowPoint = lp;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.SAR;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }

    public static enum Position {
        Long,
        Short;

    }
}

