/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.application.chart.BarInterval;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.studies.computations.IComputation;
import com.t4login.application.chart.studies.computations.pivscript.PPContext;
import com.t4login.application.chart.studies.computations.pivscript.PPFunc;
import com.t4login.application.configuration.IEnum;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.util.ReturnFlag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PP
implements IComputation {
    private static final String TAG = "PP";
    private final BarDataSeries mSeries;
    private final DataSeries<PPValue> mData;
    private final PPMethod mPPMethod;
    private final String[] mCustomFormulas;
    private final int mBarsBack;
    private PPFunc mR4 = null;
    private PPFunc mR3 = null;
    private PPFunc mR2 = null;
    private PPFunc mR1 = null;
    private PPFunc mPP = null;
    private PPFunc mS1 = null;
    private PPFunc mS2 = null;
    private PPFunc mS3 = null;
    private PPFunc mS4 = null;
    private PPFunc mMidR4R3 = null;
    private PPFunc mMidR3R2 = null;
    private PPFunc mMidR2R1 = null;
    private PPFunc mMidR1PP = null;
    private PPFunc mMidPPS1 = null;
    private PPFunc mMidS1S2 = null;
    private PPFunc mMidS2S3 = null;
    private PPFunc mMidS3S4 = null;
    private DataDefinition mDataDef = null;

    public PP(BarDataSeries ser, PPMethod method, String[] formulas, int barsback) {
        this(ser, method, formulas, barsback, new DataSeries<PPValue>());
    }

    public PP(BarDataSeries ser, PPMethod method, String[] formulas, int barsback, DataSeries<PPValue> storage) {
        this.mSeries = ser;
        this.mData = storage;
        this.mPPMethod = method;
        this.mCustomFormulas = formulas;
        this.mBarsBack = barsback;
        this.setup();
    }

    private void setup() {
        switch (this.mPPMethod) {
            case Floor: {
                this.mR3 = ppc -> ppc.getHigh() + 2.0 * (ppc.PP.compute(ppc) - ppc.getLow());
                this.mR2 = ppc -> ppc.PP.compute(ppc) + ppc.getRange();
                this.mR1 = ppc -> 2.0 * ppc.PP.compute(ppc) - ppc.getLow();
                this.mPP = ppc -> (ppc.getHigh() + ppc.getLow() + ppc.getClose()) / 3.0;
                this.mS1 = ppc -> 2.0 * ppc.PP.compute(ppc) - ppc.getHigh();
                this.mS2 = ppc -> ppc.PP.compute(ppc) - ppc.getRange();
                this.mS3 = ppc -> ppc.getLow() - 2.0 * (ppc.getHigh() - ppc.PP.compute(ppc));
                break;
            }
            case Woodie: {
                this.mR4 = ppc -> ppc.PP.compute(ppc) + 3.0 * ppc.getRange();
                this.mR3 = ppc -> ppc.getHigh() + 2.0 * (ppc.PP.compute(ppc) - ppc.getLow());
                this.mR2 = ppc -> ppc.PP.compute(ppc) + ppc.getRange();
                this.mR1 = ppc -> 2.0 * ppc.PP.compute(ppc) - ppc.getLow();
                this.mPP = ppc -> (ppc.getHigh() + ppc.getLow() + 2.0 * ppc.getOpen(1)) / 4.0;
                this.mS1 = ppc -> 2.0 * ppc.PP.compute(ppc) - ppc.getHigh();
                this.mS2 = ppc -> ppc.PP.compute(ppc) - ppc.getRange();
                this.mS3 = ppc -> ppc.getLow() - 2.0 * (ppc.getHigh() - ppc.PP.compute(ppc));
                this.mS4 = ppc -> ppc.PP.compute(ppc) - 3.0 * ppc.getRange();
                break;
            }
            case Camarilla: {
                this.mR4 = ppc -> ppc.getClose() + ppc.getRange() * 1.1 / 2.0;
                this.mR3 = ppc -> ppc.getClose() + ppc.getRange() * 1.1 / 4.0;
                this.mR2 = ppc -> ppc.getClose() + ppc.getRange() * 1.1 / 6.0;
                this.mR1 = ppc -> ppc.getClose() + ppc.getRange() * 1.1 / 12.0;
                this.mPP = ppc -> (ppc.getHigh() + ppc.getLow() + ppc.getClose()) / 3.0;
                this.mS1 = ppc -> ppc.getClose() - ppc.getRange() * 1.1 / 12.0;
                this.mS2 = ppc -> ppc.getClose() - ppc.getRange() * 1.1 / 6.0;
                this.mS3 = ppc -> ppc.getClose() - ppc.getRange() * 1.1 / 4.0;
                this.mS4 = ppc -> ppc.getClose() - ppc.getRange() * 1.1 / 2.0;
                break;
            }
            case Demark: {
                this.mR1 = ppc -> {
                    IBarDataPoint nextBar = ppc.Series.getNext(ppc.CurrentBar.getTime());
                    double x = 0.0;
                    x = nextBar != null ? (ppc.getClose() < nextBar.getOpen() ? ppc.getHigh() + 2.0 * ppc.getLow() + ppc.getClose() : (ppc.getClose() > nextBar.getOpen() ? 2.0 * ppc.getHigh() + ppc.getLow() + ppc.getClose() : ppc.getHigh() + ppc.getLow() + 2.0 * ppc.getClose())) : ppc.getHigh() + ppc.getLow() + 2.0 * ppc.getClose();
                    return x / 2.0 - ppc.getLow();
                };
                this.mPP = ppc -> {
                    IBarDataPoint nextBar = ppc.Series.getNext(ppc.CurrentBar.getTime());
                    double x = 0.0;
                    x = nextBar != null ? (ppc.getClose() < nextBar.getOpen() ? ppc.getHigh() + 2.0 * ppc.getLow() + ppc.getClose() : (ppc.getClose() > nextBar.getOpen() ? 2.0 * ppc.getHigh() + ppc.getLow() + ppc.getClose() : ppc.getHigh() + ppc.getLow() + 2.0 * ppc.getClose())) : ppc.getHigh() + ppc.getLow() + 2.0 * ppc.getClose();
                    return x / 4.0;
                };
                this.mS1 = ppc -> {
                    IBarDataPoint nextBar = ppc.Series.getNext(ppc.CurrentBar.getTime());
                    double x = 0.0;
                    x = nextBar != null ? (ppc.getClose() < nextBar.getOpen() ? ppc.getHigh() + 2.0 * ppc.getLow() + ppc.getClose() : (ppc.getClose() > nextBar.getOpen() ? 2.0 * ppc.getHigh() + ppc.getLow() + ppc.getClose() : ppc.getHigh() + ppc.getLow() + 2.0 * ppc.getClose())) : ppc.getHigh() + ppc.getLow() + 2.0 * ppc.getClose();
                    return x / 2.0 - ppc.getHigh();
                };
                break;
            }
            case Fibonacci: {
                this.mR3 = ppc -> ppc.PP.compute(ppc) + ppc.getRange();
                this.mR2 = ppc -> ppc.PP.compute(ppc) + 0.618 * ppc.getRange();
                this.mR1 = ppc -> ppc.PP.compute(ppc) + 0.382 * ppc.getRange();
                this.mPP = ppc -> (ppc.getHigh() + ppc.getLow() + ppc.getClose()) / 3.0;
                this.mS1 = ppc -> ppc.PP.compute(ppc) - 0.382 * ppc.getRange();
                this.mS2 = ppc -> ppc.PP.compute(ppc) - 0.618 * ppc.getRange();
                this.mS3 = ppc -> ppc.PP.compute(ppc) - ppc.getRange();
                break;
            }
            case HLC: {
                this.mR1 = ppc -> ppc.getHigh();
                this.mPP = ppc -> ppc.getClose();
                this.mS1 = ppc -> ppc.getLow();
                break;
            }
        }
    }

    @Override
    public void reCompute() {
        this.mData.clear();
        this.compute(null);
    }

    @Override
    public void update() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            PPValue startpt = null;
            IBarDataPoint basept = this.mSeries.baseDataPoint;
            if (basept != null) {
                PPValue lastpt = (PPValue)this.mData.getLast();
                while (lastpt != null && lastpt.Time.compareTo(basept.getTime()) > 0) {
                    this.mData.removeDataPoint(lastpt);
                }
                startpt = lastpt = (PPValue)this.mData.getLast();
            }
            if (startpt == null) {
                startpt = (PPValue)this.mData.getLast();
            }
            this.compute(startpt);
        }
    }

    @Override
    public void reset() {
        this.mData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(PPValue startpt) {
        if (this.mSeries.getCount() < this.mBarsBack + 1) {
            return;
        }
        int startIdx = this.mBarsBack;
        if (startpt != null) {
            startIdx = startpt.DataIndex;
        }
        this.mData.beginUpdate();
        try {
            ReturnFlag haltFlag = new ReturnFlag();
            PPContext ppc = new PPContext(this.mSeries);
            ppc.R4 = this.mR4;
            ppc.R3 = this.mR3;
            ppc.R2 = this.mR2;
            ppc.R1 = this.mR1;
            ppc.PP = this.mPP;
            ppc.S1 = this.mS1;
            ppc.S2 = this.mS2;
            ppc.S3 = this.mS3;
            ppc.S4 = this.mS4;
            for (int idx = startIdx; idx < this.mSeries.getCount(); ++idx) {
                Price priceVal;
                Double val;
                IBarDataPoint bar;
                IBarDataPoint posbar = this.mSeries.get(idx);
                ppc.CurrentBar = bar = this.mSeries.get(idx - this.mBarsBack);
                ArrayList<PivotPoint> points = new ArrayList<PivotPoint>();
                if (this.mR4 != null) {
                    val = this.executePPFunction(this.mR4, ppc, "R4", haltFlag);
                    if (haltFlag.isSet()) {
                        this.mR4 = null;
                    }
                    if (val != null) {
                        priceVal = Price.of(val).round(this.mSeries.getArgs().Market.getAPIMarket());
                        points.add(new PivotPoint(PPLine.R4, priceVal.getDoubleValue()));
                    }
                }
                if (this.mR3 != null) {
                    val = this.executePPFunction(this.mR3, ppc, "R3", haltFlag);
                    if (haltFlag.isSet()) {
                        this.mR3 = null;
                    }
                    if (val != null) {
                        priceVal = Price.of(val).round(this.mSeries.getArgs().Market.getAPIMarket());
                        points.add(new PivotPoint(PPLine.R3, priceVal.getDoubleValue()));
                    }
                }
                if (this.mR2 != null) {
                    val = this.executePPFunction(this.mR2, ppc, "R2", haltFlag);
                    if (haltFlag.isSet()) {
                        this.mR2 = null;
                    }
                    if (val != null) {
                        priceVal = Price.of(val).round(this.mSeries.getArgs().Market.getAPIMarket());
                        points.add(new PivotPoint(PPLine.R2, priceVal.getDoubleValue()));
                    }
                }
                if (this.mR1 != null) {
                    val = this.executePPFunction(this.mR1, ppc, "R1", haltFlag);
                    if (haltFlag.isSet()) {
                        this.mR1 = null;
                    }
                    if (val != null) {
                        priceVal = Price.of(val).round(this.mSeries.getArgs().Market.getAPIMarket());
                        points.add(new PivotPoint(PPLine.R1, priceVal.getDoubleValue()));
                    }
                }
                if (this.mPP != null) {
                    val = this.executePPFunction(this.mPP, ppc, TAG, haltFlag);
                    if (haltFlag.isSet()) {
                        this.mPP = null;
                    }
                    if (val != null) {
                        priceVal = Price.of(val).round(this.mSeries.getArgs().Market.getAPIMarket());
                        points.add(new PivotPoint(PPLine.PP, priceVal.getDoubleValue()));
                    }
                }
                if (this.mS1 != null) {
                    val = this.executePPFunction(this.mS1, ppc, "S1", haltFlag);
                    if (haltFlag.isSet()) {
                        this.mS1 = null;
                    }
                    if (val != null) {
                        priceVal = Price.of(val).round(this.mSeries.getArgs().Market.getAPIMarket());
                        points.add(new PivotPoint(PPLine.S1, priceVal.getDoubleValue()));
                    }
                }
                if (this.mS2 != null) {
                    val = this.executePPFunction(this.mS2, ppc, "S2", haltFlag);
                    if (haltFlag.isSet()) {
                        this.mS2 = null;
                    }
                    if (val != null) {
                        priceVal = Price.of(val).round(this.mSeries.getArgs().Market.getAPIMarket());
                        points.add(new PivotPoint(PPLine.S2, priceVal.getDoubleValue()));
                    }
                }
                if (this.mS3 != null) {
                    val = this.executePPFunction(this.mS3, ppc, "S3", haltFlag);
                    if (haltFlag.isSet()) {
                        this.mS3 = null;
                    }
                    if (val != null) {
                        priceVal = Price.of(val).round(this.mSeries.getArgs().Market.getAPIMarket());
                        points.add(new PivotPoint(PPLine.S3, priceVal.getDoubleValue()));
                    }
                }
                if (this.mS4 != null) {
                    val = this.executePPFunction(this.mS4, ppc, "S4", haltFlag);
                    if (haltFlag.isSet()) {
                        this.mS4 = null;
                    }
                    if (val != null) {
                        priceVal = Price.of(val).round(this.mSeries.getArgs().Market.getAPIMarket());
                        points.add(new PivotPoint(PPLine.S4, priceVal.getDoubleValue()));
                    }
                }
                if (points.size() <= 0) continue;
                boolean alignToTradeDate = this.mSeries.getArgs().Interval.compareTo(BarInterval.Bar1Day) >= 0;
                NDateTime pttime = alignToTradeDate ? posbar.getTradeDate() : posbar.getTime();
                this.mData.addDataPoint(new PPValue(pttime, points.toArray(new PivotPoint[points.size()]), idx));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "compute(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    private Double executePPFunction(PPFunc func, PPContext ppc, String name, ReturnFlag haltFlag) {
        haltFlag.unset();
        try {
            ppc.reset();
            Double result = func.compute(ppc);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDataDef == null) {
            this.mDataDef = new DataDefinition(TAG);
            this.mDataDef.addField(new DataField("R4", dp -> {
                if (dp instanceof PPValue) {
                    PPValue ppdp = (PPValue)dp;
                    for (PivotPoint pivpt : ppdp.LineValues) {
                        if (pivpt.Line != PPLine.R4) continue;
                        return pivpt.Value;
                    }
                }
                return null;
            }, value -> {
                try {
                    return PriceFormat.convertPriceToDisplayFormat(value, this.mSeries.getArgs().Market);
                }
                catch (Exception ex) {
                    Log.e("PP.DD", "getFormattedValue(), Error.", ex);
                    return Double.toString(value);
                }
            }, false, true));
            this.mDataDef.addField(new DataField("R3", dp -> {
                if (dp instanceof PPValue) {
                    PPValue ppdp = (PPValue)dp;
                    for (PivotPoint pivpt : ppdp.LineValues) {
                        if (pivpt.Line != PPLine.R3) continue;
                        return pivpt.Value;
                    }
                }
                return null;
            }, value -> {
                try {
                    return PriceFormat.convertPriceToDisplayFormat(value, this.mSeries.getArgs().Market);
                }
                catch (Exception ex) {
                    Log.e("PP.DD", "getFormattedValue(), Error.", ex);
                    return Double.toString(value);
                }
            }, false, true));
            this.mDataDef.addField(new DataField("R2", dp -> {
                if (dp instanceof PPValue) {
                    PPValue ppdp = (PPValue)dp;
                    for (PivotPoint pivpt : ppdp.LineValues) {
                        if (pivpt.Line != PPLine.R2) continue;
                        return pivpt.Value;
                    }
                }
                return null;
            }, value -> {
                try {
                    return PriceFormat.convertPriceToDisplayFormat(value, this.mSeries.getArgs().Market);
                }
                catch (Exception ex) {
                    Log.e("PP.DD", "getFormattedValue(), Error.", ex);
                    return Double.toString(value);
                }
            }, false, true));
            this.mDataDef.addField(new DataField("R1", dp -> {
                if (dp instanceof PPValue) {
                    PPValue ppdp = (PPValue)dp;
                    for (PivotPoint pivpt : ppdp.LineValues) {
                        if (pivpt.Line != PPLine.R1) continue;
                        return pivpt.Value;
                    }
                }
                return null;
            }, value -> {
                try {
                    return PriceFormat.convertPriceToDisplayFormat(value, this.mSeries.getArgs().Market);
                }
                catch (Exception ex) {
                    Log.e("PP.DD", "getFormattedValue(), Error.", ex);
                    return Double.toString(value);
                }
            }, false, true));
            this.mDataDef.addField(new DataField(TAG, dp -> {
                if (dp instanceof PPValue) {
                    PPValue ppdp = (PPValue)dp;
                    for (PivotPoint pivpt : ppdp.LineValues) {
                        if (pivpt.Line != PPLine.PP) continue;
                        return pivpt.Value;
                    }
                }
                return null;
            }, value -> {
                try {
                    return PriceFormat.convertPriceToDisplayFormat(value, this.mSeries.getArgs().Market);
                }
                catch (Exception ex) {
                    Log.e("PP.DD", "getFormattedValue(), Error.", ex);
                    return Double.toString(value);
                }
            }, true, true));
            this.mDataDef.addField(new DataField("S1", dp -> {
                if (dp instanceof PPValue) {
                    PPValue ppdp = (PPValue)dp;
                    for (PivotPoint pivpt : ppdp.LineValues) {
                        if (pivpt.Line != PPLine.S1) continue;
                        return pivpt.Value;
                    }
                }
                return null;
            }, value -> {
                try {
                    return PriceFormat.convertPriceToDisplayFormat(value, this.mSeries.getArgs().Market);
                }
                catch (Exception ex) {
                    Log.e("PP.DD", "getFormattedValue(), Error.", ex);
                    return Double.toString(value);
                }
            }, false, true));
            this.mDataDef.addField(new DataField("S2", dp -> {
                if (dp instanceof PPValue) {
                    PPValue ppdp = (PPValue)dp;
                    for (PivotPoint pivpt : ppdp.LineValues) {
                        if (pivpt.Line != PPLine.S2) continue;
                        return pivpt.Value;
                    }
                }
                return null;
            }, value -> {
                try {
                    return PriceFormat.convertPriceToDisplayFormat(value, this.mSeries.getArgs().Market);
                }
                catch (Exception ex) {
                    Log.e("PP.DD", "getFormattedValue(), Error.", ex);
                    return Double.toString(value);
                }
            }, false, true));
            this.mDataDef.addField(new DataField("S3", dp -> {
                if (dp instanceof PPValue) {
                    PPValue ppdp = (PPValue)dp;
                    for (PivotPoint pivpt : ppdp.LineValues) {
                        if (pivpt.Line != PPLine.S3) continue;
                        return pivpt.Value;
                    }
                }
                return null;
            }, value -> {
                try {
                    return PriceFormat.convertPriceToDisplayFormat(value, this.mSeries.getArgs().Market);
                }
                catch (Exception ex) {
                    Log.e("PP.DD", "getFormattedValue(), Error.", ex);
                    return Double.toString(value);
                }
            }, false, true));
            this.mDataDef.addField(new DataField("S4", dp -> {
                if (dp instanceof PPValue) {
                    PPValue ppdp = (PPValue)dp;
                    for (PivotPoint pivpt : ppdp.LineValues) {
                        if (pivpt.Line != PPLine.S4) continue;
                        return pivpt.Value;
                    }
                }
                return null;
            }, value -> {
                try {
                    return PriceFormat.convertPriceToDisplayFormat(value, this.mSeries.getArgs().Market);
                }
                catch (Exception ex) {
                    Log.e("PP.DD", "getFormattedValue(), Error.", ex);
                    return Double.toString(value);
                }
            }, false, true));
        }
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    public static enum PPMethod implements IEnum
    {
        Floor(1, "ppmethod_floor", 3),
        Woodie(3, "ppmethod_woodie", 4),
        Camarilla(4, "ppmethod_camarilla", 4),
        Demark(5, "ppmethod_demark", 1),
        Fibonacci(6, "ppmethod_fibonacci", 3),
        HLC(0, "ppmethod_hlc", 1),
        Custom(7, "ppmethod_custom", 4);

        private final int value;
        private final String descr_loc;
        private final int srlevels;
        private static Map<Integer, PPMethod> map;

        private PPMethod(int value, String descr_loc, int srlevels) {
            this.value = value;
            this.descr_loc = descr_loc;
            this.srlevels = srlevels;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public String getDescription() {
            return Resource.localizeString(this.descr_loc);
        }

        public int getSRLevels() {
            return this.srlevels;
        }

        public static PPMethod get(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, PPMethod>();
            for (PPMethod t : PPMethod.values()) {
                map.put(t.getValue(), t);
            }
        }
    }

    public static class PPValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final PivotPoint[] LineValues;
        public final int DataIndex;

        public PPValue(NDateTime time, PivotPoint[] values, int idx) {
            this.Time = time;
            this.LineValues = values;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            for (PivotPoint LineValue : this.LineValues) {
                if (LineValue.Line != PPLine.PP) continue;
                return LineValue.Value;
            }
            if (this.LineValues.length > 0) {
                return this.LineValues[0].Value;
            }
            return 0.0;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }

    public static class PivotPoint {
        public final PPLine Line;
        public final double Value;

        public PivotPoint(PPLine line, double value) {
            this.Line = line;
            this.Value = value;
        }
    }

    public static enum PPLine {
        R4,
        R3,
        R2,
        R1,
        PP,
        S1,
        S2,
        S3,
        S4,
        MidR4R3,
        MidR3R2,
        MidR2R1,
        MidR1PP,
        MidPPS1,
        MidS1S2,
        MidS2S3,
        MidS3S4;

    }
}

