/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

import com.t4login.Log;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataProvider;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.studies.computations.IComputation;
import com.t4login.application.chart.studies.computations.MAType;
import com.t4login.datetime.NDateTime;
import com.t4login.util.LinearRegression;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class MovingAverage
implements IComputation {
    private static final String TAG = "MovingAverage";
    private IDataProvider mDataProvider = null;
    private final DataField mField;
    private final MAType mMAType;
    private final int mPeriods;
    private final DataSeries<MAValue> mData;
    private int mFastSCPeriods = 1;
    private int mSlowSCPeriods = 1;
    MathContext mc = new MathContext(0, RoundingMode.HALF_EVEN);
    MovingAverage hmaWMA1 = null;
    MovingAverage hmaWMA2 = null;
    private DataDefinition mDataDef = null;

    public MovingAverage(IDataProvider provider, DataField field, MAType matype, int periods) {
        this(provider, field, matype, periods, new DataSeries<MAValue>());
    }

    public MovingAverage(IDataProvider provider, DataField field, MAType matype, int periods, DataSeries<MAValue> storage) {
        if (periods < 1) {
            throw new IllegalArgumentException(String.format("Moving average computation minimum periods value is 1. %d passed as parameter.", periods));
        }
        this.mDataProvider = provider;
        this.mField = field;
        this.mMAType = matype;
        this.mPeriods = periods;
        this.mData = storage;
    }

    public void setAMAPeriods(int fastSCPer, int slowSCPer) {
        this.mFastSCPeriods = fastSCPer;
        this.mSlowSCPeriods = slowSCPer;
    }

    @Override
    public void reCompute() {
        this.mData.clear();
        this.compute(null);
    }

    @Override
    public void update() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            MAValue startpt = (MAValue)this.mData.getLast();
            this.compute(startpt);
        }
    }

    @Override
    public void reset() {
        this.mData.clear();
    }

    private void compute(MAValue startpt) {
        if (this.mMAType == MAType.SMA) {
            this.computeSMA(startpt);
        } else if (this.mMAType == MAType.EMA) {
            this.computeEMA(startpt);
        } else if (this.mMAType == MAType.SMMA) {
            this.computeSMMA(startpt);
        } else if (this.mMAType == MAType.LWMA) {
            this.computeLWMA(startpt);
        } else if (this.mMAType == MAType.TMA) {
            this.computeTMA(startpt);
        } else if (this.mMAType == MAType.WilderMA) {
            this.computeWWMA(startpt);
        } else if (this.mMAType == MAType.LSMA) {
            this.computeLSMA(startpt);
        } else if (this.mMAType == MAType.HMA) {
            this.computeHMA(startpt);
        } else if (this.mMAType == MAType.Adaptive) {
            this.computeAMA(startpt);
        } else {
            Log.e(TAG, "compute(), MAType '" + this.mMAType.name() + "' is not implemented or supported.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeSMA(MAValue startpt) {
        IDataSource ds = this.mDataProvider.getDataSource();
        if (ds.getCount() < this.mPeriods) {
            return;
        }
        this.mData.beginUpdate();
        try {
            int startidx = 0;
            double acc = 0.0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
                acc = startpt.Accum;
            }
            for (int i = startidx; i < ds.getCount(); ++i) {
                Object dp = ds.get(i);
                double currvalue = this.mField.getDataPointValue((IDataPoint)dp);
                acc += currvalue;
                if (i < this.mPeriods - 1) continue;
                double sma = acc / (double)this.mPeriods;
                double dev = 0.0;
                if (this.mPeriods > 1) {
                    for (int j = 0; j < this.mPeriods; ++j) {
                        dev += Math.pow(this.mField.getDataPointValue((IDataPoint)ds.get(i - j)) - sma, 2.0);
                    }
                    dev /= (double)(this.mPeriods - 1);
                    dev = Math.sqrt(dev);
                }
                this.mData.addDataPoint(new MAValue(dp.getTime(), sma, acc - currvalue, dev, i));
                Object topBar = ds.get(i - this.mPeriods + 1);
                double topValue = this.mField.getDataPointValue((IDataPoint)topBar);
                acc -= topValue;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeSMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeEMA(MAValue startpt) {
        IDataSource ds = this.mDataProvider.getDataSource();
        this.mData.beginUpdate();
        try {
            double mult = 2.0 / ((double)this.mPeriods + 1.0);
            int startidx = 0;
            double prevema = 0.0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
                prevema = startpt.Accum;
            }
            for (int i = startidx; i < ds.getCount(); ++i) {
                Object bar = ds.get(i);
                double currvalue = this.mField.getDataPointValue((IDataPoint)bar);
                if (i == this.mPeriods - 1) {
                    double acc = 0.0;
                    for (int j = 0; j < this.mPeriods; ++j) {
                        double accvalue = this.mField.getDataPointValue((IDataPoint)ds.get(j));
                        acc += accvalue;
                    }
                    double ema = acc / (double)this.mPeriods;
                    this.mData.addDataPoint(new MAValue(bar.getTime(), ema, prevema, i));
                    prevema = ema;
                    continue;
                }
                if (i <= this.mPeriods - 1) continue;
                double ema = (currvalue - prevema) * mult + prevema;
                this.mData.addDataPoint(new MAValue(bar.getTime(), ema, prevema, i));
                prevema = ema;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeEMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeAMA(MAValue startpt) {
        IDataSource ds = this.mDataProvider.getDataSource();
        this.mData.beginUpdate();
        try {
            double fastC = 2.0 / ((double)this.mFastSCPeriods + 1.0);
            double slowC = 2.0 / ((double)this.mSlowSCPeriods + 1.0);
            double mult = 2.0 / ((double)this.mPeriods + 1.0);
            int startidx = 0;
            double prevema = 0.0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
                prevema = startpt.Accum;
            }
            for (int i = startidx; i < ds.getCount(); ++i) {
                Object bar = ds.get(i);
                double currvalue = this.mField.getDataPointValue((IDataPoint)bar);
                if (i == this.mPeriods - 1) {
                    double acc = 0.0;
                    for (int j = 0; j < this.mPeriods; ++j) {
                        double accvalue = this.mField.getDataPointValue((IDataPoint)ds.get(j));
                        acc += accvalue;
                    }
                    double ema = acc / (double)this.mPeriods;
                    this.mData.addDataPoint(new MAValue(bar.getTime(), ema, prevema, i));
                    prevema = ema;
                    continue;
                }
                if (i <= this.mPeriods - 1) continue;
                Object dsvalue2 = ds.get(i - this.mPeriods + 1);
                double pvalue = this.mField.getDataPointValue((IDataPoint)dsvalue2);
                double dir = currvalue - pvalue;
                double vol = 0.0;
                for (int j = i; j > i - this.mPeriods; --j) {
                    Object vval1 = ds.get(j);
                    double vv1value = this.mField.getDataPointValue((IDataPoint)vval1);
                    Object vval2 = ds.get(j - 1);
                    double vv2value = this.mField.getDataPointValue((IDataPoint)vval2);
                    vol += Math.abs(vv1value - vv2value);
                }
                double er = vol == 0.0 ? 0.0 : dir / vol;
                double ssc = er * (fastC - slowC) + slowC;
                double c = ssc * ssc;
                double ama = prevema + c * (currvalue - prevema);
                this.mData.addDataPoint(new MAValue(bar.getTime(), ama, prevema, i));
                prevema = ama;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeAMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeSMMA(MAValue startpt) {
        IDataSource ds = this.mDataProvider.getDataSource();
        if (ds.getCount() < this.mPeriods) {
            return;
        }
        this.mData.beginUpdate();
        try {
            int startidx = 0;
            double prevsmma = 0.0;
            double acc = 0.0;
            if (startpt != null && startidx >= this.mPeriods) {
                startidx = startpt.DataIndex - 1;
                MAValue prevma = (MAValue)this.mData.get(startidx);
                prevsmma = prevma.MA;
                acc = prevma.Accum;
            }
            for (int i = startidx; i < ds.getCount(); ++i) {
                Object bar = ds.get(i);
                double currvalue = this.mField.getDataPointValue((IDataPoint)bar);
                if (i < this.mPeriods - 1) {
                    acc += currvalue;
                    continue;
                }
                if (i == this.mPeriods - 1) {
                    double sma = (acc += currvalue) / (double)this.mPeriods;
                    this.mData.addDataPoint(new MAValue(bar.getTime(), sma, acc, i));
                    prevsmma = sma;
                    continue;
                }
                if (i <= this.mPeriods - 1) continue;
                acc = acc - prevsmma + currvalue;
                double smma = acc / (double)this.mPeriods;
                this.mData.addDataPoint(new MAValue(bar.getTime(), smma, acc, i));
                prevsmma = smma;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeSMMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeLWMA(MAValue startpt) {
        IDataSource ds = this.mDataProvider.getDataSource();
        if (ds.getCount() < this.mPeriods) {
            return;
        }
        this.mData.beginUpdate();
        try {
            double div = this.mPeriods * (this.mPeriods + 1) / 2;
            int startidx = 0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
            }
            for (int i = startidx; i < ds.getCount(); ++i) {
                if (i < this.mPeriods - 1) continue;
                double wsum = 0.0;
                for (int j = 0; j < this.mPeriods; ++j) {
                    double val = this.mField.getDataPointValue((IDataPoint)ds.get(i - j));
                    wsum += val * (double)(this.mPeriods - j);
                }
                double lwma = wsum / div;
                this.mData.addDataPoint(new MAValue(ds.get(i).getTime(), lwma, 0.0, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeLWMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeTMA(MAValue startpt) {
        IDataSource ds = this.mDataProvider.getDataSource();
        if (ds.getCount() < this.mPeriods) {
            return;
        }
        this.mData.beginUpdate();
        try {
            double[] weights = new double[this.mPeriods];
            double div = 0.0;
            for (int i = 0; i < this.mPeriods; ++i) {
                if (i < this.mPeriods / 2) {
                    weights[i] = i + 1;
                    div += weights[i];
                    continue;
                }
                weights[i] = this.mPeriods - i;
                div += weights[i];
            }
            int startidx = 0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
            }
            for (int i = startidx; i < ds.getCount(); ++i) {
                if (i < this.mPeriods - 1) continue;
                double wsum = 0.0;
                for (int j = 0; j < this.mPeriods; ++j) {
                    double val = this.mField.getDataPointValue((IDataPoint)ds.get(i - j));
                    wsum += val * weights[j];
                }
                double tma = wsum / div;
                this.mData.addDataPoint(new MAValue(ds.get(i).getTime(), tma, 0.0, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeTMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeWWMA(MAValue startpt) {
        IDataSource ds = this.mDataProvider.getDataSource();
        this.mData.beginUpdate();
        try {
            int startidx = 0;
            double prevma = 0.0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
                prevma = startpt.Accum;
            }
            for (int i = startidx; i < ds.getCount(); ++i) {
                Object bar = ds.get(i);
                double currvalue = this.mField.getDataPointValue((IDataPoint)bar);
                if (i == this.mPeriods - 1) {
                    double acc = 0.0;
                    for (int j = 0; j < this.mPeriods; ++j) {
                        double accvalue = this.mField.getDataPointValue((IDataPoint)ds.get(j));
                        acc += accvalue;
                    }
                    double wwma = acc / (double)this.mPeriods;
                    this.mData.addDataPoint(new MAValue(bar.getTime(), wwma, prevma, i));
                    prevma = wwma;
                    continue;
                }
                if (i <= this.mPeriods - 1) continue;
                double wwma = (currvalue + prevma * (double)(this.mPeriods - 1)) / (double)this.mPeriods;
                this.mData.addDataPoint(new MAValue(bar.getTime(), wwma, prevma, i));
                prevma = wwma;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeWWMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeLSMA(MAValue startpt) {
        IDataSource ds = this.mDataProvider.getDataSource();
        if (ds.getCount() < this.mPeriods) {
            return;
        }
        this.mData.beginUpdate();
        try {
            int startidx = 0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
            }
            for (int i = startidx; i < ds.getCount(); ++i) {
                if (i < this.mPeriods - 1) continue;
                Object bar = ds.get(i);
                LinearRegression reg = new LinearRegression();
                for (int j = 0; j < this.mPeriods; ++j) {
                    Object regdsvalue = ds.get(i - j);
                    double currvalue = this.mField.getDataPointValue((IDataPoint)regdsvalue);
                    reg.addPoint(j, currvalue);
                }
                reg.compute();
                if (reg.isComputed()) {
                    this.mData.addDataPoint(new MAValue(bar.getTime(), reg.a(), reg.b(), i));
                    continue;
                }
                Log.e(TAG, "computeLSMA(), Regression failed.");
                return;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeLSMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeHMA(MAValue startpt) {
        IDataSource ds = this.mDataProvider.getDataSource();
        if (ds.getCount() < this.mPeriods || this.mPeriods < 2) {
            return;
        }
        this.mData.beginUpdate();
        try {
            BigDecimal halfperBD = new BigDecimal(this.mPeriods).round(this.mc);
            int halfper = halfperBD.intValueExact();
            if (startpt == null || this.hmaWMA1 == null) {
                this.hmaWMA1 = new MovingAverage(this.mDataProvider, this.mField, MAType.LWMA, this.mPeriods);
                this.hmaWMA2 = new MovingAverage(this.mDataProvider, this.mField, MAType.LWMA, halfper);
            }
            this.hmaWMA1.update();
            this.hmaWMA2.update();
            int noff1 = this.mPeriods - 1;
            int noff2 = this.mPeriods - halfper - 1;
            BigDecimal nBD = new BigDecimal(Math.sqrt(this.mPeriods)).round(this.mc);
            int n = halfperBD.intValueExact();
            double div = (double)n * ((double)n + 1.0) / 2.0;
            int startidx = 0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
            }
            IDataSource wmaDS1 = this.hmaWMA1.getDataSource();
            IDataSource wmaDS2 = this.hmaWMA1.getDataSource();
            for (int i = startidx; i < ds.getCount(); ++i) {
                int eo = ds.getCount() - i;
                if (wmaDS1.getCount() < eo + n - 1 || wmaDS2.getCount() < eo + n - 1) continue;
                double wsum = 0.0;
                double wmaval1 = 0.0;
                for (int j = 0; j < n; ++j) {
                    wmaval1 = ((MAValue)wmaDS1.get((int)(wmaDS1.getCount() - eo - j))).MA;
                    double wmaval2 = ((MAValue)wmaDS2.get((int)(wmaDS2.getCount() - eo - j))).MA;
                    double val = 2.0 * wmaval2 - wmaval1;
                    wsum += val * (double)(n - j);
                }
                double lwma = wsum / div;
                this.mData.addDataPoint(new MAValue(ds.get(i).getTime(), lwma, 0.0, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeHMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDataDef == null) {
            this.mDataDef = new DataDefinition(TAG);
            this.mDataDef.addField(new DataField("MA", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof MAValue) {
                        MAValue maDP = (MAValue)dp;
                        return maDP.MA;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(this){

                @Override
                public String getFormattedValue(double value) {
                    return Double.toString(value);
                }
            }, true, true));
            this.mDataDef.addField(new DataField("STDDEV", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof MAValue) {
                        MAValue maDP = (MAValue)dp;
                        return maDP.StdDev;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(this){

                @Override
                public String getFormattedValue(double value) {
                    return Double.toString(value);
                }
            }, false, true));
        }
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    public static class MAValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double MA;
        public final double Accum;
        public final double StdDev;
        public final int DataIndex;

        public MAValue(NDateTime time, double ma, double acc, int idx) {
            this(time, ma, acc, 0.0, idx);
        }

        public MAValue(NDateTime time, double ma, double acc, double stddev, int idx) {
            this.Time = time;
            this.MA = ma;
            this.Accum = acc;
            this.StdDev = stddev;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.MA;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

