/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

import com.t4login.Resource;
import com.t4login.application.configuration.IEnum;
import java.util.HashMap;
import java.util.Map;

public enum MAPriceType implements IEnum
{
    Closing(0, "mapricetype_closing"),
    Typical(1, "mapricetype_typical"),
    Average(2, "mapricetype_average"),
    Weighted(3, "mapricetype_weighted"),
    Opening(4, "mapricetype_opening"),
    High(5, "mapricetype_high"),
    Low(6, "mapricetype_low");

    private final int value;
    private final String descr_loc;
    private static Map<Integer, MAPriceType> map;

    private MAPriceType(int value, String descr_loc) {
        this.value = value;
        this.descr_loc = descr_loc;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getDescription() {
        return Resource.localizeString(this.descr_loc);
    }

    public static MAPriceType get(int value) {
        return map.get(value);
    }

    static {
        map = new HashMap<Integer, MAPriceType>();
        for (MAPriceType t : MAPriceType.values()) {
            map.put(t.getValue(), t);
        }
    }
}

