/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

import com.t4login.Log;
import com.t4login.application.chart.IValueFormatter;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataProvider;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.studies.computations.IComputation;
import com.t4login.datetime.NDateTime;

public class HighLowAvg
implements IComputation {
    private static final String TAG = "HighLowAvg";
    private IDataProvider mProvider = null;
    private DataField mField1 = null;
    private DataField mField2 = null;
    private int mPeriods = 10;
    private DataSeries mData = new DataSeries();
    private IValueFormatter mValueFormatter = new IValueFormatter(this){

        @Override
        public String formatValue(double value) {
            return Double.toString(value);
        }
    };
    private DataDefinition mDataDef = null;

    public HighLowAvg(IDataProvider provider, DataField field1, DataField field2, int periods, int offset) {
        this.mProvider = provider;
        this.mField1 = field1;
        this.mField2 = field2;
        this.mPeriods = periods;
    }

    public HighLowAvg(IDataProvider provider, DataField field1, DataField field2, int periods, int offset, DataSeries storage) {
        this(provider, field1, field2, periods, offset);
        this.mData = storage;
    }

    public void setValueFormatter(IValueFormatter formatter) {
        this.mValueFormatter = formatter;
        this.mDataDef = null;
    }

    @Override
    public void reCompute() {
        this.mData.clear();
        this.compute(null);
    }

    @Override
    public void update() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            this.compute((HLAValue)this.mData.getLast());
        }
    }

    @Override
    public void reset() {
        this.mData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(HLAValue startpt) {
        IDataSource ds = this.mProvider.getDataSource();
        if (ds.getCount() == 0) {
            return;
        }
        int startidx = 0;
        if (startpt != null) {
            startidx = startpt.DataIndex;
        }
        this.mData.beginUpdate();
        try {
            int n = ds.getCount();
            for (int i = startidx; i < n; ++i) {
                if (i < this.mPeriods - 1) continue;
                Object dp = ds.get(i);
                Double highval = this.mField1.getDataPointValue((IDataPoint)dp);
                Double lowval = this.mField2.getDataPointValue((IDataPoint)dp);
                for (int j = 1; j < this.mPeriods; ++j) {
                    Object prevdp = ds.get(i - j);
                    Double prevhighval = this.mField1.getDataPointValue((IDataPoint)prevdp);
                    Double prevlowval = this.mField2.getDataPointValue((IDataPoint)prevdp);
                    highval = prevhighval > highval ? prevhighval : highval;
                    lowval = prevlowval < lowval ? prevlowval : lowval;
                }
                double avg = (highval + lowval) / 2.0;
                this.mData.addDataPoint(new HLAValue(dp.getTime(), highval, lowval, avg, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDataDef == null) {
            this.mDataDef = new DataDefinition(TAG);
            this.mDataDef.addField(new DataField("HIGH", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof HLAValue) {
                        HLAValue hlaDP = (HLAValue)dp;
                        return hlaDP.Highest;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    return HighLowAvg.this.mValueFormatter.formatValue(value);
                }
            }, false, false));
            this.mDataDef.addField(new DataField("LOW", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof HLAValue) {
                        HLAValue hlaDP = (HLAValue)dp;
                        return hlaDP.Lowest;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    return HighLowAvg.this.mValueFormatter.formatValue(value);
                }
            }, false, false));
            this.mDataDef.addField(new DataField("AVG", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof HLAValue) {
                        HLAValue hlaDP = (HLAValue)dp;
                        return hlaDP.Average;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    return HighLowAvg.this.mValueFormatter.formatValue(value);
                }
            }, true, false));
        }
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    public static class HLAValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double Highest;
        public final double Lowest;
        public final double Average;
        public final int DataIndex;

        public HLAValue(NDateTime time, double hh, double ll, double av, int idx) {
            this.Time = time;
            this.Highest = hh;
            this.Lowest = ll;
            this.Average = av;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.Average;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

