/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.application.chart.BarInterval;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.studies.computations.IComputation;
import com.t4login.application.chart.studies.computations.MAPriceType;
import com.t4login.application.configuration.IEnum;
import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;
import java.util.HashMap;
import java.util.Map;

public class HV
implements IComputation {
    private static final String TAG = "HV";
    private final BarDataSeries mSeries;
    private final DataSeries<HVValue> mData;
    private final int mPeriods;
    private final HVMethod mHVMethod;
    private final MAPriceType mPriceType;
    private final boolean mAnnualize = true;
    private final double mTP;
    private final double mAF;
    private DataDefinition mDataDef = null;

    public HV(BarDataSeries ser, HVMethod method, MAPriceType prctyp, int periods, BarInterval intvl) {
        this(ser, method, prctyp, periods, intvl, new DataSeries<HVValue>());
    }

    public HV(BarDataSeries ser, HVMethod method, MAPriceType prctyp, int periods, BarInterval intvl, DataSeries<HVValue> storage) {
        this.mSeries = ser;
        this.mData = storage;
        this.mPeriods = periods;
        this.mHVMethod = method;
        this.mPriceType = prctyp;
        switch (intvl.Interval) {
            case Year: {
                this.mTP = 1.0;
                this.mAF = 1.0;
                break;
            }
            case Month: {
                this.mTP = 12.0 / (double)intvl.Period;
                this.mAF = Math.sqrt(this.mTP);
                break;
            }
            case Week: {
                this.mTP = 52.0 / (double)intvl.Period;
                this.mAF = Math.sqrt(this.mTP);
                break;
            }
            case Day: {
                this.mTP = 252.0 / (double)intvl.Period;
                this.mAF = Math.sqrt(this.mTP);
                break;
            }
            case Tick: 
            case TickRange: 
            case Volume: {
                this.mTP = 1.0;
                this.mAF = 1.0;
                break;
            }
            default: {
                this.mTP = (double)intvl.intervalsBetween(NDateTime.today(), NDateTime.today().AddDays(1.0), NTimeSpan.Zero) * 252.0;
                this.mAF = Math.sqrt(this.mTP);
            }
        }
    }

    @Override
    public void reCompute() {
        this.mData.clear();
        this.compute(null);
    }

    @Override
    public void update() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            HVValue startpt = null;
            IBarDataPoint basept = this.mSeries.baseDataPoint;
            if (basept != null) {
                HVValue lastpt = (HVValue)this.mData.getLast();
                while (lastpt != null && lastpt.Time.compareTo(basept.getTime()) > 0) {
                    this.mData.removeDataPoint(lastpt);
                }
                startpt = lastpt = (HVValue)this.mData.getLast();
            }
            if (startpt == null) {
                startpt = (HVValue)this.mData.getLast();
            }
            this.compute(startpt);
        }
    }

    @Override
    public void reset() {
        this.mData.clear();
    }

    private void compute(HVValue startpt) {
        switch (this.mHVMethod) {
            case StdDev: {
                this.computeStdDev(startpt);
                break;
            }
            case Parkinson: {
                this.computeParkinson(startpt);
                break;
            }
            case GarmanKlass: {
                this.computeGarmanKlass(startpt);
                break;
            }
            case GarmanKlassYangZhang: {
                this.computeGarmanKlassYangZhang(startpt);
                break;
            }
            case RogersSatchell: {
                this.computeRogersSatchell(startpt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeStdDev(HVValue startpt) {
        int startidx = 1;
        double acc = 0.0;
        if (startpt != null) {
            startidx = startpt.DataIndex;
            acc = startpt.Acc;
        }
        this.mData.beginUpdate();
        try {
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                IBarDataPoint bar1 = this.mSeries.get(i);
                IBarDataPoint bar2 = this.mSeries.get(i - 1);
                double xi = HV.ComputeChange(HV.getBarPrice(bar1, this.mPriceType), HV.getBarPrice(bar2, this.mPriceType));
                acc += xi;
                if (i < this.mPeriods) continue;
                double mean = acc / (double)this.mPeriods;
                double dev = 0.0;
                if (this.mPeriods > 1) {
                    for (int j = 0; j < this.mPeriods; ++j) {
                        IBarDataPoint barj1 = this.mSeries.get(i - j);
                        IBarDataPoint barj2 = this.mSeries.get(i - j - 1);
                        double xj = HV.ComputeChange(HV.getBarPrice(barj1, this.mPriceType), HV.getBarPrice(barj2, this.mPriceType));
                        dev += Math.pow(xj - mean, 2.0);
                    }
                    dev /= (double)(this.mPeriods - 1);
                    dev = Math.sqrt(dev);
                }
                double hv = dev * 100.0;
                this.mData.addDataPoint(new HVValue(bar1.getTime(), hv *= this.mAF, acc - xi, i));
                IBarDataPoint baracc1 = this.mSeries.get(i - this.mPeriods + 1);
                IBarDataPoint baracc2 = this.mSeries.get(i - this.mPeriods + 1 - 1);
                acc -= HV.ComputeChange(HV.getBarPrice(baracc1, this.mPriceType), HV.getBarPrice(baracc2, this.mPriceType));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeStdDev(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    private static double ComputeChange(double v1, double v2) {
        double xi = (v1 - v2) / v2;
        return xi;
    }

    private static double getBarPrice(IBarDataPoint bar, MAPriceType prctyp) {
        if (prctyp == MAPriceType.Opening) {
            return bar.getOpen();
        }
        if (prctyp == MAPriceType.High) {
            return bar.getHigh();
        }
        if (prctyp == MAPriceType.Low) {
            return bar.getLow();
        }
        if (prctyp == MAPriceType.Closing) {
            return bar.getClose();
        }
        if (prctyp == MAPriceType.Average) {
            return (bar.getHigh() + bar.getLow()) / 2.0;
        }
        if (prctyp == MAPriceType.Typical) {
            return (bar.getHigh() + bar.getLow() + bar.getClose()) / 3.0;
        }
        if (prctyp == MAPriceType.Weighted) {
            return (bar.getHigh() + bar.getLow() + bar.getClose() + bar.getClose()) / 4.0;
        }
        return bar.getClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeParkinson(HVValue startpt) {
        int startidx = 1;
        double acc = 0.0;
        double norm = 1.0 / ((double)(4 * this.mPeriods) * Math.log(2.0));
        if (startpt != null) {
            startidx = startpt.DataIndex;
            acc = startpt.Acc;
        }
        this.mData.beginUpdate();
        try {
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                IBarDataPoint bar = this.mSeries.get(i);
                double xi = Math.pow(Math.log(bar.getHigh() / bar.getLow()), 2.0);
                acc += xi;
                if (i < this.mPeriods) continue;
                double hv = Math.sqrt(acc * norm);
                this.mData.addDataPoint(new HVValue(bar.getTime(), hv *= this.mAF, acc - xi, i));
                IBarDataPoint baracc = this.mSeries.get(i - this.mPeriods + 1);
                acc -= Math.pow(Math.log(baracc.getHigh() / baracc.getLow()), 2.0);
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeParkinson(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeRogersSatchell(HVValue startpt) {
        int startidx = 1;
        double acc = 0.0;
        double norm = 1.0 / (double)this.mPeriods;
        if (startpt != null) {
            startidx = startpt.DataIndex;
            acc = startpt.Acc;
        }
        this.mData.beginUpdate();
        try {
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                IBarDataPoint bar = this.mSeries.get(i);
                double lnHC = Math.log(bar.getHigh() / bar.getClose());
                double lnHO = Math.log(bar.getHigh() / bar.getOpen());
                double lnLC = Math.log(bar.getLow() / bar.getClose());
                double lnLO = Math.log(bar.getLow() / bar.getOpen());
                double xi = lnHC * lnHO + lnLC * lnLO;
                acc += xi;
                if (i < this.mPeriods) continue;
                double hv = Math.sqrt(acc * norm);
                this.mData.addDataPoint(new HVValue(bar.getTime(), hv *= this.mAF, acc - xi, i));
                IBarDataPoint baracc = this.mSeries.get(i - this.mPeriods + 1);
                double lnHCacc = Math.log(baracc.getHigh() / baracc.getClose());
                double lnHOacc = Math.log(baracc.getHigh() / baracc.getOpen());
                double lnLCacc = Math.log(baracc.getLow() / baracc.getClose());
                double lnLOacc = Math.log(baracc.getLow() / baracc.getOpen());
                double xiacc = lnHCacc * lnHOacc + lnLCacc * lnLOacc;
                acc -= xiacc;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeRogersSatchell(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeGarmanKlass(HVValue startpt) {
        int startidx = 1;
        double acc = 0.0;
        double norm = 1.0 / (double)this.mPeriods;
        if (startpt != null) {
            startidx = startpt.DataIndex;
            acc = startpt.Acc;
        }
        this.mData.beginUpdate();
        try {
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                IBarDataPoint bar = this.mSeries.get(i);
                IBarDataPoint barp = this.mSeries.get(i - 1);
                double O = barp.getClose();
                double H = bar.getHigh();
                double L = bar.getLow();
                double C = bar.getClose();
                double lnHL = Math.log(H / L);
                double lnCO = Math.log(C / O);
                double lnHLO = Math.log(H * L / Math.pow(O, 2.0));
                double lnHO = Math.log(H / O);
                double lnLO = Math.log(L / O);
                double xi = 0.511 * Math.pow(lnHL, 2.0) - 0.019 * lnCO * lnHLO - 2.0 * lnHO * lnLO;
                acc += xi;
                if (i < this.mPeriods) continue;
                double hv = Math.sqrt(acc * norm);
                this.mData.addDataPoint(new HVValue(bar.getTime(), hv *= this.mAF, acc - xi, i));
                IBarDataPoint baracc = this.mSeries.get(i - this.mPeriods + 1);
                IBarDataPoint baraccp = this.mSeries.get(i - this.mPeriods + 1 - 1);
                double Oacc = baraccp.getClose();
                double Hacc = baracc.getHigh();
                double Lacc = baracc.getLow();
                double Cacc = baracc.getClose();
                double lnHLacc = Math.log(Hacc / Lacc);
                double lnCOacc = Math.log(Cacc / Oacc);
                double lnHLOacc = Math.log(Hacc * Lacc / Math.pow(Oacc, 2.0));
                double lnHOacc = Math.log(Hacc / Oacc);
                double lnLOacc = Math.log(Lacc / Oacc);
                double xiacc = 0.511 * Math.pow(lnHLacc, 2.0) - 0.019 * lnCOacc * lnHLOacc - 2.0 * lnHOacc * lnLOacc;
                acc -= xiacc;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeGarmanKlass(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeGarmanKlassYangZhang(HVValue startpt) {
        int startidx = 1;
        double acc = 0.0;
        double norm = this.mTP / (double)this.mPeriods;
        if (startpt != null) {
            startidx = startpt.DataIndex;
            acc = startpt.Acc;
        }
        this.mData.beginUpdate();
        try {
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                IBarDataPoint bar = this.mSeries.get(i);
                IBarDataPoint barp = this.mSeries.get(i - 1);
                double O = bar.getOpen();
                double H = bar.getHigh();
                double L = bar.getLow();
                double C = bar.getClose();
                double pC = barp.getClose();
                double lnOpC = Math.log(O / pC);
                double lnHL = Math.log(H / L);
                double lnCO = Math.log(C / O);
                double xi = Math.pow(lnOpC, 2.0) + 0.5 * Math.pow(lnHL, 2.0) - (2.0 * Math.log(2.0) - 1.0) * Math.pow(lnCO, 2.0);
                acc += xi;
                if (i < this.mPeriods) continue;
                double hv = Math.sqrt(acc * norm);
                this.mData.addDataPoint(new HVValue(bar.getTime(), hv *= this.mAF, acc - xi, i));
                IBarDataPoint baracc = this.mSeries.get(i - this.mPeriods + 1);
                IBarDataPoint baraccp = this.mSeries.get(i - this.mPeriods + 1 - 1);
                double Oacc = baracc.getOpen();
                double Hacc = baracc.getHigh();
                double Lacc = baracc.getLow();
                double Cacc = baracc.getClose();
                double pCacc = baraccp.getClose();
                double lnOpCacc = Math.log(Oacc / pCacc);
                double lnHLacc = Math.log(Hacc / Lacc);
                double lnCOacc = Math.log(Cacc / Oacc);
                double xiacc = Math.pow(lnOpCacc, 2.0) + 0.5 * Math.pow(lnHLacc, 2.0) - (2.0 * Math.log(2.0) - 1.0) * Math.pow(lnCOacc, 2.0);
                acc -= xiacc;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeGarmanKlassYangZhang(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        this.mDataDef = new DataDefinition(TAG);
        this.mDataDef.addField(new DataField(TAG, new DataField.DataFieldReader(this){

            @Override
            public Double getFieldValue(IDataPoint dp) {
                if (dp instanceof HVValue) {
                    HVValue trdp = (HVValue)dp;
                    return trdp.HV;
                }
                return null;
            }
        }, new DataField.DataFieldFormatter(this){

            @Override
            public String getFormattedValue(double value) {
                return String.format("%.2f", value);
            }
        }, true, false));
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    public static enum HVMethod implements IEnum
    {
        StdDev(0, "hvolmethod_stddev"),
        Parkinson(1, "hvolmethod_parkinson"),
        GarmanKlass(2, "hvolmethod_garmanklass"),
        GarmanKlassYangZhang(3, "hvolmethod_garmanklassyangzhang"),
        RogersSatchell(4, "hvolmethod_rogerssatchell");

        private final int value;
        private final String descr_loc;
        private static Map<Integer, HVMethod> map;

        private HVMethod(int value, String descr_loc) {
            this.value = value;
            this.descr_loc = descr_loc;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public String getDescription() {
            return Resource.localizeString(this.descr_loc);
        }

        public static HVMethod get(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, HVMethod>();
            for (HVMethod t : HVMethod.values()) {
                map.put(t.getValue(), t);
            }
        }
    }

    public static class HVValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double HV;
        public final double Acc;
        public final int DataIndex;

        public HVValue(NDateTime time, double hv, double acc, int idx) {
            this.Time = time;
            this.HV = hv;
            this.Acc = acc;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.HV;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

