/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

import com.t4login.Log;
import com.t4login.application.chart.IValueFormatter;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataProvider;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.studies.computations.IComputation;
import com.t4login.datetime.NDateTime;

public class Difference
implements IComputation {
    private static final String TAG = "Difference";
    private IDataProvider mProvider1 = null;
    private DataField mField1 = null;
    private IDataProvider mProvider2 = null;
    private DataField mField2 = null;
    private DifferenceType mDiffType;
    private DataSeries mData = new DataSeries();
    private IValueFormatter mValueFormatter = new IValueFormatter(this){

        @Override
        public String formatValue(double value) {
            return Double.toString(value);
        }
    };
    private DataDefinition mDataDef = null;

    public Difference(IDataProvider provider1, DataField field1, IDataProvider provider2, DataField field2, DifferenceType difftype) {
        this.mProvider1 = provider1;
        this.mField1 = field1;
        this.mProvider2 = provider2;
        this.mField2 = field2;
        this.mDiffType = difftype;
    }

    public Difference(IDataProvider provider1, DataField field1, IDataProvider provider2, DataField field2, DifferenceType difftype, DataSeries storage) {
        this(provider1, field1, provider2, field2, difftype);
        this.mData = storage;
    }

    public void setValueFormatter(IValueFormatter formatter) {
        this.mValueFormatter = formatter;
        this.mDataDef = null;
    }

    @Override
    public void reCompute() {
        this.mData.clear();
        this.compute(null);
    }

    @Override
    public void update() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            this.compute((DiffValue)this.mData.getLast());
        }
    }

    @Override
    public void reset() {
        this.mData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(DiffValue startpt) {
        IDataSource ds1 = this.mProvider1.getDataSource();
        IDataSource ds2 = this.mProvider2.getDataSource();
        if (ds1.getCount() == 0 || ds1.getCount() == 0) {
            return;
        }
        this.mData.beginUpdate();
        try {
            Object dsval1 = startpt != null ? ds1.get(startpt.Time) : ds1.getFirst();
            while (dsval1 != null) {
                Object dsval2 = ds2.get(dsval1.getTime());
                if (dsval2 != null) {
                    Double val1 = this.mField1.getDataPointValue((IDataPoint)dsval1);
                    Double val2 = this.mField2.getDataPointValue((IDataPoint)dsval2);
                    Double diff = val1 - val2;
                    if (this.mDiffType == DifferenceType.AbsoluteValue) {
                        diff = Math.abs(diff);
                    } else if (this.mDiffType == DifferenceType.PercentDifference) {
                        diff = 100.0 * ((val1 - val2) / val2);
                    }
                    this.mData.addDataPoint(new DiffValue(dsval1.getTime(), diff));
                }
                dsval1 = ds1.getNext(dsval1.getTime());
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDataDef == null) {
            this.mDataDef = new DataDefinition(TAG);
            this.mDataDef.addField(new DataField("DIFF", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof DiffValue) {
                        DiffValue maDP = (DiffValue)dp;
                        return maDP.Difference;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    return Difference.this.mValueFormatter.formatValue(value);
                }
            }, true, true));
        }
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    public static enum DifferenceType {
        Difference,
        AbsoluteValue,
        PercentDifference;

    }

    public static class DiffValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double Difference;

        public DiffValue(NDateTime time, double diff) {
            this.Time = time;
            this.Difference = diff;
        }

        @Override
        public double getValue() {
            return this.Difference;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

