/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

import com.t4login.Log;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.studies.computations.IComputation;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.PriceFormat;

public class BarTR
implements IComputation {
    private static final String TAG = "BarTR";
    private final BarDataSeries mSeries;
    private final DataSeries<TRValue> mData;
    private DataDefinition mDataDef = null;

    public BarTR(BarDataSeries ser) {
        this(ser, new DataSeries<TRValue>());
    }

    public BarTR(BarDataSeries ser, DataSeries<TRValue> storage) {
        this.mSeries = ser;
        this.mData = storage;
    }

    @Override
    public void reCompute() {
        this.mData.clear();
        this.compute(null);
    }

    @Override
    public void update() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            TRValue startpt = null;
            IBarDataPoint basept = this.mSeries.baseDataPoint;
            if (basept != null) {
                TRValue lastpt = (TRValue)this.mData.getLast();
                while (lastpt != null && lastpt.Time.compareTo(basept.getTime()) > 0) {
                    this.mData.removeDataPoint(lastpt);
                }
                startpt = lastpt = (TRValue)this.mData.getLast();
            }
            if (startpt == null) {
                startpt = (TRValue)this.mData.getLast();
            }
            this.compute(startpt);
        }
    }

    @Override
    public void reset() {
        this.mData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(TRValue startpt) {
        if (this.mSeries.getCount() < 1) {
            return;
        }
        int startidx = 0;
        if (startpt != null) {
            startidx = startpt.DataIndex;
        }
        this.mData.beginUpdate();
        try {
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                IBarDataPoint bar;
                if (i == 0) {
                    bar = this.mSeries.get(i);
                    double high = bar.getHigh();
                    double low = bar.getLow();
                    double close = bar.getClose();
                    double tr = Math.abs(high - low);
                    double bp = close - low;
                    this.mData.addDataPoint(new TRValue(bar.getTime(), tr, low, bp, i));
                    continue;
                }
                bar = this.mSeries.get(i);
                IBarDataPoint prevBar = this.mSeries.get(i - 1);
                double high = bar.getHigh();
                double low = bar.getLow();
                double close = bar.getClose();
                double prevclose = prevBar.getClose();
                double hl = high - low;
                double abshpc = Math.abs(high - prevclose);
                double abslpc = Math.abs(low - prevclose);
                double tr = Math.max(hl, abshpc);
                tr = Math.max(tr, abslpc);
                double tl = Math.min(low, prevclose);
                double bp = close - tl;
                this.mData.addDataPoint(new TRValue(bar.getTime(), tr, tl, bp, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "compute(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        this.mDataDef = new DataDefinition(TAG);
        this.mDataDef.addField(new DataField("TR", new DataField.DataFieldReader(this){

            @Override
            public Double getFieldValue(IDataPoint dp) {
                if (dp instanceof TRValue) {
                    TRValue trdp = (TRValue)dp;
                    return trdp.TR;
                }
                return null;
            }
        }, new DataField.DataFieldFormatter(){

            @Override
            public String getFormattedValue(double value) {
                try {
                    return PriceFormat.convertPriceToDisplayFormat(value, BarTR.this.mSeries.getArgs().Market);
                }
                catch (Exception ex) {
                    Log.e("BarTR.DD", "getFormattedValue(), Error.", ex);
                    return Double.toString(value);
                }
            }
        }, true, true));
        this.mDataDef.addField(new DataField("TL", new DataField.DataFieldReader(this){

            @Override
            public Double getFieldValue(IDataPoint dp) {
                if (dp instanceof TRValue) {
                    TRValue trdp = (TRValue)dp;
                    return trdp.TL;
                }
                return null;
            }
        }, new DataField.DataFieldFormatter(){

            @Override
            public String getFormattedValue(double value) {
                try {
                    return PriceFormat.convertPriceToDisplayFormat(value, BarTR.this.mSeries.getArgs().Market);
                }
                catch (Exception ex) {
                    Log.e("BarTR.DD", "getFormattedValue(), Error.", ex);
                    return Double.toString(value);
                }
            }
        }, false, true));
        this.mDataDef.addField(new DataField("BP", new DataField.DataFieldReader(this){

            @Override
            public Double getFieldValue(IDataPoint dp) {
                if (dp instanceof TRValue) {
                    TRValue trdp = (TRValue)dp;
                    return trdp.BP;
                }
                return null;
            }
        }, new DataField.DataFieldFormatter(){

            @Override
            public String getFormattedValue(double value) {
                try {
                    return PriceFormat.convertPriceToDisplayFormat(value, BarTR.this.mSeries.getArgs().Market);
                }
                catch (Exception ex) {
                    Log.e("BarTR.DD", "getFormattedValue(), Error.", ex);
                    return Double.toString(value);
                }
            }
        }, false, true));
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    public static class TRValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double TR;
        public final double TL;
        public final double BP;
        public final int DataIndex;

        public TRValue(NDateTime time, double tr, double tl, double bp, int idx) {
            this.Time = time;
            this.TR = tr;
            this.TL = tl;
            this.BP = bp;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.TR;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

