/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

import com.t4login.Log;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.studies.computations.IComputation;
import com.t4login.application.chart.studies.computations.MAPriceType;
import com.t4login.application.settings.AppSettings;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;

public class BarRateOfChange
implements IComputation {
    private static final String TAG = "BarRateOfChange";
    private final BarDataSeries mSeries;
    private final DataSeries<ROCValue> mData;
    private final MAPriceType mPriceType;
    private final int mPeriods;
    private DataDefinition mDataDef = null;

    public BarRateOfChange(BarDataSeries ser, MAPriceType pricetype, int periods) {
        this(ser, pricetype, periods, new DataSeries<ROCValue>());
    }

    public BarRateOfChange(BarDataSeries ser, MAPriceType pricetype, int periods, DataSeries<ROCValue> storage) {
        this.mSeries = ser;
        this.mData = storage;
        this.mPriceType = pricetype;
        this.mPeriods = periods;
    }

    @Override
    public void reCompute() {
        this.mData.clear();
        this.compute(null);
    }

    @Override
    public void update() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            ROCValue startpt = null;
            IBarDataPoint basept = this.mSeries.baseDataPoint;
            if (basept != null) {
                ROCValue lastpt = (ROCValue)this.mData.getLast();
                while (lastpt != null && lastpt.Time.compareTo(basept.getTime()) > 0) {
                    this.mData.removeDataPoint(lastpt);
                }
                startpt = lastpt = (ROCValue)this.mData.getLast();
            }
            if (startpt == null) {
                startpt = (ROCValue)this.mData.getLast();
            }
            this.compute(startpt);
        }
    }

    @Override
    public void reset() {
        this.mData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(ROCValue startpt) {
        if (this.mSeries.getCount() < this.mPeriods) {
            return;
        }
        this.mData.beginUpdate();
        try {
            int startidx = this.mPeriods;
            if (startpt != null) {
                startidx = startpt.DataIndex;
            }
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                IBarDataPoint bar1 = this.mSeries.get(i);
                IBarDataPoint bar2 = this.mSeries.get(i - this.mPeriods);
                double value1 = this.getBarPrice(bar1);
                double value2 = this.getBarPrice(bar2);
                double roc = 100.0 * ((value1 - value2) / value2);
                this.mData.addDataPoint(new ROCValue(bar1.getTime(), roc, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "compute(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    private double getBarPrice(IBarDataPoint bar) {
        if (this.mPriceType == MAPriceType.Opening) {
            return bar.getOpen();
        }
        if (this.mPriceType == MAPriceType.High) {
            return bar.getHigh();
        }
        if (this.mPriceType == MAPriceType.Low) {
            return bar.getLow();
        }
        if (this.mPriceType == MAPriceType.Closing) {
            return bar.getClose();
        }
        if (this.mPriceType == MAPriceType.Average) {
            return (bar.getHigh() + bar.getLow()) / 2.0;
        }
        if (this.mPriceType == MAPriceType.Typical) {
            return (bar.getHigh() + bar.getLow() + bar.getClose()) / 3.0;
        }
        if (this.mPriceType == MAPriceType.Weighted) {
            return (bar.getHigh() + bar.getLow() + bar.getClose() + bar.getClose()) / 4.0;
        }
        return bar.getClose();
    }

    @Override
    public DataDefinition getDataDefinition() {
        this.mDataDef = new DataDefinition("ROC");
        this.mDataDef.addField(new DataField("ROC", new DataField.DataFieldReader(this){

            @Override
            public Double getFieldValue(IDataPoint dp) {
                if (dp instanceof ROCValue) {
                    ROCValue trdp = (ROCValue)dp;
                    return trdp.ROC;
                }
                return null;
            }
        }, new DataField.DataFieldFormatter(){

            @Override
            public String getFormattedValue(double value) {
                try {
                    return PriceFormat.convertPriceToDisplayFormat(Price.of(value), (IPriceFormatArgs)BarRateOfChange.this.mSeries.getArgs().Market, AppSettings.instance.MarketData.PriceDisplay);
                }
                catch (Exception ex) {
                    Log.e("BarRateOfChange.DD", "getFormattedValue(), Error.", ex);
                    return Double.toString(value);
                }
            }
        }, true, true));
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    public static class ROCValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double ROC;
        public final int DataIndex;

        public ROCValue(NDateTime time, double roc, int idx) {
            this.Time = time;
            this.ROC = roc;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.ROC;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

