/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

import com.t4login.Log;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.studies.computations.IComputation;
import com.t4login.datetime.NDateTime;

public class BarRSI
implements IComputation {
    private static final String TAG = "BarRSI";
    private final BarDataSeries mSeries;
    private final DataSeries<RSIValue> mData;
    private final int mPeriods;
    private DataDefinition mDataDef = null;

    public BarRSI(BarDataSeries ser, int periods) {
        this(ser, periods, new DataSeries<RSIValue>());
    }

    public BarRSI(BarDataSeries ser, int periods, DataSeries<RSIValue> storage) {
        this.mSeries = ser;
        this.mData = storage;
        this.mPeriods = periods;
    }

    @Override
    public void reCompute() {
        this.mData.clear();
        this.compute(null);
    }

    @Override
    public void update() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            RSIValue startpt = null;
            IBarDataPoint basept = this.mSeries.baseDataPoint;
            if (basept != null) {
                RSIValue lastpt = (RSIValue)this.mData.getLast();
                while (lastpt != null && lastpt.Time.compareTo(basept.getTime()) > 0) {
                    this.mData.removeDataPoint(lastpt);
                }
                startpt = lastpt = (RSIValue)this.mData.getLast();
            }
            if (startpt == null) {
                startpt = (RSIValue)this.mData.getLast();
            }
            this.compute(startpt);
        }
    }

    @Override
    public void reset() {
        this.mData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(RSIValue startpt) {
        if (this.mSeries.getCount() < this.mPeriods) {
            return;
        }
        int startidx = 1;
        double advs = 0.0;
        double losses = 0.0;
        double avggain = 0.0;
        double avgloss = 0.0;
        if (startpt != null) {
            startidx = startpt.DataIndex;
            advs = startpt.GainAcc;
            losses = startpt.LossAcc;
            avggain = startpt.AvgGainAcc;
            avgloss = startpt.AvgLossAcc;
        }
        this.mData.beginUpdate();
        try {
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                IBarDataPoint bar = this.mSeries.get(i);
                IBarDataPoint prevBar = this.mSeries.get(i - 1);
                double close = bar.getClose();
                double prevclose = prevBar.getClose();
                double adv = Math.abs(Math.max(0.0, close - prevclose));
                double loss = Math.abs(Math.min(0.0, close - prevclose));
                advs += adv;
                losses += loss;
                if (i == this.mPeriods) {
                    avggain = advs / (double)this.mPeriods;
                    avgloss = losses / (double)this.mPeriods;
                    double rsi = 100.0;
                    if (avgloss != 0.0) {
                        double rs = avggain / avgloss;
                        rsi = 100.0 - 100.0 / (1.0 + rs);
                    }
                    this.mData.addDataPoint(new RSIValue(bar.getTime(), rsi, advs - adv, losses - loss, avggain, avgloss, i));
                    continue;
                }
                if (i <= this.mPeriods) continue;
                double prevavggain = avggain;
                double prevavgloss = avgloss;
                avggain = (avggain * (double)(this.mPeriods - 1) + adv) / (double)this.mPeriods;
                avgloss = (avgloss * (double)(this.mPeriods - 1) + loss) / (double)this.mPeriods;
                double rsi = 100.0;
                if (avgloss != 0.0) {
                    double rs = avggain / avgloss;
                    rsi = 100.0 - 100.0 / (1.0 + rs);
                }
                this.mData.addDataPoint(new RSIValue(bar.getTime(), rsi, advs - adv, losses - loss, prevavggain, prevavgloss, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "compute(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        this.mDataDef = new DataDefinition(TAG);
        this.mDataDef.addField(new DataField("RSI", new DataField.DataFieldReader(this){

            @Override
            public Double getFieldValue(IDataPoint dp) {
                if (dp instanceof RSIValue) {
                    RSIValue trdp = (RSIValue)dp;
                    return trdp.RSI;
                }
                return null;
            }
        }, new DataField.DataFieldFormatter(this){

            @Override
            public String getFormattedValue(double value) {
                return String.format("%.2f", value);
            }
        }, true, false));
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    public static class RSIValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double RSI;
        public final double GainAcc;
        public final double LossAcc;
        public final double AvgGainAcc;
        public final double AvgLossAcc;
        public final int DataIndex;

        public RSIValue(NDateTime time, double rsi, double gainacc, double lossacc, double avggainacc, double avglossacc, int idx) {
            this.Time = time;
            this.RSI = rsi;
            this.GainAcc = gainacc;
            this.LossAcc = lossacc;
            this.AvgGainAcc = avggainacc;
            this.AvgLossAcc = avglossacc;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.RSI;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

