/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies.computations;

import com.t4login.Log;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.studies.computations.IComputation;
import com.t4login.application.chart.studies.computations.MAPriceType;
import com.t4login.application.chart.studies.computations.MAType;
import com.t4login.application.settings.AppSettings;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.util.LinearRegression;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class BarMovingAverage
implements IComputation {
    private static final String TAG = "BarMovingAverage";
    private final BarDataSeries mSeries;
    private final MAType mMAType;
    private final MAPriceType mPriceType;
    private final int mPeriods;
    private final DataSeries<MAValue> mData;
    private int mFastSCPeriods = 1;
    private int mSlowSCPeriods = 1;
    MathContext mc = new MathContext(0, RoundingMode.HALF_EVEN);
    BarMovingAverage hmaWMA1 = null;
    BarMovingAverage hmaWMA2 = null;
    private DataDefinition mDataDef = null;

    public BarMovingAverage(BarDataSeries ser, MAType matype, MAPriceType pricetype, int periods) {
        this(ser, matype, pricetype, periods, new DataSeries<MAValue>());
    }

    public BarMovingAverage(BarDataSeries ser, MAType matype, MAPriceType pricetype, int periods, DataSeries<MAValue> storage) {
        if (periods < 1) {
            throw new IllegalArgumentException(String.format("Moving average computation minimum periods value is 1. %d passed as parameter.", periods));
        }
        this.mSeries = ser;
        this.mMAType = matype;
        this.mPriceType = pricetype;
        this.mPeriods = periods;
        this.mData = storage;
    }

    public void setAMAPeriods(int fastSCPer, int slowSCPer) {
        this.mFastSCPeriods = fastSCPer;
        this.mSlowSCPeriods = slowSCPer;
    }

    @Override
    public void reCompute() {
        this.mData.clear();
        this.compute(null);
    }

    @Override
    public void update() {
        if (this.mData.getCount() == 0) {
            this.compute(null);
        } else {
            MAValue startpt = null;
            IBarDataPoint basept = this.mSeries.baseDataPoint;
            if (basept != null) {
                MAValue lastpt = (MAValue)this.mData.getLast();
                while (lastpt != null && lastpt.Time.compareTo(basept.getTime()) > 0) {
                    this.mData.removeDataPoint(lastpt);
                }
                startpt = lastpt = (MAValue)this.mData.getLast();
            }
            if (startpt == null) {
                startpt = (MAValue)this.mData.getLast();
            }
            this.compute(startpt);
        }
    }

    @Override
    public void reset() {
        this.mData.clear();
    }

    private void compute(MAValue startpt) {
        if (this.mMAType == MAType.SMA) {
            this.computeSMA(startpt);
        } else if (this.mMAType == MAType.EMA) {
            this.computeEMA(startpt);
        } else if (this.mMAType == MAType.SMMA) {
            this.computeSMMA(startpt);
        } else if (this.mMAType == MAType.LWMA) {
            this.computeLWMA(startpt);
        } else if (this.mMAType == MAType.TMA) {
            this.computeTMA(startpt);
        } else if (this.mMAType == MAType.WilderMA) {
            this.computeWWMA(startpt);
        } else if (this.mMAType == MAType.LSMA) {
            this.computeLSMA(startpt);
        } else if (this.mMAType == MAType.HMA) {
            this.computeHMA(startpt);
        } else if (this.mMAType == MAType.Adaptive) {
            this.computeAMA(startpt);
        } else {
            Log.e(TAG, "compute(), MAType '" + this.mMAType.name() + "' is not implemented or supported.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeSMA(MAValue startpt) {
        if (this.mSeries.getCount() < this.mPeriods) {
            return;
        }
        this.mData.beginUpdate();
        try {
            int startidx = 0;
            double acc = 0.0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
                acc = startpt.Accum;
            }
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                IBarDataPoint bar = this.mSeries.get(i);
                double currvalue = this.getBarPrice(bar);
                acc += currvalue;
                if (i < this.mPeriods - 1) continue;
                double sma = acc / (double)this.mPeriods;
                double dev = 0.0;
                if (this.mPeriods > 1) {
                    for (int j = 0; j < this.mPeriods; ++j) {
                        dev += Math.pow(this.getBarPrice(this.mSeries.get(i - j)) - sma, 2.0);
                    }
                    dev /= (double)(this.mPeriods - 1);
                    dev = Math.sqrt(dev);
                }
                this.mData.addDataPoint(new MAValue(bar.getTime(), sma, acc - currvalue, dev, i));
                IBarDataPoint topBar = this.mSeries.get(i - this.mPeriods + 1);
                double topValue = this.getBarPrice(topBar);
                acc -= topValue;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeSMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeEMA(MAValue startpt) {
        this.mData.beginUpdate();
        try {
            double mult = 2.0 / ((double)this.mPeriods + 1.0);
            int startidx = 0;
            double prevema = 0.0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
                prevema = startpt.Accum;
            }
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                IBarDataPoint bar = this.mSeries.get(i);
                double currvalue = this.getBarPrice(bar);
                if (i == this.mPeriods - 1) {
                    double acc = 0.0;
                    for (int j = 0; j < this.mPeriods; ++j) {
                        double accvalue = this.getBarPrice(this.mSeries.get(j));
                        acc += accvalue;
                    }
                    double ema = acc / (double)this.mPeriods;
                    this.mData.addDataPoint(new MAValue(bar.getTime(), ema, prevema, i));
                    prevema = ema;
                    continue;
                }
                if (i <= this.mPeriods - 1) continue;
                double ema = (currvalue - prevema) * mult + prevema;
                this.mData.addDataPoint(new MAValue(bar.getTime(), ema, prevema, i));
                prevema = ema;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeEMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeAMA(MAValue startpt) {
        this.mData.beginUpdate();
        try {
            double fastC = 2.0 / ((double)this.mFastSCPeriods + 1.0);
            double slowC = 2.0 / ((double)this.mSlowSCPeriods + 1.0);
            double mult = 2.0 / ((double)this.mPeriods + 1.0);
            int startidx = 0;
            double prevema = 0.0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
                prevema = startpt.Accum;
            }
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                IBarDataPoint bar = this.mSeries.get(i);
                double currvalue = this.getBarPrice(bar);
                if (i == this.mPeriods - 1) {
                    double acc = 0.0;
                    for (int j = 0; j < this.mPeriods; ++j) {
                        double accvalue = this.getBarPrice(this.mSeries.get(j));
                        acc += accvalue;
                    }
                    double ema = acc / (double)this.mPeriods;
                    this.mData.addDataPoint(new MAValue(bar.getTime(), ema, prevema, i));
                    prevema = ema;
                    continue;
                }
                if (i <= this.mPeriods - 1) continue;
                IBarDataPoint dsvalue2 = this.mSeries.get(i - this.mPeriods + 1);
                double pvalue = this.getBarPrice(dsvalue2);
                double dir = currvalue - pvalue;
                double vol = 0.0;
                for (int j = i; j > i - this.mPeriods; --j) {
                    IBarDataPoint vval1 = this.mSeries.get(j);
                    double vv1value = this.getBarPrice(vval1);
                    IBarDataPoint vval2 = this.mSeries.get(j - 1);
                    double vv2value = this.getBarPrice(vval2);
                    vol += Math.abs(vv1value - vv2value);
                }
                double er = vol == 0.0 ? 0.0 : dir / vol;
                double ssc = er * (fastC - slowC) + slowC;
                double c = ssc * ssc;
                double ama = prevema + c * (currvalue - prevema);
                this.mData.addDataPoint(new MAValue(bar.getTime(), ama, prevema, i));
                prevema = ama;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeAMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeSMMA(MAValue startpt) {
        if (this.mSeries.getCount() < this.mPeriods) {
            return;
        }
        this.mData.beginUpdate();
        try {
            int startidx = 0;
            double prevsmma = 0.0;
            double acc = 0.0;
            if (startpt != null && startidx >= this.mPeriods) {
                startidx = startpt.DataIndex - 1;
                MAValue prevma = (MAValue)this.mData.get(startidx);
                prevsmma = prevma.MA;
                acc = prevma.Accum;
            }
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                IBarDataPoint bar = this.mSeries.get(i);
                double currvalue = this.getBarPrice(bar);
                if (i < this.mPeriods - 1) {
                    acc += currvalue;
                    continue;
                }
                if (i == this.mPeriods - 1) {
                    double sma = (acc += currvalue) / (double)this.mPeriods;
                    this.mData.addDataPoint(new MAValue(bar.getTime(), sma, acc, i));
                    prevsmma = sma;
                    continue;
                }
                if (i <= this.mPeriods - 1) continue;
                acc = acc - prevsmma + currvalue;
                double smma = acc / (double)this.mPeriods;
                this.mData.addDataPoint(new MAValue(bar.getTime(), smma, acc, i));
                prevsmma = smma;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeSMMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeLWMA(MAValue startpt) {
        if (this.mSeries.getCount() < this.mPeriods) {
            return;
        }
        this.mData.beginUpdate();
        try {
            double div = this.mPeriods * (this.mPeriods + 1) / 2;
            int startidx = 0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
            }
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                if (i < this.mPeriods - 1) continue;
                double wsum = 0.0;
                for (int j = 0; j < this.mPeriods; ++j) {
                    double val = this.getBarPrice(this.mSeries.get(i - j));
                    wsum += val * (double)(this.mPeriods - j);
                }
                double lwma = wsum / div;
                this.mData.addDataPoint(new MAValue(this.mSeries.get(i).getTime(), lwma, 0.0, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeLWMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeTMA(MAValue startpt) {
        if (this.mSeries.getCount() < this.mPeriods) {
            return;
        }
        this.mData.beginUpdate();
        try {
            double[] weights = new double[this.mPeriods];
            double div = 0.0;
            for (int i = 0; i < this.mPeriods; ++i) {
                if (i < this.mPeriods / 2) {
                    weights[i] = i + 1;
                    div += weights[i];
                    continue;
                }
                weights[i] = this.mPeriods - i;
                div += weights[i];
            }
            int startidx = 0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
            }
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                if (i < this.mPeriods - 1) continue;
                double wsum = 0.0;
                for (int j = 0; j < this.mPeriods; ++j) {
                    double val = this.getBarPrice(this.mSeries.get(i - j));
                    wsum += val * weights[j];
                }
                double tma = wsum / div;
                this.mData.addDataPoint(new MAValue(this.mSeries.get(i).getTime(), tma, 0.0, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeTMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeWWMA(MAValue startpt) {
        this.mData.beginUpdate();
        try {
            int startidx = 0;
            double prevma = 0.0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
                prevma = startpt.Accum;
            }
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                IBarDataPoint bar = this.mSeries.get(i);
                double currvalue = this.getBarPrice(bar);
                if (i == this.mPeriods - 1) {
                    double acc = 0.0;
                    for (int j = 0; j < this.mPeriods; ++j) {
                        double accvalue = this.getBarPrice(this.mSeries.get(j));
                        acc += accvalue;
                    }
                    double wwma = acc / (double)this.mPeriods;
                    this.mData.addDataPoint(new MAValue(bar.getTime(), wwma, prevma, i));
                    prevma = wwma;
                    continue;
                }
                if (i <= this.mPeriods - 1) continue;
                double wwma = (currvalue + prevma * (double)(this.mPeriods - 1)) / (double)this.mPeriods;
                this.mData.addDataPoint(new MAValue(bar.getTime(), wwma, prevma, i));
                prevma = wwma;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeWWMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeLSMA(MAValue startpt) {
        if (this.mSeries.getCount() < this.mPeriods) {
            return;
        }
        this.mData.beginUpdate();
        try {
            int startidx = 0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
            }
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                if (i < this.mPeriods - 1) continue;
                IBarDataPoint bar = this.mSeries.get(i);
                LinearRegression reg = new LinearRegression();
                for (int j = 0; j < this.mPeriods; ++j) {
                    IBarDataPoint regdsvalue = this.mSeries.get(i - j);
                    double currvalue = this.getBarPrice(regdsvalue);
                    reg.addPoint(j, currvalue);
                }
                reg.compute();
                if (reg.isComputed()) {
                    this.mData.addDataPoint(new MAValue(bar.getTime(), reg.a(), reg.b(), i));
                    continue;
                }
                Log.e(TAG, "computeLSMA(), Regression failed.");
                return;
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeLSMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeHMA(MAValue startpt) {
        if (this.mSeries.getCount() < this.mPeriods || this.mPeriods < 2) {
            return;
        }
        this.mData.beginUpdate();
        try {
            BigDecimal halfperBD = new BigDecimal(this.mPeriods).round(this.mc);
            int halfper = halfperBD.intValueExact();
            if (startpt == null || this.hmaWMA1 == null) {
                this.hmaWMA1 = new BarMovingAverage(this.mSeries, MAType.LWMA, this.mPriceType, this.mPeriods);
                this.hmaWMA2 = new BarMovingAverage(this.mSeries, MAType.LWMA, this.mPriceType, halfper);
            }
            this.hmaWMA1.update();
            this.hmaWMA2.update();
            int noff1 = this.mPeriods - 1;
            int noff2 = this.mPeriods - halfper - 1;
            BigDecimal nBD = new BigDecimal(Math.sqrt(this.mPeriods)).round(this.mc);
            int n = halfperBD.intValueExact();
            double div = (double)n * ((double)n + 1.0) / 2.0;
            int startidx = 0;
            if (startpt != null) {
                startidx = startpt.DataIndex;
            }
            IDataSource wmaDS1 = this.hmaWMA1.getDataSource();
            IDataSource wmaDS2 = this.hmaWMA1.getDataSource();
            for (int i = startidx; i < this.mSeries.getCount(); ++i) {
                int eo = this.mSeries.getCount() - i;
                if (wmaDS1.getCount() < eo + n - 1 || wmaDS2.getCount() < eo + n - 1) continue;
                double wsum = 0.0;
                for (int j = 0; j < n; ++j) {
                    double wmaval1 = ((MAValue)wmaDS1.get((int)(wmaDS1.getCount() - eo - j))).MA;
                    double wmaval2 = ((MAValue)wmaDS2.get((int)(wmaDS2.getCount() - eo - j))).MA;
                    double val = 2.0 * wmaval2 - wmaval1;
                    wsum += val * (double)(n - j);
                }
                double lwma = wsum / div;
                this.mData.addDataPoint(new MAValue(this.mSeries.get(i).getTime(), lwma, 0.0, i));
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "computeHMA(), Computation failed.", ex);
        }
        finally {
            this.mData.endUpdate();
        }
    }

    private double getBarPrice(IBarDataPoint bar) {
        if (this.mPriceType == MAPriceType.Opening) {
            return bar.getOpen();
        }
        if (this.mPriceType == MAPriceType.High) {
            return bar.getHigh();
        }
        if (this.mPriceType == MAPriceType.Low) {
            return bar.getLow();
        }
        if (this.mPriceType == MAPriceType.Closing) {
            return bar.getClose();
        }
        if (this.mPriceType == MAPriceType.Average) {
            return (bar.getHigh() + bar.getLow()) / 2.0;
        }
        if (this.mPriceType == MAPriceType.Typical) {
            return (bar.getHigh() + bar.getLow() + bar.getClose()) / 3.0;
        }
        if (this.mPriceType == MAPriceType.Weighted) {
            return (bar.getHigh() + bar.getLow() + bar.getClose() + bar.getClose()) / 4.0;
        }
        return bar.getClose();
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDataDef == null) {
            this.mDataDef = new DataDefinition(TAG);
            this.mDataDef.addField(new DataField("MA", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof MAValue) {
                        MAValue maDP = (MAValue)dp;
                        return maDP.MA;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    try {
                        return PriceFormat.convertPriceToDisplayFormat(Price.of(value), (IPriceFormatArgs)BarMovingAverage.this.mSeries.getArgs().Market, AppSettings.instance.MarketData.PriceDisplay);
                    }
                    catch (Exception ex) {
                        Log.e("BarMovingAverage.DD", "getFormattedValue(), Error.", ex);
                        return Double.toString(value);
                    }
                }
            }, true, true));
            this.mDataDef.addField(new DataField("STDDEV", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof MAValue) {
                        MAValue maDP = (MAValue)dp;
                        return maDP.StdDev;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    try {
                        return PriceFormat.convertPriceToDisplayFormat(Price.of(value), (IPriceFormatArgs)BarMovingAverage.this.mSeries.getArgs().Market, AppSettings.instance.MarketData.PriceDisplay);
                    }
                    catch (Exception ex) {
                        Log.e("BarMovingAverage.DD", "getFormattedValue(), Error.", ex);
                        return Double.toString(value);
                    }
                }
            }, false, true));
        }
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this.mData;
    }

    public static class MAValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double MA;
        public final double Accum;
        public final double StdDev;
        public final int DataIndex;

        public MAValue(NDateTime time, double ma, double acc, int idx) {
            this(time, ma, acc, 0.0, idx);
        }

        public MAValue(NDateTime time, double ma, double acc, double stddev, int idx) {
            this.Time = time;
            this.MA = ma;
            this.Accum = acc;
            this.StdDev = stddev;
            this.DataIndex = idx;
        }

        @Override
        public double getValue() {
            return this.MA;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }
    }
}

