/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies;

import com.t4login.Log;
import com.t4login.application.ConfigContext;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.studies.BarStudy;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.indicators.AccDistStudy;
import com.t4login.application.chart.studies.indicators.AverageTrueRangeStudy;
import com.t4login.application.chart.studies.indicators.CMFStudy;
import com.t4login.application.chart.studies.indicators.FVEStudy;
import com.t4login.application.chart.studies.indicators.FastStochasticOscillatorStudy;
import com.t4login.application.chart.studies.indicators.HistoricalVolatilityStudy;
import com.t4login.application.chart.studies.indicators.MACDStudy;
import com.t4login.application.chart.studies.indicators.OBVStudy;
import com.t4login.application.chart.studies.indicators.RSIStudy;
import com.t4login.application.chart.studies.indicators.RateOfChangeStudy;
import com.t4login.application.chart.studies.indicators.StochasticOscillatorStudy;
import com.t4login.application.chart.studies.indicators.ULTStudy;
import com.t4login.application.chart.studies.indicators.VolumeStudy;
import com.t4login.application.chart.studies.overlays.BollingerBands;
import com.t4login.application.chart.studies.overlays.EMAStudy;
import com.t4login.application.chart.studies.overlays.HMAStudy;
import com.t4login.application.chart.studies.overlays.IchimokuCloudStudy;
import com.t4login.application.chart.studies.overlays.LSMAStudy;
import com.t4login.application.chart.studies.overlays.LWMAStudy;
import com.t4login.application.chart.studies.overlays.ParabolicSARStudy;
import com.t4login.application.chart.studies.overlays.PivotPointsStudy;
import com.t4login.application.chart.studies.overlays.PriceChannelsStudy;
import com.t4login.application.chart.studies.overlays.SMAStudy;
import com.t4login.application.chart.studies.overlays.SMMAStudy;
import com.t4login.application.chart.studies.overlays.SettlementStudy;
import com.t4login.application.chart.studies.overlays.TMAStudy;
import com.t4login.application.chart.studies.underlays.VolumeUnderlayStudy;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.UserRole;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StudyFactory {
    private static final String TAG = "StudyFactory";
    public static final List<StudyDefinition> RegisteredStudies = new ArrayList<StudyDefinition>();
    private static final Map<String, Class<?>> studyClasses = new HashMap();

    public static void init() {
    }

    public static void registerStudy(Class<?> studyClass, Class<?> configClass) {
        StudyDefinition def = studyClass.getAnnotation(StudyDefinition.class);
        RegisteredStudies.add(def);
        studyClasses.put(def.id(), studyClass);
        Configurable.registerConfigBuilder(def.id(), uid -> {
            Configurable config = null;
            try {
                Constructor ctor = configClass.getConstructor(String.class);
                config = (Configurable)ctor.newInstance(uid);
            }
            catch (NoSuchMethodException nmex) {
                Log.e(TAG, "registerStudy().buildConfigObject(), Error creating config '" + configClass.getName() + "'. Unable to locate a suitable constructor: " + String.valueOf(nmex));
            }
            catch (Exception ex) {
                Log.e(TAG, "registerStudy().buildConfigObject(), Error creating config '" + configClass.getName() + "': " + String.valueOf(ex));
            }
            return config;
        });
    }

    public static Study createStudy(String id, Object config, ChartContext ccontext) {
        block5: {
            if (studyClasses.containsKey(id)) {
                try {
                    Class<?> clazz = studyClasses.get(id);
                    UserRole userRole = ConfigContext.Default.getUserRole();
                    StudyDefinition def = clazz.getAnnotation(StudyDefinition.class);
                    if (def == null || def.userRole() == UserRole.NotAllowed) break block5;
                    if (userRole != UserRole.Standard && def.userRole() == UserRole.Standard) {
                        Log.e(TAG, "createStudy(), Error creating study '" + id + "'. Standard charts required, but user is basic.");
                        break block5;
                    }
                    Constructor<?> ctor = clazz.getConstructor(ChartContext.class, Object.class);
                    return (Study)ctor.newInstance(ccontext, config);
                }
                catch (NoSuchMethodException nmex) {
                    Log.e(TAG, "createStudy(), Error creating study '" + id + "'. Unable to locate a suitable constructor: " + String.valueOf(nmex));
                }
                catch (Exception ex) {
                    Log.e(TAG, "createStudy(), Error creating study '" + id + "': " + String.valueOf(ex));
                }
            }
        }
        return null;
    }

    static {
        StudyFactory.registerStudy(BarStudy.class, BarStudy.Configuration.class);
        StudyFactory.registerStudy(BollingerBands.class, BollingerBands.Configuration.class);
        StudyFactory.registerStudy(EMAStudy.class, EMAStudy.Configuration.class);
        StudyFactory.registerStudy(HMAStudy.class, HMAStudy.Configuration.class);
        StudyFactory.registerStudy(IchimokuCloudStudy.class, IchimokuCloudStudy.Configuration.class);
        StudyFactory.registerStudy(LSMAStudy.class, LSMAStudy.Configuration.class);
        StudyFactory.registerStudy(LWMAStudy.class, LWMAStudy.Configuration.class);
        StudyFactory.registerStudy(ParabolicSARStudy.class, ParabolicSARStudy.Configuration.class);
        StudyFactory.registerStudy(PivotPointsStudy.class, PivotPointsStudy.Configuration.class);
        StudyFactory.registerStudy(PriceChannelsStudy.class, PriceChannelsStudy.Configuration.class);
        StudyFactory.registerStudy(SettlementStudy.class, SettlementStudy.Configuration.class);
        StudyFactory.registerStudy(SMAStudy.class, SMAStudy.Configuration.class);
        StudyFactory.registerStudy(SMMAStudy.class, SMMAStudy.Configuration.class);
        StudyFactory.registerStudy(TMAStudy.class, TMAStudy.Configuration.class);
        StudyFactory.registerStudy(VolumeUnderlayStudy.class, VolumeUnderlayStudy.Configuration.class);
        StudyFactory.registerStudy(AccDistStudy.class, AccDistStudy.Configuration.class);
        StudyFactory.registerStudy(AverageTrueRangeStudy.class, AverageTrueRangeStudy.Configuration.class);
        StudyFactory.registerStudy(CMFStudy.class, CMFStudy.Configuration.class);
        StudyFactory.registerStudy(FastStochasticOscillatorStudy.class, FastStochasticOscillatorStudy.Configuration.class);
        StudyFactory.registerStudy(FVEStudy.class, FVEStudy.Configuration.class);
        StudyFactory.registerStudy(HistoricalVolatilityStudy.class, HistoricalVolatilityStudy.Configuration.class);
        StudyFactory.registerStudy(OBVStudy.class, OBVStudy.Configuration.class);
        StudyFactory.registerStudy(MACDStudy.class, MACDStudy.Configuration.class);
        StudyFactory.registerStudy(RateOfChangeStudy.class, RateOfChangeStudy.Configuration.class);
        StudyFactory.registerStudy(RSIStudy.class, RSIStudy.Configuration.class);
        StudyFactory.registerStudy(StochasticOscillatorStudy.class, StochasticOscillatorStudy.Configuration.class);
        StudyFactory.registerStudy(VolumeStudy.class, VolumeStudy.Configuration.class);
        StudyFactory.registerStudy(ULTStudy.class, ULTStudy.Configuration.class);
    }
}

