/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies;

import com.t4login.Resource;
import java.util.HashMap;
import java.util.Map;

public enum StudyCategory {
    None(0, Resource.localizeString("study_category_none")),
    Overlay(1, "study_category_overlay"),
    Underlay(2, "study_category_underlay"),
    PriceAndVolume(3, "study_category_priceandvolume"),
    MoneyFlow(4, "study_category_moneyflow"),
    Oscillator(5, "study_category_oscillator"),
    Volatility(6, "study_category_volatility"),
    Other(7, "study_category_other");

    private final int value;
    private final String descr_loc;
    private static Map<Integer, StudyCategory> map;

    private StudyCategory(int value, String descr_loc) {
        this.value = value;
        this.descr_loc = descr_loc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return Resource.localizeString(this.descr_loc);
    }

    public static StudyCategory get(int value) {
        return map.get(value);
    }

    static {
        map = new HashMap<Integer, StudyCategory>();
        for (StudyCategory t : StudyCategory.values()) {
            map.put(t.getValue(), t);
        }
    }
}

