/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies;

import com.t4login.Resource;
import com.t4login.application.chart.BarInterval;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.dataprovider.IBarDataProvider;
import com.t4login.application.chart.chartdata.dataprovider.IDataProvider;
import com.t4login.application.chart.markets.IChartMarket;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.render.ITrackLabelRenderer;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.configuration.Configurable;
import com.t4login.datetime.NDateTime;
import com.t4login.util.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class Study
implements IDataProvider {
    private static final String TAG = "Study";
    private ChartContext mChartContext;
    private final List<ISummaryRenderer> mSummaries = new ArrayList<ISummaryRenderer>();
    private final List<ITrackLabelRenderer> mTrackLabels = new ArrayList<ITrackLabelRenderer>();

    protected Study(ChartContext ccontext) {
        this.mChartContext = ccontext;
    }

    public abstract String getUID();

    public void compute() {
        this.onRecomputeStudy();
    }

    public void update() {
        this.onUpdateStudy();
    }

    public boolean getUsesCustomBarInterval() {
        return false;
    }

    public BarInterval getCustomBarInterval() {
        return this.mChartContext.BarProvider.args().Interval;
    }

    public void setCustomContext(ChartContext cc) {
        this.mChartContext = cc;
    }

    public ChartContext getContext() {
        return this.mChartContext;
    }

    protected ChartContext getChartContext() {
        return this.mChartContext;
    }

    protected IChartMarket getMarket() {
        return this.mChartContext.BarProvider.args().Market;
    }

    public IBarDataProvider getDataProvider() {
        return this.mChartContext.BarProvider;
    }

    public BarDataSeries getBarData() {
        if (this.mChartContext.BarProvider == null) {
            return BarDataSeries.Empty;
        }
        return this.mChartContext.BarProvider.getBarData();
    }

    public abstract StudyDefinition getStudyDefinition();

    public String getStudyID() {
        StudyDefinition def = this.getStudyDefinition();
        return def.id();
    }

    public String getStudyName() {
        StudyDefinition def = this.getStudyDefinition();
        return Resource.localizeString(def.nameResId());
    }

    public String getStudyDescription() {
        StudyDefinition def = this.getStudyDefinition();
        return Resource.localizeString(def.descrResId());
    }

    public abstract Configurable getConfiguration();

    public abstract IValueScale createValueScale();

    public abstract IChartRenderer getRenderer();

    public Collection<ISummaryRenderer> getSummaries(NDateTime trackTime) {
        this.mSummaries.clear();
        ISummaryRenderer summ = this.getSummary(trackTime);
        if (summ != null) {
            this.mSummaries.add(summ);
        }
        return this.mSummaries;
    }

    protected ISummaryRenderer getSummary(NDateTime trackTime) {
        return null;
    }

    public Collection<ITrackLabelRenderer> getTrackLabels() {
        this.mTrackLabels.clear();
        ITrackLabelRenderer trackLabel = this.getTrackLabel();
        if (trackLabel != null) {
            this.mTrackLabels.add(trackLabel);
        }
        return this.mTrackLabels;
    }

    protected ITrackLabelRenderer getTrackLabel() {
        return null;
    }

    public abstract Range<Double> getValueRange(Range<NDateTime> var1);

    public abstract Range<NDateTime> getTimeRange();

    public Integer getPreceedingIntervals() {
        return null;
    }

    protected abstract void onUpdateStudy();

    protected abstract void onRecomputeStudy();

    protected abstract void onResetStudy();
}

