/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.studies;

import com.t4login.Host;
import com.t4login.Resource;
import com.t4login.application.chart.ChartContext;
import com.t4login.application.chart.ChartInterval;
import com.t4login.application.chart.IValueFormatter;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.render.IBarRenderer;
import com.t4login.application.chart.render.IChartRenderer;
import com.t4login.application.chart.render.IRendererFactory;
import com.t4login.application.chart.render.ISummaryRenderer;
import com.t4login.application.chart.render.ITrackLabelRenderer;
import com.t4login.application.chart.scales.ChartPriceScale;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.studies.Study;
import com.t4login.application.chart.studies.StudyCategory;
import com.t4login.application.chart.studies.StudyConfigurable;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IEnum;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.Serialize;
import com.t4login.application.configuration.UserRole;
import com.t4login.application.contract.ladder.DepthSnapshot;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.util.ColorUtil;
import com.t4login.util.Range;
import com.t4login.util.TextUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@StudyDefinition(id="BAR", nameResId="chart_bar_study_name", descrResId="chart_bar_study_descr", category=StudyCategory.Overlay, type=StudyType.Bar, userRole=UserRole.Basic)
public class BarStudy
extends Study {
    private static final String TAG = "BarStudy";
    private static StudyDefinition DEF = BarStudy.class.getAnnotation(StudyDefinition.class);
    private final Configuration mConfig;
    private final IBarRenderer mBarRenderer;
    private final ITrackLabelRenderer mLastTradeTracklabel;
    private final ISummaryRenderer mModeSummary;
    private final ISummaryRenderer mPriceSummary;
    private final ISummaryRenderer mOpenSummary;
    private final ISummaryRenderer mHighSummary;
    private final ISummaryRenderer mLowSummary;
    private final ISummaryRenderer mCloseSummary;

    public BarStudy(ChartContext ccontext) {
        this(ccontext, null);
    }

    public BarStudy(ChartContext ccontext, Object config) {
        super(ccontext);
        this.mConfig = config instanceof Configuration ? (Configuration)config : new Configuration("");
        IRendererFactory rendererFactory = Host.getRendererFactory();
        this.mBarRenderer = rendererFactory.createBarRenderer();
        this.mLastTradeTracklabel = rendererFactory.createTrackLabelRenderer();
        this.mLastTradeTracklabel.setBorderColor(ColorUtil.rgb(0, 140, 0)).setFillColor(ColorUtil.rgb(0, 255, 0));
        this.mLastTradeTracklabel.setValueFormatter(new IValueFormatter(){

            @Override
            public String formatValue(double value) {
                return PriceFormat.convertPriceToDisplayFormat(value, BarStudy.this.getMarket());
            }
        });
        this.mModeSummary = rendererFactory.createSummaryRenderer();
        this.mPriceSummary = rendererFactory.createSummaryRenderer();
        this.mOpenSummary = rendererFactory.createSummaryRenderer();
        this.mHighSummary = rendererFactory.createSummaryRenderer();
        this.mLowSummary = rendererFactory.createSummaryRenderer();
        this.mCloseSummary = rendererFactory.createSummaryRenderer();
    }

    @Override
    public String getUID() {
        return this.mConfig.uid;
    }

    public BarChartType getBarType() {
        return this.mConfig.BarType;
    }

    @Override
    public StudyDefinition getStudyDefinition() {
        return DEF;
    }

    @Override
    public Configurable getConfiguration() {
        return this.mConfig;
    }

    @Override
    public IValueScale createValueScale() {
        ChartPriceScale scale = new ChartPriceScale(this.getMarket());
        ChartInterval cintvl = this.getChartContext().BarProvider.args().Interval.Interval;
        return scale;
    }

    @Override
    public IChartRenderer getRenderer() {
        this.mBarRenderer.updateDataSeries(this.getBarData()).setBarConfig(this.mConfig);
        return this.mBarRenderer;
    }

    @Override
    public Collection<ISummaryRenderer> getSummaries(NDateTime trackTime) {
        ArrayList<ISummaryRenderer> summaries = new ArrayList<ISummaryRenderer>();
        if (!this.mConfig.SummaryConfig.DisplaySummaries) {
            return summaries;
        }
        DepthSnapshot depth = this.getChartContext().getDepth();
        String modeResID = "t4_mode_undef";
        String expiryDescr = "";
        if (depth != null) {
            modeResID = depth.getMarketMode().getIconResID();
            expiryDescr = this.getChartContext().MarketFormatter.getFormattedExpiryDescription(depth.getMarket());
        }
        this.mModeSummary.setText(expiryDescr).setIconRes(modeResID);
        summaries.add(this.mModeSummary);
        BarDataSeries bars = this.getBarData();
        IBarDataPoint dp = bars.getNearestTo(trackTime);
        ArrayList<CallSite> summs = new ArrayList<CallSite>();
        if (dp != null) {
            if (this.mConfig.SummaryConfig.DisplayOpenValue) {
                this.mOpenSummary.setText("O:" + PriceFormat.convertPriceToDisplayFormat(dp.getOpen(), this.getMarket()));
                if (this.mConfig.SummaryConfig.ArrangePricesVertically) {
                    summaries.add(this.mOpenSummary);
                }
                summs.add((CallSite)((Object)("O:" + PriceFormat.convertPriceToDisplayFormat(dp.getOpen(), this.getMarket()))));
            }
            if (this.mConfig.SummaryConfig.DisplayHighValue) {
                this.mHighSummary.setText("H:" + PriceFormat.convertPriceToDisplayFormat(dp.getHigh(), this.getMarket()));
                if (this.mConfig.SummaryConfig.ArrangePricesVertically) {
                    summaries.add(this.mHighSummary);
                }
                summs.add((CallSite)((Object)("H:" + PriceFormat.convertPriceToDisplayFormat(dp.getHigh(), this.getMarket()))));
            }
            if (this.mConfig.SummaryConfig.DisplayLowValue) {
                this.mLowSummary.setText("L:" + PriceFormat.convertPriceToDisplayFormat(dp.getLow(), this.getMarket()));
                if (this.mConfig.SummaryConfig.ArrangePricesVertically) {
                    summaries.add(this.mLowSummary);
                }
                summs.add((CallSite)((Object)("L:" + PriceFormat.convertPriceToDisplayFormat(dp.getLow(), this.getMarket()))));
            }
            if (this.mConfig.SummaryConfig.DisplayCloseValue) {
                this.mCloseSummary.setText("C:" + PriceFormat.convertPriceToDisplayFormat(dp.getClose(), this.getMarket()));
                if (this.mConfig.SummaryConfig.ArrangePricesVertically) {
                    summaries.add(this.mCloseSummary);
                }
                summs.add((CallSite)((Object)("C:" + PriceFormat.convertPriceToDisplayFormat(dp.getClose(), this.getMarket()))));
            }
        }
        if (!this.mConfig.SummaryConfig.ArrangePricesVertically && summs.size() > 0) {
            String summText = TextUtils.join((CharSequence)", ", summs);
            this.mPriceSummary.setText(summText);
            summaries.add(this.mPriceSummary);
        }
        return summaries;
    }

    @Override
    protected ITrackLabelRenderer getTrackLabel() {
        BarDataSeries bars;
        IBarDataPoint lastBar;
        if (this.getChartContext().Profile.General.highlightLastTrade && (lastBar = (bars = this.getBarData()).getLast()) != null) {
            this.mLastTradeTracklabel.setTrackValue(lastBar.getClose());
            return this.mLastTradeTracklabel;
        }
        return null;
    }

    @Override
    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        BarDataSeries bars = this.getBarData();
        Range<Double> prcrange = bars.getPriceRange(timeRange);
        if (prcrange.isEmpty()) {
            prcrange = bars.getSettlementData().getValueRange(timeRange);
        }
        return prcrange;
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        BarDataSeries bars = this.getBarData();
        return bars.getTimeRange();
    }

    @Override
    public Integer getPreceedingIntervals() {
        return null;
    }

    @Override
    protected void onUpdateStudy() {
    }

    @Override
    protected void onRecomputeStudy() {
    }

    @Override
    protected void onResetStudy() {
    }

    @Override
    public DataDefinition getDataDefinition() {
        BarDataSeries bars = this.getBarData();
        return bars.getDataDefinition();
    }

    @Override
    public IDataSource getDataSource() {
        BarDataSeries bars = this.getBarData();
        return bars.getDataSource();
    }

    @Category(value="chart_bar_settings")
    public static class Configuration
    extends StudyConfigurable {
        @PropertyConfig(idx=0, name="bar_bartype_name", description="bar_bartype_descr")
        @DefaultValue(value="OHLCBar")
        public BarChartType BarType = BarChartType.OHLCBar;
        @PropertyConfig(idx=1, name="rising_color_name", description="rising_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#1AC41A")
        @Serialize(value=Serialize.As.Color)
        public int RisingColor = ColorUtil.rgb(26, 196, 26);
        @PropertyConfig(idx=2, name="falling_color_name", description="falling_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#C00000")
        @Serialize(value=Serialize.As.Color)
        public int FallingColor = ColorUtil.rgb(192, 0, 0);
        @PropertyConfig(idx=2, name="outline_color_name", description="outline_color_descr", editor=EditorType.ColorPicker)
        @DefaultValue(value="#000000")
        @Serialize(value=Serialize.As.Color)
        public int OutlineColor = ColorUtil.rgb(0, 0, 0);
        @PropertyConfig(idx=5, name="linewidth_name", description="linewidth_descr")
        @NumberFormatF(minValue=1.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
        @DefaultValue(value="2")
        public int LineThickness = 2;
        @IncludeConfig(idx=6)
        @Category(value="chart_summaries")
        public final SummaryConfig SummaryConfig = new SummaryConfig();

        public Configuration(String uid) {
            super(uid);
        }

        @Override
        public String configID() {
            return DEF.id();
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_bar_settings");
        }

        @Override
        public boolean filterProperty(String propertyName) {
            if (propertyName.equals("OutlineColor")) {
                return this.BarType != BarChartType.CandleStick && this.BarType != BarChartType.HeikenAshi && this.BarType != BarChartType.Renko;
            }
            return false;
        }
    }

    public static enum BarChartType implements IEnum
    {
        CandleStick(0, "barcharttype_candlestick"),
        OHLCBar(1, "barcharttype_ohlcbar"),
        Line(1, "barcharttype_line"),
        HLCBar(1, "barcharttype_hlcbar"),
        HeikenAshi(1, "barcharttype_heikenashi"),
        Renko(1, "barcharttype_renko"),
        PointAndFigure(1, "barcharttype_pointandfigure");

        private final int value;
        private final String descrResID;
        private static Map<Integer, BarChartType> map;

        private BarChartType(int value, String descrResID) {
            this.value = value;
            this.descrResID = descrResID;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public String getDescription() {
            return Resource.localizeString(this.descrResID);
        }

        public static BarChartType get(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, BarChartType>();
            for (BarChartType t : BarChartType.values()) {
                map.put(t.getValue(), t);
            }
        }
    }

    public static class SummaryConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_display_summaries_name", description="chart_display_summaries_descr", editor=EditorType.Switch)
        @DefaultValue(value="true")
        public boolean DisplaySummaries = true;
        @PropertyConfig(idx=1, name="bar_summary_arrange_prices_vertically_name", description="bar_summary_arrange_prices_vertically_descr")
        @DefaultValue(value="true")
        public boolean ArrangePricesVertically = true;
        @PropertyConfig(idx=2, name="bar_summary_display_open_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayOpenValue = true;
        @PropertyConfig(idx=3, name="bar_summary_display_high_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayHighValue = true;
        @PropertyConfig(idx=4, name="bar_summary_display_low_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayLowValue = true;
        @PropertyConfig(idx=5, name="bar_summary_display_close_name", description="empty")
        @DefaultValue(value="true")
        public boolean DisplayCloseValue = true;

        @Override
        public String configID() {
            return "BarStudy$SummaryConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_summaries");
        }

        @Override
        public boolean isEnabled(String propertyName) {
            if (propertyName.equals("DisplayOpenValue") && !this.DisplaySummaries) {
                return false;
            }
            if (propertyName.equals("DisplayHighValue") && !this.DisplaySummaries) {
                return false;
            }
            if (propertyName.equals("DisplayLowValue") && !this.DisplaySummaries) {
                return false;
            }
            return !propertyName.equals("DisplayCloseValue") || this.DisplaySummaries;
        }
    }
}

