/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.settings;

import com.t4login.Resource;
import com.t4login.application.chart.BarInterval;
import com.t4login.application.chart.ContractMonth;
import com.t4login.application.chart.SessionTime;
import com.t4login.application.chart.SessionTimeRange;
import com.t4login.application.configuration.Beta;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.EditorType;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.application.configuration.RequiresRole;
import com.t4login.application.configuration.UserRole;
import com.t4login.definitions.ContinuationType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@Category(value="chart_data_settings")
public class DataSettings
extends Configurable {
    @PropertyConfig(idx=0, name="data_bar_interval_name", description="data_bar_interval_descr")
    @RequiresRole(value=UserRole.NotAllowed)
    @DefaultValue(value="15;Minute")
    public BarInterval barInterval = BarInterval.Bar15Minute;
    @PropertyConfig(idx=1, name="data_bar_reset_interval_name", description="data_bar_reset_interval_descr")
    @DefaultValue(value="TradingWeek")
    @Beta
    public ResetInterval BarResetInterval = ResetInterval.TradingWeek;
    @PropertyConfig(idx=2, name="data_close_with_settlement_name", description="data_close_with_settlement_descr")
    @DefaultValue(value="TradingWeek")
    @Beta
    public boolean CloseWithSettlement = false;
    @IncludeConfig(idx=5)
    @Category(value="chart_session")
    @Beta
    public final SessionConfig SessionConfig = new SessionConfig();
    @IncludeConfig(idx=10)
    @Category(value="chart_continuation")
    public final ContinuationConfigSettings ContinuationConfig = new ContinuationConfigSettings();
    @PropertyConfig(idx=50, name="data_quick_intervals_count", description="data_quick_intervals_count_descr", tag=3)
    @NumberFormatF(increment=1.0f, maxValue=10.0f, minValue=2.0f, displayDecimals=0, allowWrap=false)
    @Category(value="chart_quick_intervals")
    public int NumQuickIntervals = 6;
    @PropertyConfig(idx=51, name="data_quick_interval_1", editor=EditorType.BarIntervalPicker)
    @Category(value="chart_quick_intervals")
    public BarInterval QuickInterval1 = BarInterval.Bar1Day;
    @PropertyConfig(idx=52, name="data_quick_interval_2", editor=EditorType.BarIntervalPicker)
    @Category(value="chart_quick_intervals")
    public BarInterval QuickInterval2 = BarInterval.Bar1Hour;
    @PropertyConfig(idx=53, name="data_quick_interval_3", editor=EditorType.BarIntervalPicker)
    @Category(value="chart_quick_intervals")
    public BarInterval QuickInterval3 = BarInterval.Bar30Minute;
    @PropertyConfig(idx=54, name="data_quick_interval_4", editor=EditorType.BarIntervalPicker)
    @Category(value="chart_quick_intervals")
    public BarInterval QuickInterval4 = BarInterval.Bar15Minute;
    @PropertyConfig(idx=55, name="data_quick_interval_5", editor=EditorType.BarIntervalPicker)
    @Category(value="chart_quick_intervals")
    public BarInterval QuickInterval5 = BarInterval.Bar5Minute;
    @PropertyConfig(idx=56, name="data_quick_interval_6", editor=EditorType.BarIntervalPicker)
    @Category(value="chart_quick_intervals")
    public BarInterval QuickInterval6 = BarInterval.Bar1Minute;
    @PropertyConfig(idx=57, name="data_quick_interval_7", editor=EditorType.BarIntervalPicker)
    @Category(value="chart_quick_intervals")
    public BarInterval QuickInterval7 = BarInterval.Bar30Second;
    @PropertyConfig(idx=58, name="data_quick_interval_8", editor=EditorType.BarIntervalPicker)
    @Category(value="chart_quick_intervals")
    public BarInterval QuickInterval8 = BarInterval.Bar15Second;
    @PropertyConfig(idx=59, name="data_quick_interval_9", editor=EditorType.BarIntervalPicker)
    @Category(value="chart_quick_intervals")
    public BarInterval QuickInterval9 = BarInterval.Bar5Second;
    @PropertyConfig(idx=60, name="data_quick_interval_10", editor=EditorType.BarIntervalPicker)
    @Category(value="chart_quick_intervals")
    public BarInterval QuickInterval10 = BarInterval.Bar1Second;

    public DataSettings(String id) {
        super(id);
    }

    public DataSettings() {
    }

    @Override
    public String configID() {
        return "DataSettings";
    }

    @Override
    public String configurableName() {
        return Resource.localizeString("chart_data_settings");
    }

    @Override
    public boolean filterProperty(String propertyName) {
        String nTxt;
        int n;
        return propertyName.startsWith("QuickInterval") && (n = Integer.parseInt(nTxt = propertyName.replace("QuickInterval", ""))) > this.NumQuickIntervals;
    }

    public static enum ResetInterval {
        None(0, "resetinterval_none"),
        TradingDay(1, "resetinterval_tradingday"),
        TradingWeek(2, "resetinterval_tradingweek"),
        ExpiryChange(3, "resetinterval_expirychange");

        private final int value;
        private final String descr_loc;
        private static Map<Integer, ResetInterval> map;

        private ResetInterval(int value, String descr_loc) {
            this.value = value;
            this.descr_loc = descr_loc;
        }

        public int getValue() {
            return this.value;
        }

        public String getDescr() {
            return Resource.localizeString(this.descr_loc);
        }

        public static ResetInterval get(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, ResetInterval>();
            for (ResetInterval t : ResetInterval.values()) {
                map.put(t.getValue(), t);
            }
        }
    }

    public static class SessionConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="session_filter_name", description="session_filter_descr", editor=EditorType.Switch)
        @DefaultValue(value="false")
        @Beta
        public boolean FilterBySession = false;
        @PropertyConfig(idx=1, name="session_start_time_name", description="session_start_time_descr", editor=EditorType.SessionTime)
        @DefaultValue(value="00:00")
        @Beta
        public SessionTime SessionStartTime = SessionTime.Empty;
        @PropertyConfig(idx=2, name="session_end_time_name", description="session_end_time_descr", editor=EditorType.SessionTime)
        @DefaultValue(value="00:00")
        @Beta
        public SessionTime SessionEndTime = SessionTime.Empty;
        @PropertyConfig(idx=3, name="session_align_bars_name", description="session_align_bars_descr")
        @DefaultValue(value="false")
        @Beta
        public boolean AlignBarsToSession = false;

        @Override
        public String configID() {
            return "DataSettings$SessionConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_session_settings");
        }

        @Override
        public boolean filterProperty(String propertyName) {
            return (propertyName.equals("SessionStartTime") || propertyName.equals("SessionEndTime") || propertyName.equals("AlignBarsToSession")) && !this.FilterBySession;
        }

        public SessionTimeRange getSessionTimeRange() {
            if (this.FilterBySession) {
                return new SessionTimeRange(this.SessionStartTime, this.SessionEndTime);
            }
            return SessionTimeRange.Empty;
        }
    }

    public static class ContinuationConfigSettings
    extends Configurable {
        @PropertyConfig(idx=0, name="create_continuation_name", description="create_continuation_descr", editor=EditorType.Switch)
        @DefaultValue(value="false")
        public boolean CreateContinuation = false;
        @PropertyConfig(idx=1, name="continuation_type_name", description="continuation_type_descr")
        @DefaultValue(value="Volume")
        public ContinuationTypeConfig ContinueType = ContinuationTypeConfig.Volume;
        @PropertyConfig(idx=2, name="continuation_rollover_days_name", description="continuation_rollover_days_descr")
        @NumberFormatF(increment=1.0f, minValue=0.0f, maxValue=90.0f)
        @DefaultValue(value="0")
        public int ExpiryRolloverDays = 0;
        @PropertyConfig(idx=3, name="continuation_forward_months_name", description="continuation_forward_months_descr")
        @NumberFormatF(increment=1.0f, minValue=0.0f, maxValue=24.0f)
        @DefaultValue(value="0")
        public int ExpiryForwardMonths = 0;
        @PropertyConfig(idx=4, name="continuation_contract_months_name", description="continuation_contract_months_descr")
        @DefaultValue(value="January;February;March;April;May;June;July;August;September;October;November;December")
        public EnumSet<ContractMonth> ExpiryContractMonths = EnumSet.allOf(ContractMonth.class);

        @Override
        public String configID() {
            return "DataSettings$ContinuationConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("continuation_settings");
        }

        @Override
        public boolean filterProperty(String propertyName) {
            if (propertyName.equals("ContinueType") && !this.CreateContinuation) {
                return true;
            }
            return propertyName.startsWith("Expiry") && (!this.CreateContinuation || this.ContinueType != ContinuationTypeConfig.Expiry);
        }

        public static enum ContinuationTypeConfig {
            Volume(0, "continuationtype_volume", ContinuationType.Volume),
            Expiry(1, "continuationtype_expiry", ContinuationType.Expiry);

            private final int value;
            private final String descr_loc;
            private final ContinuationType contType;
            private static Map<Integer, ContinuationTypeConfig> map;

            private ContinuationTypeConfig(int value, String descr_loc, ContinuationType ct) {
                this.value = value;
                this.descr_loc = descr_loc;
                this.contType = ct;
            }

            public int getValue() {
                return this.value;
            }

            public String getDescr() {
                return Resource.localizeString(this.descr_loc);
            }

            public ContinuationType getContinuationType() {
                return this.contType;
            }

            public static ContinuationTypeConfig get(int value) {
                return map.get(value);
            }

            static {
                map = new HashMap<Integer, ContinuationTypeConfig>();
                for (ContinuationTypeConfig t : ContinuationTypeConfig.values()) {
                    map.put(t.getValue(), t);
                }
            }
        }
    }
}

