/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.settings;

import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.application.ConfigContext;
import com.t4login.application.chart.settings.ChartProfile;
import com.t4login.application.chart.studies.BarStudy;
import com.t4login.application.chart.studies.indicators.MACDStudy;
import com.t4login.application.chart.studies.indicators.VolumeStudy;
import com.t4login.application.chart.studies.overlays.BollingerBands;
import com.t4login.application.chart.studies.underlays.VolumeUnderlayStudy;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.IncludeConfigs;
import com.t4login.application.configuration.SaveConfig;
import com.t4login.application.configuration.serialization.ConfigReader;
import com.t4login.application.configuration.serialization.ConfigSerializer;
import com.t4login.application.configuration.serialization.XmlSerializerDelayedWrapper;
import com.t4login.util.ColorUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ChartProfiles
extends Configurable {
    private static final String TAG = "ChartProfiles";
    public static final ChartProfiles instance = new ChartProfiles();
    @IncludeConfigs(idx=0, as="Profile")
    public List<ChartProfile> Profiles = new ArrayList<ChartProfile>();
    @SaveConfig(idx=1)
    public Map<String, String> ContractProfiles = new HashMap<String, String>();
    private static List<Configurable.ConfigurationChangedHandler> configChangedHandlers = new CopyOnWriteArrayList<Configurable.ConfigurationChangedHandler>();

    private ChartProfiles() {
    }

    @Override
    public String configID() {
        return TAG;
    }

    @Override
    public String configurableName() {
        return Resource.localizeString("action_chart_profiles");
    }

    public static void registerForConfigurationChanges(Configurable.ConfigurationChangedHandler handler) {
        if (!configChangedHandlers.contains(handler)) {
            configChangedHandlers.add(handler);
        }
    }

    public static void unregisterForConfigurationChanges(Configurable.ConfigurationChangedHandler handler) {
        if (configChangedHandlers.contains(handler)) {
            configChangedHandlers.remove(handler);
        }
    }

    public static void restoreChartProfilesFromServer(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, TAG);
        ConfigReader rdr = new ConfigReader(ConfigContext.Default, true);
        ChartProfiles.instance.Profiles.clear();
        ChartProfiles.instance.ContractProfiles.clear();
        rdr.parseConfigSettings(parser, (Configurable)instance);
        for (ChartProfile profile : ChartProfiles.instance.Profiles) {
            if (profile.profileID >= 0L) continue;
            long oldProfileID = profile.profileID;
            profile.profileID = ChartProfiles.getProfileID();
            for (String contractID : ChartProfiles.instance.ContractProfiles.keySet()) {
                if (!Long.toString(oldProfileID).equals(ChartProfiles.instance.ContractProfiles.get(contractID))) continue;
                ChartProfiles.instance.ContractProfiles.put(contractID, Long.toString(profile.profileID));
            }
        }
    }

    public static void saveChartProfilesToXML(XmlSerializerDelayedWrapper ser) {
        if (instance != null) {
            ConfigSerializer configSer = new ConfigSerializer(ConfigContext.Default);
            configSer.serializeConfigSettings(ser, instance, TAG, false);
        }
    }

    public static ChartProfile getDefaultProfile() {
        ChartProfiles.checkInitialized();
        return ChartProfiles.instance.Profiles.get(0);
    }

    private static void onConfigurationChanged() {
        for (Configurable.ConfigurationChangedHandler h : configChangedHandlers) {
            try {
                h.onConfigurationChanged(false);
            }
            catch (Exception ex) {
                Log.e(TAG, "onConfigurationChanged(), Error.", ex);
            }
        }
    }

    public static ChartProfile getProfile(long profileID) {
        ChartProfiles.checkInitialized();
        ChartProfile profile = null;
        for (ChartProfile p : ChartProfiles.instance.Profiles) {
            if (p.profileID != profileID) continue;
            profile = p;
            break;
        }
        if (profile == null) {
            Log.e(TAG, "getProfile(), profileID '" + profileID + "' does not exist. Returning default profile instead.");
            profile = ChartProfiles.instance.Profiles.get(0);
        }
        return profile;
    }

    public static void setProfileForContract(ChartProfile profile, String exchangeID, String contractID) {
        String uniqueID = exchangeID + "." + contractID;
        ChartProfiles.instance.ContractProfiles.put(uniqueID, Long.toString(profile.profileID));
        ChartProfiles.onConfigurationChanged();
    }

    public static ChartProfile getProfileForContract(String exchangeID, String contractID) {
        ChartProfiles.checkInitialized();
        String uniqueID = exchangeID + "." + contractID;
        if (ChartProfiles.instance.ContractProfiles.containsKey(uniqueID)) {
            long profileID = Long.parseLong(ChartProfiles.instance.ContractProfiles.get(uniqueID));
            return ChartProfiles.getProfile(profileID);
        }
        return ChartProfiles.instance.Profiles.get(0);
    }

    public static void profileUpdated(ChartProfile profile) {
        ChartProfiles.onConfigurationChanged();
    }

    private static long getProfileID() {
        long id = 0L;
        for (ChartProfile p : ChartProfiles.instance.Profiles) {
            id = Math.max(id, p.profileID);
        }
        if (id < Long.MAX_VALUE) {
            return id + 1L;
        }
        id = -1L;
        long tryID = 0L;
        while (id == -1L) {
            boolean unique = true;
            for (ChartProfile p : ChartProfiles.instance.Profiles) {
                if (p.profileID != tryID) continue;
                unique = false;
                break;
            }
            id = unique ? tryID : -1L;
        }
        return id;
    }

    public static void addProfile(ChartProfile profile) {
        for (ChartProfile p : ChartProfiles.instance.Profiles) {
            if (p != profile) continue;
            Log.e(TAG, "addProfile(), Profile already exists.");
        }
        if (profile.profileID < 0L) {
            profile.profileID = ChartProfiles.getProfileID();
        }
        ChartProfiles.instance.Profiles.add(profile);
        ChartProfiles.onConfigurationChanged();
    }

    public static void removeProfile(ChartProfile profile) {
        int idx;
        if (instance != null && (idx = ChartProfiles.instance.Profiles.indexOf(profile)) >= 0) {
            ChartProfiles.instance.Profiles.remove(idx);
            ArrayList<String> removeContracts = new ArrayList<String>();
            String profileID = Long.toString(profile.profileID);
            for (Map.Entry<String, String> contractEntry : ChartProfiles.instance.ContractProfiles.entrySet()) {
                if (!contractEntry.getValue().equals(profileID)) continue;
                removeContracts.add(contractEntry.getKey());
            }
            for (String contract : removeContracts) {
                ChartProfiles.instance.ContractProfiles.remove(contract);
            }
        }
        ChartProfiles.onConfigurationChanged();
    }

    public static void moveProfile(int from, int to) {
        ChartProfile profile = ChartProfiles.instance.Profiles.remove(from);
        ChartProfiles.instance.Profiles.add(to, profile);
    }

    public static ChartProfile createNewProfile(ChartProfile copy) {
        Object newName = "";
        int i = 1;
        while (((String)newName).isEmpty()) {
            Object testName = "New Profile";
            if (i > 1) {
                testName = (String)testName + " (" + i + ")";
            }
            for (ChartProfile p : ChartProfiles.instance.Profiles) {
                if (!p.profileName.equals(testName)) continue;
                ++i;
                break;
            }
            newName = testName;
        }
        ChartProfile newProfile = new ChartProfile((String)newName);
        newProfile.addStudy(new BarStudy.Configuration(""));
        if (copy != null) {
            ConfigSerializer ser = new ConfigSerializer(ConfigContext.Default);
            String xml = ser.serializeConfigSettings(copy, "ChartProfile");
            Log.d(TAG, "createNewChartProfile(), COPY: " + xml);
            ConfigReader rdr = new ConfigReader(ConfigContext.Default);
            rdr.parseConfigSettings(xml, (Configurable)newProfile);
        }
        newProfile.profileID = ChartProfiles.getProfileID();
        return newProfile;
    }

    private static void checkInitialized() {
        if (ChartProfiles.instance.Profiles.size() == 0) {
            ChartProfile p = ChartProfiles.createDefaultProfile();
            p.profileName = "Default";
            ChartProfiles.instance.Profiles.add(p);
        }
    }

    public static ChartProfile createDefaultProfile() {
        ChartProfile profile = new ChartProfile("Default");
        BarStudy.Configuration bars = new BarStudy.Configuration(UUID.randomUUID().toString());
        VolumeUnderlayStudy.Configuration volu = new VolumeUnderlayStudy.Configuration(UUID.randomUUID().toString());
        BollingerBands.Configuration boll = new BollingerBands.Configuration(UUID.randomUUID().toString());
        MACDStudy.Configuration macd = new MACDStudy.Configuration(UUID.randomUUID().toString());
        VolumeStudy.Configuration vol = new VolumeStudy.Configuration(UUID.randomUUID().toString());
        profile.addStudy(bars);
        profile.addStudy(volu);
        profile.addStudy(boll);
        profile.addStudy(macd);
        profile.addStudy(vol);
        bars.BarType = BarStudy.BarChartType.CandleStick;
        bars.LineThickness = 1;
        bars.RisingColor = ColorUtil.rgb(0, 128, 255);
        bars.FallingColor = ColorUtil.rgb(255, 0, 0);
        boll.LineColor = ColorUtil.rgb(0, 192, 0);
        boll.LineThickness = 1;
        return profile;
    }

    public static boolean checkName(String name) {
        for (ChartProfile p : ChartProfiles.instance.Profiles) {
            if (!p.profileName.equals(name)) continue;
            return false;
        }
        return true;
    }
}

