/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.settings;

import com.t4login.application.chart.settings.AccountSettings;
import com.t4login.application.chart.settings.ChartGeneralSettings;
import com.t4login.application.chart.settings.ChartPreferenceHeader;
import com.t4login.application.chart.settings.DataSettings;
import com.t4login.application.chart.studies.BarStudy;
import com.t4login.application.chart.studies.StudyDefinition;
import com.t4login.application.chart.studies.StudyType;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.IncludeConfig;
import com.t4login.application.configuration.IncludeConfigs;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.definitions.ChartType;
import com.t4login.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class ChartProfile
extends Configurable {
    @PropertyConfig(idx=0, name="chart_profile_name", description="chart_profile_name_descr")
    public String profileName;
    @PropertyConfig(idx=1, name="chart_profile_uuid", description="chart_profile_uuid_descr")
    public long profileID = -1L;
    @PropertyConfig(idx=2, name="chart_profile_selected_indicator_study_index", description="empty")
    @DefaultValue(value="0")
    public int SelectedIndicatorIndex = 0;
    @IncludeConfig(idx=3)
    public ChartGeneralSettings General = new ChartGeneralSettings();
    @IncludeConfig(idx=4)
    public DataSettings Data = new DataSettings();
    @IncludeConfig(idx=5)
    public AccountSettings Account = new AccountSettings();
    @IncludeConfigs(idx=6, as="Study")
    public List<Configurable> studies = new ArrayList<Configurable>();
    private Map<String, Configurable> mConfigurables = null;

    public ChartProfile(String name, String id) {
        super(id);
        this.profileName = name;
    }

    public ChartProfile(String name) {
        this(name, UUID.randomUUID().toString());
    }

    public ChartProfile() {
        this("", UUID.randomUUID().toString());
    }

    private void initConfigurables() {
        this.mConfigurables = new HashMap<String, Configurable>();
        this.mConfigurables.put(this.General.uid, this.General);
        this.mConfigurables.put(this.Data.uid, this.Data);
        this.mConfigurables.put(this.Account.uid, this.Account);
        for (Configurable studyConfig : this.studies) {
            this.mConfigurables.put(studyConfig.uid, studyConfig);
        }
    }

    public String getDescription() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.Data.barInterval.toString());
        List<Configurable> studyConfigs = this.getSortedStudies();
        for (int i = 0; i < Math.min(6, studyConfigs.size()); ++i) {
            if (studyConfigs.get(i) instanceof BarStudy.Configuration) {
                BarStudy.Configuration bars = (BarStudy.Configuration)studyConfigs.get(i);
                parts.add(bars.BarType.getDescription());
                continue;
            }
            parts.add(studyConfigs.get(i).toString());
        }
        if (studyConfigs.size() > 6) {
            parts.add("...");
        }
        return TextUtils.join((CharSequence)", ", parts);
    }

    @Override
    public String toString() {
        return this.profileName;
    }

    @Override
    public String configID() {
        return "ChartProfile";
    }

    @Override
    public String configurableName() {
        return "Chart Profile";
    }

    public void addStudy(Configurable studyConfig) {
        this.initConfigurables();
        for (int i = 0; i < this.studies.size(); ++i) {
            Configurable study = this.studies.get(i);
            if (!Objects.equals(study.configurableName(), studyConfig.configurableName())) continue;
            return;
        }
        this.studies.add(studyConfig);
        this.mConfigurables.put(studyConfig.uid, studyConfig);
    }

    public void removeStudy(Configurable studyConfig) {
        this.initConfigurables();
        this.studies.remove(studyConfig);
        this.mConfigurables.remove(studyConfig.uid);
    }

    public BarStudy.Configuration getPrimaryStudyConfig() {
        for (Configurable studyConfig : this.studies) {
            if (!(studyConfig instanceof BarStudy.Configuration)) continue;
            return (BarStudy.Configuration)studyConfig;
        }
        return null;
    }

    public ChartType getChartType() {
        BarStudy.Configuration barConfig = this.getPrimaryStudyConfig();
        if (barConfig != null) {
            if (barConfig.BarType == BarStudy.BarChartType.HeikenAshi) {
                return ChartType.HeikenAshi;
            }
            if (barConfig.BarType == BarStudy.BarChartType.Renko) {
                return ChartType.Renko;
            }
            if (barConfig.BarType == BarStudy.BarChartType.PointAndFigure) {
                return ChartType.PointAndFigure;
            }
            return ChartType.Bar;
        }
        return ChartType.Bar;
    }

    public List<Configurable> getSortedStudies() {
        StudyType typ;
        ArrayList<Configurable> studies = new ArrayList<Configurable>();
        for (Configurable study : this.studies) {
            typ = ChartProfile.getStudyTypeForConfiguration(study);
            if (typ != StudyType.Bar) continue;
            studies.add(study);
        }
        for (Configurable study : this.studies) {
            typ = ChartProfile.getStudyTypeForConfiguration(study);
            if (typ != StudyType.Overlay) continue;
            studies.add(study);
        }
        for (Configurable study : this.studies) {
            typ = ChartProfile.getStudyTypeForConfiguration(study);
            if (typ != StudyType.Underlay) continue;
            studies.add(study);
        }
        for (Configurable study : this.studies) {
            typ = ChartProfile.getStudyTypeForConfiguration(study);
            if (typ != StudyType.Indicator) continue;
            studies.add(study);
        }
        return studies;
    }

    public List<ChartPreferenceHeader> getPreferenceHeaders() {
        Category cat;
        StudyType typ;
        ArrayList<ChartPreferenceHeader> headers = new ArrayList<ChartPreferenceHeader>();
        headers.add(new ChartPreferenceHeader(this.General.configurableName(), "chart_general_settings", this.General.uid));
        headers.add(new ChartPreferenceHeader(this.Data.configurableName(), "chart_data_settings", this.Data.uid));
        headers.add(new ChartPreferenceHeader(this.Account.configurableName(), "chart_account_settings", this.Account.uid));
        for (Configurable study : this.studies) {
            typ = ChartProfile.getStudyTypeForConfiguration(study);
            if (typ != StudyType.Bar) continue;
            cat = study.getClass().getAnnotation(Category.class);
            if (cat != null) {
                headers.add(new ChartPreferenceHeader(study.configurableName(), cat.value(), study.uid));
                continue;
            }
            headers.add(new ChartPreferenceHeader(study.configurableName(), "", study.uid));
        }
        for (Configurable study : this.studies) {
            typ = ChartProfile.getStudyTypeForConfiguration(study);
            if (typ != StudyType.Overlay) continue;
            cat = study.getClass().getAnnotation(Category.class);
            if (cat != null) {
                headers.add(new ChartPreferenceHeader(study.configurableName(), cat.value(), study.uid, true));
                continue;
            }
            headers.add(new ChartPreferenceHeader(study.configurableName(), "", study.uid, true));
        }
        for (Configurable study : this.studies) {
            typ = ChartProfile.getStudyTypeForConfiguration(study);
            if (typ != StudyType.Underlay) continue;
            cat = study.getClass().getAnnotation(Category.class);
            if (cat != null) {
                headers.add(new ChartPreferenceHeader(study.configurableName(), cat.value(), study.uid, true));
                continue;
            }
            headers.add(new ChartPreferenceHeader(study.configurableName(), "", study.uid, true));
        }
        for (Configurable study : this.studies) {
            typ = ChartProfile.getStudyTypeForConfiguration(study);
            if (typ != StudyType.Indicator) continue;
            cat = study.getClass().getAnnotation(Category.class);
            if (cat != null) {
                headers.add(new ChartPreferenceHeader(study.configurableName(), cat.value(), study.uid, true));
                continue;
            }
            headers.add(new ChartPreferenceHeader(study.configurableName(), "", study.uid, true));
        }
        return headers;
    }

    public static boolean isStudyConfigurable(Configurable c) {
        Class<?> studyClass = c.getClass().getEnclosingClass();
        if (studyClass != null) {
            StudyDefinition sdef = studyClass.getAnnotation(StudyDefinition.class);
            return sdef != null;
        }
        return false;
    }

    public static StudyType getStudyTypeForConfiguration(Configurable c) {
        StudyDefinition sdef;
        StudyType typ = StudyType.Indicator;
        Class<?> studyClass = c.getClass().getEnclosingClass();
        if (studyClass != null && (sdef = studyClass.getAnnotation(StudyDefinition.class)) != null) {
            typ = sdef.type();
        }
        return typ;
    }

    public Configurable getConfigurable(String uuid) {
        this.initConfigurables();
        return this.mConfigurables.get(uuid);
    }

    public List<Configurable> getConfigurables() {
        ArrayList<Configurable> configs = new ArrayList<Configurable>();
        configs.add(this.General);
        configs.add(this.Data);
        configs.add(this.Account);
        configs.addAll(this.studies);
        return configs;
    }
}

