/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.settings;

import com.t4login.Resource;
import com.t4login.application.configuration.Category;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.IEnum;
import com.t4login.application.configuration.PropertyConfig;
import java.util.HashMap;
import java.util.Map;

@Category(value="chart_account_settings")
public class AccountSettings
extends Configurable {
    @PropertyConfig(idx=0, name="account_display_working", description="account_display_working_descr")
    @DefaultValue(value="Trading")
    public DisplayOrdersWhen DisplayWorkingOrders = DisplayOrdersWhen.Trading;
    @PropertyConfig(idx=1, name="account_display_fills", description="account_display_fills_descr")
    @DefaultValue(value="Trading")
    public DisplayWhen DisplayFills = DisplayWhen.Trading;
    @PropertyConfig(idx=2, name="account_highlight_average_fill_price", description="account_highlight_average_fill_price_descr")
    @DefaultValue(value="Trading")
    public DisplayWhen DisplayAverageFillPrice = DisplayWhen.Trading;

    @Override
    public String configID() {
        return "Account";
    }

    @Override
    public String configurableName() {
        return Resource.localizeString("chart_account_settings");
    }

    public static enum DisplayOrdersWhen implements IEnum
    {
        Trading(0, "account_display_when_trading"),
        Always(1, "account_display_when_always");

        private final int value;
        private final String descr_loc;
        private static Map<Integer, DisplayOrdersWhen> map;

        private DisplayOrdersWhen(int value, String descr_loc) {
            this.value = value;
            this.descr_loc = descr_loc;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public String getDescription() {
            return Resource.localizeString(this.descr_loc);
        }

        public static DisplayOrdersWhen get(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, DisplayOrdersWhen>();
            for (DisplayOrdersWhen t : DisplayOrdersWhen.values()) {
                map.put(t.getValue(), t);
            }
        }
    }

    public static enum DisplayWhen implements IEnum
    {
        Never(0, "account_display_when_never"),
        Trading(1, "account_display_when_trading"),
        Always(2, "account_display_when_always");

        private final int value;
        private final String descr_loc;
        private static Map<Integer, DisplayWhen> map;

        private DisplayWhen(int value, String descr_loc) {
            this.value = value;
            this.descr_loc = descr_loc;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public String getDescription() {
            return Resource.localizeString(this.descr_loc);
        }

        public static DisplayWhen get(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, DisplayWhen>();
            for (DisplayWhen t : DisplayWhen.values()) {
                map.put(t.getValue(), t);
            }
        }
    }
}

