/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.scales;

import com.t4login.Resource;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import java.util.EnumSet;

public class ValueScaleConfig
extends Configurable {
    @PropertyConfig(idx=0, name="chart_value_scale_display_decimals_name", description="chart_value_scale_display_decimals_descr")
    @NumberFormatF(minValue=0.0f, maxValue=10.0f, increment=1.0f, displayDecimals=0)
    @DefaultValue(value="1")
    public int DisplayDecimals = 1;
    @PropertyConfig(idx=1, name="chart_value_scale_logarithmic_name", description="chart_value_scale_logarithmic_descr")
    @DefaultValue(value="false")
    public boolean LogScale = false;
    public boolean AbbreviatedUnits = false;
    public boolean RenderScale = true;
    private final EnumSet<AllowOptions> mAllowedOptions;

    public ValueScaleConfig() {
        this.mAllowedOptions = EnumSet.allOf(AllowOptions.class);
    }

    public ValueScaleConfig(EnumSet<AllowOptions> allowedOptions) {
        this.mAllowedOptions = allowedOptions;
    }

    @Override
    public String configID() {
        return "ValueScaleConfig";
    }

    @Override
    public String configurableName() {
        return Resource.localizeString("chart_value_scale");
    }

    @Override
    public boolean filterProperty(String propertyName) {
        if (propertyName.equals("DisplayDecimals") && !this.mAllowedOptions.contains((Object)AllowOptions.DisplayDecimals)) {
            return true;
        }
        return propertyName.equals("LogScale") && !this.mAllowedOptions.contains((Object)AllowOptions.LogScale);
    }

    public static enum AllowOptions {
        DisplayDecimals,
        LogScale;

    }
}

