/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.scales;

import com.t4login.Log;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.application.chart.scales.ValueScaleConfig;
import com.t4login.util.Range;
import java.util.EnumSet;

public class ValueScale
implements IValueScale {
    private static final String TAG = "ValueScale";
    private double mScaleInterval = 20.0;
    private Range<Double> mValueRange = Range.of(0.0, 100.0);
    private Range<Double> mScaleValueRange = Range.empty();
    private Range<Float> mPlotRange = Range.empty();
    private float mPlotRangeMarginTop = 0.0f;
    private float mPlotRangeMarginBottom = 0.0f;
    private EnumSet<ScaleBehavior> mScaleOptions = EnumSet.noneOf(ScaleBehavior.class);
    public final ValueScaleConfig Config;
    private static Compute pnlog10 = new Compute(){

        @Override
        public double compute(double v) {
            return v == 0.0 ? 0.0 : (double)(v < 0.0 ? -1 : 1) * Math.log10(Math.abs(v));
        }
    };
    private static Compute pnpow10 = new Compute(){

        @Override
        public double compute(double v) {
            return v == 0.0 ? 0.0 : (double)(v < 0.0 ? -1 : 1) * Math.pow(10.0, Math.abs(v));
        }
    };

    public ValueScale(EnumSet<ScaleBehavior> options) {
        this.Config = new ValueScaleConfig();
        this.mScaleOptions = options;
    }

    public ValueScale(EnumSet<ScaleBehavior> options, ValueScaleConfig config) {
        this.Config = config;
        this.mScaleOptions = options;
        if (config.LogScale) {
            this.mScaleOptions.add(ScaleBehavior.Logarithmic);
        } else {
            this.mScaleOptions.remove((Object)ScaleBehavior.Logarithmic);
        }
    }

    public ValueScale(ValueScaleConfig config) {
        this.Config = config;
        this.mScaleOptions = EnumSet.noneOf(ScaleBehavior.class);
        if (config.LogScale) {
            this.mScaleOptions.add(ScaleBehavior.Logarithmic);
        }
    }

    public Range<Double> getScaleValueRange() {
        return this.mScaleValueRange;
    }

    public double getScaleInterval() {
        return this.mScaleInterval;
    }

    public boolean isLogarithmic() {
        return this.mScaleOptions.contains((Object)ScaleBehavior.Logarithmic);
    }

    private void computeScale() {
        if (this.mScaleOptions.contains((Object)ScaleBehavior.Logarithmic)) {
            this.computeLogScale();
        } else {
            this.computeLinearScale();
        }
    }

    private void computeLinearScale() {
        double scRangeStart = this.mValueRange.start();
        double scRangeEnd = this.mValueRange.end();
        double rval = Math.abs(scRangeStart) > Math.abs(scRangeEnd) ? Math.abs(scRangeStart) : Math.abs(scRangeEnd);
        int exp = (int)Math.floor(Math.log10(rval));
        double pwr = Math.pow(10.0, exp);
        double[] maju = new double[]{pwr / 5.0, pwr / 2.0, pwr};
        double[] minu = new double[]{maju[0] / 5.0, maju[1] / 5.0, maju[2] / 5.0};
        int r = 0;
        if (Math.floor(rval) > Math.ceil(2.0 * pwr) && rval <= 4.0 * pwr) {
            r = 1;
        } else if (rval > 4.0 * pwr) {
            r = 2;
        }
        double majorUnit = maju[r];
        double rangeStart = 0.0;
        double rangeEnd = 0.0;
        if (!this.mScaleOptions.contains((Object)ScaleBehavior.FixedRange)) {
            double negrng;
            boolean pos = scRangeEnd >= 0.0;
            boolean neg = scRangeStart < 0.0;
            double posrng = scRangeEnd >= 0.0 ? scRangeEnd : 0.0;
            double d = negrng = scRangeStart < 0.0 ? -scRangeStart : 0.0;
            if (this.mScaleOptions.contains((Object)ScaleBehavior.Symmetric)) {
                neg = true;
                pos = true;
                posrng = negrng = rval;
            }
            if (neg) {
                rangeStart = this.mScaleOptions.contains((Object)ScaleBehavior.Tight) ? -Math.ceil(negrng / majorUnit) * majorUnit : -Math.ceil((negrng + majorUnit / 5.0) / majorUnit) * majorUnit;
            }
            if (pos) {
                rangeEnd = this.mScaleOptions.contains((Object)ScaleBehavior.Tight) ? Math.ceil(posrng / majorUnit) * majorUnit : Math.ceil((posrng + majorUnit / 5.0) / majorUnit) * majorUnit;
            }
            if (pos && !neg && !this.mScaleOptions.contains((Object)ScaleBehavior.CrossesZero)) {
                rangeStart = this.mScaleOptions.contains((Object)ScaleBehavior.Tight) ? Math.floor(scRangeStart / majorUnit) * majorUnit : Math.floor((scRangeStart + majorUnit / 5.0) / majorUnit) * majorUnit;
            }
            if (!pos && neg && !this.mScaleOptions.contains((Object)ScaleBehavior.CrossesZero)) {
                rangeEnd = this.mScaleOptions.contains((Object)ScaleBehavior.Tight) ? Math.ceil(scRangeEnd / majorUnit) * majorUnit : Math.ceil((scRangeEnd + majorUnit / 5.0) / majorUnit) * majorUnit;
            }
        }
        this.mScaleValueRange = new Range<Double>(rangeStart, rangeEnd);
        this.mScaleInterval = majorUnit;
    }

    private void computeLogScale() {
        this.mScaleInterval = 10.0;
        double rangeStart = this.mValueRange.start();
        double rangeEnd = this.mValueRange.end();
        if (!this.mScaleOptions.contains((Object)ScaleBehavior.FixedRange)) {
            if (rangeStart > rangeEnd) {
                rangeStart = this.mValueRange.end();
                rangeEnd = this.mValueRange.start();
            }
            if (rangeStart == 0.0 && rangeEnd == 0.0) {
                rangeStart = 0.0;
                rangeEnd = 1.0;
            } else if (rangeStart < 0.0 && rangeEnd < 0.0) {
                rangeEnd = 0.0;
            } else if (rangeStart > 0.0 && rangeEnd > 0.0) {
                rangeStart = 0.0;
            }
            rangeStart = pnpow10.compute(Math.floor(pnlog10.compute(rangeStart)));
            rangeEnd = pnpow10.compute(Math.ceil(pnlog10.compute(rangeEnd)));
        }
        this.mScaleValueRange = new Range<Double>(rangeStart, rangeEnd);
    }

    @Override
    public void setPlotRange(Range<Float> plotRange) {
        if (!plotRange.equals(this.mPlotRange)) {
            this.mPlotRange = plotRange;
            this.computeScale();
        }
    }

    @Override
    public Range<Float> getPlotRange() {
        return this.mPlotRange;
    }

    @Override
    public void setPlotRangeMarginTop(float margin) {
        this.mPlotRangeMarginTop = margin;
    }

    @Override
    public float getPlotRangeMarginTop() {
        return this.mPlotRangeMarginTop;
    }

    @Override
    public void setPlotRangeMarginBottom(float margin) {
        this.mPlotRangeMarginBottom = margin;
    }

    @Override
    public float getPlotRangeMarginBottom() {
        return this.mPlotRangeMarginBottom;
    }

    @Override
    public void setScaleValueRange(Range<Double> valueRange) {
        if (valueRange == null || valueRange.isEmpty() || valueRange.end().equals(valueRange.start())) {
            this.mValueRange = Range.of(0.0, 100.0);
        } else {
            this.mValueRange = valueRange;
            this.computeScale();
        }
    }

    @Override
    public float getValuePosition(double value) {
        Range<Float> plotRange = Range.of(Float.valueOf(this.mPlotRange.start().floatValue() + this.mPlotRangeMarginTop), Float.valueOf(this.mPlotRange.end().floatValue() - this.mPlotRangeMarginBottom));
        if (this.mScaleOptions.contains((Object)ScaleBehavior.Logarithmic)) {
            double pxrng = Math.abs(plotRange.end().floatValue() - plotRange.start().floatValue());
            double scmax = this.mScaleValueRange.end();
            double scmin = this.mScaleValueRange.start();
            double logmax = pnlog10.compute(scmax);
            double logmin = pnlog10.compute(scmin);
            double scrng = Math.abs(logmax - logmin);
            double dpxval = plotRange.isNormal() ? (double)plotRange.end().floatValue() - pxrng / scrng * (pnlog10.compute(value) - pnlog10.compute(this.mScaleValueRange.start())) : (double)plotRange.start().floatValue() - pxrng / scrng * (pnlog10.compute(value) - pnlog10.compute(this.mScaleValueRange.start()));
            return (float)dpxval;
        }
        if (!plotRange.isEmpty()) {
            double pxrng = Math.abs(plotRange.end().floatValue() - plotRange.start().floatValue());
            double scrng = Math.abs(this.mScaleValueRange.end() - this.mScaleValueRange.start());
            double coordval = plotRange.isNormal() ? (double)plotRange.end().floatValue() - pxrng / scrng * (value - this.mScaleValueRange.start()) : (double)plotRange.start().floatValue() - pxrng / scrng * (value - this.mScaleValueRange.start());
            if (Double.isNaN(coordval)) {
                Log.e(TAG, "ValueScale.GetPixelForValue(), coordval (" + value + ") IsNaN");
                coordval = 0.0;
            }
            return (float)coordval;
        }
        return 0.0f;
    }

    @Override
    public double getPositionValue(float pos, boolean snapToNearest) {
        Range<Float> plotRange = Range.of(Float.valueOf(this.mPlotRange.start().floatValue() + this.mPlotRangeMarginTop), Float.valueOf(this.mPlotRange.end().floatValue() - this.mPlotRangeMarginBottom));
        if (this.mScaleOptions.contains((Object)ScaleBehavior.Logarithmic)) {
            double pxrng = Math.abs(plotRange.end().floatValue() - plotRange.start().floatValue());
            double scmax = this.mScaleValueRange.end();
            double scmin = this.mScaleValueRange.start();
            double logmax = pnlog10.compute(scmax);
            double logmin = pnlog10.compute(scmin);
            double scrng = Math.abs(logmax - logmin);
            double val = plotRange.isNormal() ? this.mScaleValueRange.start() + Math.pow(10.0, scrng / pxrng * (double)(plotRange.end().floatValue() - pos)) : this.mScaleValueRange.start() + Math.pow(10.0, scrng / pxrng * (double)(plotRange.start().floatValue() - pos));
            return val;
        }
        double pxrng = Math.abs(plotRange.end().floatValue() - plotRange.start().floatValue());
        double scrng = Math.abs(this.mScaleValueRange.end() - this.mScaleValueRange.start());
        double val = plotRange.isNormal() ? this.mScaleValueRange.start() + scrng / pxrng * (double)(plotRange.end().floatValue() - pos) : this.mScaleValueRange.start() + scrng / pxrng * (double)(plotRange.start().floatValue() - pos);
        return val;
    }

    @Override
    public double roundToScale(double value) {
        return value;
    }

    public static enum ScaleBehavior {
        None,
        Tight,
        Logarithmic,
        Reversed,
        Symmetric,
        CrossesZero,
        FixedRange;

    }

    static interface Compute {
        public double compute(double var1);
    }
}

