/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.scales;

import com.t4login.application.chart.scales.ValueScale;
import java.text.DecimalFormat;

public class ValueFormatter {
    private static final DecimalFormat mAbbrevFmt = new DecimalFormat("#,##0");
    private static final DecimalFormat mAbbrevFmt2 = new DecimalFormat("#,##0.0");

    public static String formatValue(ValueScale scale, double value) {
        if (scale.Config.AbbreviatedUnits && scale.Config.DisplayDecimals == 0) {
            if (value == 0.0) {
                return "0";
            }
            String[] units = new String[]{"", "K", "M"};
            double[] intvls = new double[]{0.0, 1000.0, 1000000.0};
            int digitGroups = Math.min(2, (int)(Math.log10(Math.abs(value)) / Math.log10(1000.0)));
            if (digitGroups > 0 && scale.getScaleInterval() < intvls[digitGroups] && value % intvls[digitGroups] != 0.0) {
                return mAbbrevFmt2.format(value / Math.pow(1000.0, digitGroups)) + units[digitGroups];
            }
            return mAbbrevFmt.format(value / Math.pow(1000.0, digitGroups)) + units[digitGroups];
        }
        return String.format("%." + scale.Config.DisplayDecimals + "f", value);
    }
}

