/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.scales;

import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataPointComparer;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.TradeDateDataPoint;
import com.t4login.application.chart.scales.TimeScale;
import com.t4login.collections.TreeSetDictionary;
import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;
import com.t4login.util.Range;
import java.util.ArrayList;

public class TradeDateScale {
    private TreeSetDictionary<TradeDatePosition, NDateTime> mTradeDatePositions = new TreeSetDictionary(DataPointComparer.ASCENDING);

    public TradeDateScale(BarDataSeries series, TimeScale scale) {
        if (series != null) {
            ArrayList<TradeDateDataPoint> tradeDates = new ArrayList<TradeDateDataPoint>();
            for (TradeDateDataPoint tddp : series.getTradeDates()) {
                tradeDates.add(tddp);
            }
            for (int i = 0; i < tradeDates.size(); ++i) {
                NTimeSpan gap;
                NDateTime starttime = ((TradeDateDataPoint)tradeDates.get((int)i)).timeRange.start();
                NDateTime endtime = ((TradeDateDataPoint)tradeDates.get((int)i)).timeRange.end();
                if (i > 0) {
                    gap = starttime.Subtract(((TradeDateDataPoint)tradeDates.get((int)(i - 1))).timeRange.end());
                    starttime = starttime.AddTicks(gap._ticks / -2L);
                }
                if (i < tradeDates.size() - 1) {
                    gap = ((TradeDateDataPoint)tradeDates.get((int)(i + 1))).timeRange.start().Subtract(endtime);
                    endtime = endtime.AddTicks(gap._ticks / 2L);
                }
                float pos1 = scale.getTimePosition(starttime);
                float pos2 = scale.getTimePosition(endtime);
                if (i == tradeDates.size() - 1) {
                    pos2 = Float.MAX_VALUE;
                }
                this.mTradeDatePositions.add(new TradeDatePosition((TradeDateDataPoint)tradeDates.get(i), new Range<Float>(Float.valueOf(pos1), Float.valueOf(pos2))));
            }
        }
    }

    public Float getTradeDatePosition(NDateTime tradeDate) {
        TradeDatePosition p = this.mTradeDatePositions.nearest(tradeDate, new TreeSetDictionary.DistanceComparer<TradeDatePosition, NDateTime>(this){

            @Override
            public int compareDistanceTo(NDateTime target, TradeDatePosition value1, TradeDatePosition vlaue2) {
                long targetTicks = target.getTicks();
                long v1Ticks = value1.getTime().getTicks();
                long v2Ticks = vlaue2.getTime().getTicks();
                if (Math.abs(targetTicks - v1Ticks) < Math.abs(targetTicks - v2Ticks)) {
                    return -1;
                }
                if (v1Ticks != v2Ticks) {
                    return 1;
                }
                return 0;
            }
        });
        if (p != null) {
            return p.PlotRange.start();
        }
        return null;
    }

    public Range<Float> getTradeDatePositionsRange(NDateTime tradeDate) {
        TradeDatePosition p = this.mTradeDatePositions.nearest(tradeDate, new TreeSetDictionary.DistanceComparer<TradeDatePosition, NDateTime>(this){

            @Override
            public int compareDistanceTo(NDateTime target, TradeDatePosition value1, TradeDatePosition vlaue2) {
                long targetTicks = target.getTicks();
                long v1Ticks = value1.getTime().getTicks();
                long v2Ticks = vlaue2.getTime().getTicks();
                if (Math.abs(targetTicks - v1Ticks) < Math.abs(targetTicks - v2Ticks)) {
                    return -1;
                }
                if (v1Ticks != v2Ticks) {
                    return 1;
                }
                return 0;
            }
        });
        if (p != null) {
            return p.PlotRange;
        }
        return Range.empty();
    }

    private static class TradeDatePosition
    implements IDataPoint {
        public final TradeDateDataPoint TradeDate;
        public final Range<Float> PlotRange;

        public TradeDatePosition(TradeDateDataPoint td, Range<Float> plotRange) {
            this.TradeDate = td;
            this.PlotRange = plotRange;
        }

        @Override
        public NDateTime getTime() {
            return this.TradeDate.getTime();
        }
    }
}

