/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.scales;

import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.application.chart.BarInterval;
import com.t4login.application.chart.SessionTimeRange;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.MarketModeDataPoint;
import com.t4login.application.configuration.Configurable;
import com.t4login.application.configuration.DefaultValue;
import com.t4login.application.configuration.NumberFormatF;
import com.t4login.application.configuration.PropertyConfig;
import com.t4login.collections.TreeSet;
import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;
import com.t4login.definitions.MarketMode;
import com.t4login.util.Range;
import com.t4login.util.RangeType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class TimeScale {
    public static final String TAG = "TimeScale";
    private final TreeSet<NDateTime> mTimePoints = new TreeSet<NDateTime>(new Comparator<NDateTime>(this){

        @Override
        public int compare(NDateTime dt1, NDateTime dt2) {
            return dt2.compareTo(dt1);
        }
    });
    private Range<Float> mPlotRange = Range.empty();
    private TimeScaleConfig mConfig = new TimeScaleConfig();
    private NDateTime mScrollTime;
    private NDateTime mLastBarTime;
    private float mScrollOffset = 0.0f;
    private float mExtraMargin = 0.0f;
    private boolean mScaleDataInitialized = false;
    private final float mIntervalSize = 20.0f;
    private float mZoomLevel = 1.0f;
    private float mDMScale = 1.0f;
    private final float mMinZoomLevel = 0.05f;
    private final float mMaxZoomLevel = 5.0f;
    private Range<NDateTime> mDataTimeRange = new Range();
    private Range<NDateTime> mScaleDateRange = new Range();
    private float mScaleHeight = 30.0f;
    private TimeScaleBreakMethod mBreakMethod = TimeScaleBreakMethod.OpenMarket;
    BarInterval mBarInterval = BarInterval.Default;
    SessionTimeRange mSession = SessionTimeRange.Empty;
    public NTimeSpan mAvgInterval = NTimeSpan.Zero;
    private List<IScaleScrollHandler> mScrollHandlers = new CopyOnWriteArrayList<IScaleScrollHandler>();
    List<String> mSeriesGenerationIDs = new ArrayList<String>();

    public TimeScale() {
        this.setDefaultScale();
    }

    public TimeScale(BarInterval intvl, NDateTime scrollTime, Range<Float> plotRange) {
        this.mBarInterval = intvl;
        this.mPlotRange = plotRange;
        this.setDefaultScale(scrollTime);
    }

    public void setDMScale(float dmScale) {
        Log.d(TAG, "setDMScale(), scale: " + dmScale);
        this.mDMScale = dmScale;
    }

    public void setConfig(TimeScaleConfig config) {
        this.mConfig = config;
    }

    public void registerForScroll(IScaleScrollHandler handler) {
        if (!this.mScrollHandlers.contains(handler)) {
            this.mScrollHandlers.add(handler);
        }
    }

    public void unregisterForScroll(IScaleScrollHandler handler) {
        if (this.mScrollHandlers.contains(handler)) {
            this.mScrollHandlers.remove(handler);
        }
    }

    public Range<NDateTime> getDataTimeRange() {
        return this.mDataTimeRange;
    }

    public float getIntervalSize() {
        return 20.0f * this.mZoomLevel * this.mDMScale;
    }

    public float getUnscaledIntervalSize() {
        return 20.0f;
    }

    public NTimeSpan getAvgInterval() {
        return this.mAvgInterval;
    }

    public BarInterval getBarInterval() {
        return this.mBarInterval;
    }

    public void setPlotRange(Range<Float> plotRange) {
        if (!this.mPlotRange.equals(plotRange)) {
            this.mPlotRange = plotRange;
            this.commitScroll();
        }
    }

    public Range<Float> getPlotRange() {
        return this.mPlotRange;
    }

    public float getExtraMargin() {
        return this.mExtraMargin;
    }

    public void setExtraMargin(float value) {
        this.mExtraMargin = value;
    }

    public NDateTime getEarliestVisibleTime() {
        Range<NDateTime> plotrange = this.getPlotTimeRange();
        NDateTime lastvisibletime = this.mBarInterval.roundDownToInterval(plotrange.start(), this.mAvgInterval);
        return lastvisibletime;
    }

    public NDateTime getScrollTime() {
        return this.mScrollTime;
    }

    public float getScrollOffset() {
        return this.mScrollOffset;
    }

    public NDateTime getEarliestScaleDate() {
        return this.mTimePoints.last();
    }

    public void scrollTo(NDateTime scrolldt) {
        this.scrollTo(scrolldt, true);
    }

    public void scrollToEnd() {
        if (this.mTimePoints.size() > 0) {
            this.scrollTo(this.mTimePoints.first(), true);
        } else {
            this.scrollTo(NDateTime.now(), true);
        }
    }

    private void scrollTo(NDateTime scrolldt, boolean commit) {
        this.mScrollTime = scrolldt;
        this.mScrollOffset = (this.mPlotRange.end().floatValue() - this.mPlotRange.start().floatValue() - this.mExtraMargin - this.getIntervalSize()) * (float)this.mConfig.DefaultScaleMargin / 100.0f + this.getIntervalSize() + this.mExtraMargin;
        if (commit) {
            this.commitScroll();
        }
    }

    public void scrollScale(float amount) {
        this.mScrollOffset += amount;
        this.commitScroll(true);
    }

    public void zoomScale(float amount) {
        this.mZoomLevel *= amount;
        this.mZoomLevel = Math.max(Math.min(this.mZoomLevel, 5.0f), 0.05f);
        this.onScaleExpanded();
    }

    public float getZoomLevel() {
        return this.mZoomLevel;
    }

    public void setZoomLevel(float level) {
        if (Float.isNaN(level)) {
            level = 1.0f;
        }
        this.mZoomLevel = level;
        this.mZoomLevel = Math.max(Math.min(this.mZoomLevel, 20.0f), 0.01f);
        this.onScaleExpanded();
    }

    public void reset() {
        this.mScaleDataInitialized = false;
        this.setDefaultScale(NDateTime.now());
    }

    public void reset(BarInterval newintvl, SessionTimeRange session) {
        this.mScaleDataInitialized = false;
        this.reset(newintvl, session, NDateTime.now());
    }

    public void reset(BarInterval newintvl, SessionTimeRange session, NDateTime currtime) {
        this.mScaleDataInitialized = false;
        this.mBarInterval = newintvl;
        this.mSession = session;
        this.setDefaultScale(currtime);
    }

    public void setToBarDataSeries(List<BarDataSeries> series) {
        this.setToBarDataSeries(series, false);
    }

    public void setToBarDataSeries(BarDataSeries series, boolean reset) {
        ArrayList<BarDataSeries> ser = new ArrayList<BarDataSeries>();
        ser.add(series);
        this.setToBarDataSeries(ser, reset);
    }

    /*
     * WARNING - void declaration
     */
    public void setToBarDataSeries(List<BarDataSeries> series, boolean reset) {
        int i;
        if (this.mPlotRange.isEmpty()) {
            return;
        }
        if (series.size() > 0) {
            if (series.get(0).getCount() > 0) {
                Log.d(TAG, "setToBarDataSeries(), reset: " + reset + ", series count: " + series.get(0).getCount() + ", last: " + String.valueOf(series.get(0).getLast().getTime()));
            } else {
                Log.d(TAG, "setToBarDataSeries(), reset: " + reset + ", series count: " + series.get(0).getCount());
            }
        } else {
            Log.d(TAG, "setToBarDataSeries(), reset: " + reset + ", No Data");
        }
        if (!reset) {
            if (series.size() != this.mSeriesGenerationIDs.size()) {
                reset = true;
                Log.d(TAG, "setToBarDataSeries(), Forcing scale reset do to new data series set.");
            } else {
                for (i = 0; i < series.size(); ++i) {
                    if (series.get(i).getGenerationID() == this.mSeriesGenerationIDs.get(i)) continue;
                    Log.d(TAG, "setToBarDataSeries(), Forcing scale reset due to non-matching data series generation id's.");
                    break;
                }
            }
        }
        this.mSeriesGenerationIDs.clear();
        for (i = 0; i < series.size(); ++i) {
            this.mSeriesGenerationIDs.add(series.get(i).getGenerationID());
        }
        if (series == null || series.size() == 0) {
            return;
        }
        this.mDataTimeRange = Range.empty();
        for (BarDataSeries ser : series) {
            this.mDataTimeRange = this.mDataTimeRange.expanded(ser.getTimeRange());
        }
        if (this.mDataTimeRange.isEmpty()) {
            return;
        }
        try {
            boolean autoscroll = false;
            Range<NDateTime> plotrange = this.getPlotTimeRange();
            if (plotrange.contains(this.mLastBarTime)) {
                autoscroll = true;
            }
            boolean forcebreakallgaps = this.mBarInterval.compareTo(BarInterval.Bar1Day) >= 0 || !this.mSession.isAllInclusive() || series.size() > 1 || !this.mBarInterval.isTimeBased();
            for (BarDataSeries barDataSeries : series) {
                if (barDataSeries.isEmpty() || !barDataSeries.getModeData().isEmpty()) continue;
                forcebreakallgaps = true;
            }
            if (forcebreakallgaps || this.mBreakMethod == TimeScaleBreakMethod.BreakAllGaps) {
                if (reset) {
                    this.mTimePoints.clear();
                    this.mTimePoints.add(this.mScrollTime);
                    Log.d(TAG, "SetToBarDataSeries(), Reset scale.");
                }
                if (this.mTimePoints.size() == 1 || reset) {
                    if (!this.mScaleDataInitialized && this.mTimePoints.size() == 1 && series.get(0).getCount() > 0) {
                        this.scrollTo(series.get(0).get(series.get(0).getCount() - 1).getTime(), false);
                        Log.d(TAG, "setToBarDataSeries(), Resetting scroll position to: " + String.valueOf(series.get(0).get(series.get(0).getCount() - 1).getTime()));
                        this.mScaleDataInitialized = true;
                    }
                    NDateTime initpoint = NDateTime.MinValue;
                    initpoint = this.mTimePoints.get(0);
                    this.mTimePoints.clear();
                    for (BarDataSeries ser : series) {
                        for (IBarDataPoint bar : ser) {
                            this.mTimePoints.add(bar.getTime());
                        }
                    }
                    if (this.mTimePoints.size() == 0) {
                        this.mTimePoints.add(initpoint);
                    }
                } else {
                    void var7_15;
                    NDateTime scaleEnd = this.mTimePoints.last();
                    while (this.mDataTimeRange.start().compareTo(scaleEnd) > 0) {
                        this.mTimePoints.remove(scaleEnd);
                        scaleEnd = this.mTimePoints.last();
                    }
                    NDateTime nDateTime = this.mTimePoints.first();
                    while (this.mDataTimeRange.end().compareTo((NDateTime)var7_15) < 0) {
                        this.mTimePoints.remove((NDateTime)var7_15);
                        NDateTime nDateTime2 = this.mTimePoints.first();
                    }
                    Range<NDateTime> scaletimerange = Range.of(this.mTimePoints.last(), this.mTimePoints.first());
                    for (BarDataSeries ser : series) {
                        if (this.mDataTimeRange.start().compareTo(scaletimerange.start()) < 0) {
                            for (IBarDataPoint bar : ser.getPointsBetween(Range.of(this.mDataTimeRange.start(), scaletimerange.start()), RangeType.Enclosed)) {
                                this.mTimePoints.add(bar.getTime());
                            }
                        }
                        if (this.mDataTimeRange.end().compareTo(scaletimerange.end()) <= 0) continue;
                        for (IBarDataPoint bar : ser.getPointsBetween(Range.of(scaletimerange.end(), this.mDataTimeRange.end()), RangeType.Enclosed)) {
                            this.mTimePoints.add(bar.getTime());
                        }
                    }
                }
                if (reset) {
                    long avgspanticks = 0L;
                    int avgdiv = 0;
                    NDateTime prevtime = NDateTime.MinValue;
                    for (int i2 = this.mTimePoints.size() - 1; i2 >= 0 && i2 >= this.mTimePoints.size() - 200; --i2) {
                        NDateTime ttime = this.mTimePoints.get(i2);
                        if (!prevtime.equals(NDateTime.MinValue)) {
                            NTimeSpan ts = prevtime.Subtract(ttime);
                            avgspanticks = (long)((double)avgspanticks + Math.abs(ts.getTotalMilliseconds()));
                            ++avgdiv;
                        }
                        prevtime = ttime;
                    }
                    this.mAvgInterval = avgspanticks > 0L ? NTimeSpan.fromMilliseconds(avgspanticks / (long)avgdiv) : NTimeSpan.Zero;
                    Log.d(TAG, "setToBarDataSeries(), AvgInterval: " + String.valueOf(this.mAvgInterval));
                }
            } else if (this.mBreakMethod == TimeScaleBreakMethod.ContinuousScale) {
                this.mScaleDataInitialized = true;
            } else if (this.mBreakMethod == TimeScaleBreakMethod.OpenMarket) {
                IBarDataPoint bar;
                NDateTime time;
                void var7_19;
                BarDataSeries ser = series.get(0);
                if (!this.mScaleDataInitialized && this.mTimePoints.size() == 1 && ser.getCount() > 0) {
                    this.scrollTo(ser.get(ser.getCount() - 1).getTime(), false);
                    this.mScaleDataInitialized = true;
                }
                this.mTimePoints.clear();
                this.mTimePoints.add(this.mBarInterval.roundToNearestInterval(this.mDataTimeRange.end(), NTimeSpan.Zero));
                ArrayList<Range<NDateTime>> arrayList = new ArrayList<Range<NDateTime>>();
                arrayList.addAll(this.getMarketClosedPeriods(series.get(0).getModeData()));
                for (int i3 = 1; i3 < series.size(); ++i3) {
                    ArrayList intersected = new ArrayList();
                    for (Range<NDateTime> closed : this.getMarketClosedPeriods(series.get(i3).getModeData())) {
                        for (int j = 0; j < var7_19.size(); ++j) {
                            Range<NDateTime> intersect = closed.condensed((Range)var7_19.get(j));
                            if (intersect.isEmpty()) continue;
                            intersected.add(intersect);
                        }
                    }
                    Object object = intersected;
                }
                HashSet<NDateTime> closedintervals = new HashSet<NDateTime>();
                for (Range rng : var7_19) {
                    Range<NDateTime> pullrng = Range.of(this.mBarInterval.roundUpToInterval((NDateTime)rng.start(), NTimeSpan.Zero), this.mBarInterval.roundDownToInterval((NDateTime)rng.end(), NTimeSpan.Zero));
                    if (pullrng.isEmpty() || pullrng.start().equals(pullrng.end())) continue;
                    NDateTime pulltime = pullrng.start();
                    while (pulltime.compareTo(pullrng.end()) <= 0) {
                        closedintervals.add(pulltime);
                        pulltime = this.mBarInterval.getNextIntervalTime(pulltime, NTimeSpan.Zero);
                    }
                }
                NDateTime initpoint = NDateTime.MinValue;
                if (this.mTimePoints.size() == 1) {
                    initpoint = this.mTimePoints.first();
                }
                NDateTime scalestart = this.mTimePoints.last();
                NDateTime scaleend = this.mTimePoints.first();
                NDateTime serstart = ser.getTimeRange().start();
                NDateTime serend = ser.getTimeRange().end();
                int npoints = 0;
                if (serstart.compareTo(scalestart) <= 0) {
                    time = this.mBarInterval.roundUpToInterval(serstart, NTimeSpan.Zero);
                    while (time.compareTo(scalestart) < 0) {
                        if (!closedintervals.contains(time)) {
                            this.mTimePoints.add(time);
                            ++npoints;
                        } else {
                            bar = ser.getNearestTo(time);
                            if (bar != null && bar.getTime().equals(time)) {
                                this.mTimePoints.add(time);
                                ++npoints;
                            }
                        }
                        time = this.mBarInterval.getNextIntervalTime(time, NTimeSpan.Zero);
                    }
                } else {
                    time = scalestart;
                    while (time.compareTo(serend) <= 0) {
                        if (!closedintervals.contains(time)) {
                            this.mTimePoints.add(time);
                            ++npoints;
                        } else {
                            bar = ser.getNearestTo(time);
                            if (bar != null && bar.getTime().equals(time)) {
                                this.mTimePoints.add(time);
                                ++npoints;
                            }
                        }
                        time = this.mBarInterval.getNextIntervalTime(time, NTimeSpan.Zero);
                    }
                }
                npoints = 0;
                if (serend.compareTo(scaleend) >= 0) {
                    time = scaleend;
                    while (time.compareTo(serend) <= 0) {
                        if (!closedintervals.contains(time)) {
                            this.mTimePoints.add(time);
                            ++npoints;
                        }
                        time = this.mBarInterval.getNextIntervalTime(time, NTimeSpan.Zero);
                    }
                }
                if (!initpoint.equals(NDateTime.MinValue) && (bar = ser.getNearestTo(initpoint)) != null && !bar.getTime().equals(initpoint)) {
                    this.mTimePoints.remove(initpoint);
                }
            }
            NDateTime lastbartime = NDateTime.MinValue;
            for (BarDataSeries ser : series) {
                IBarDataPoint basebar = (IBarDataPoint)ser.getExData("BaseDataPoint");
                if (basebar == null) continue;
                lastbartime = basebar.getTime().compareTo(lastbartime) > 0 ? basebar.getTime() : lastbartime;
            }
            if (lastbartime.equals(NDateTime.MinValue)) {
                lastbartime = this.mDataTimeRange.end();
            }
            if (autoscroll) {
                if (lastbartime.equals(NDateTime.MinValue)) {
                    lastbartime = this.mDataTimeRange.end();
                }
                float f = this.getTimePosition(this.mLastBarTime);
                float newlastbarpos = this.getTimePosition(lastbartime);
                this.mScrollOffset += -f + newlastbarpos;
            }
            this.mLastBarTime = series.size() > 0 ? lastbartime : NDateTime.MaxValue;
            if (reset) {
                this.scrollToEnd();
            } else {
                this.commitScroll(false);
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "setToBarDataSeries(), Error.", ex);
        }
    }

    private List<Range<NDateTime>> getMarketClosedPeriods(DataSeries<MarketModeDataPoint> modes) {
        ArrayList<Range<NDateTime>> closedPeriods = new ArrayList<Range<NDateTime>>();
        MarketMode currmode = MarketMode.Open;
        NDateTime closedtime = NDateTime.MinValue;
        for (MarketModeDataPoint mode : modes) {
            if (mode.Mode == MarketMode.Undefined) continue;
            if (mode.Mode != MarketMode.Open && currmode == MarketMode.Open) {
                closedtime = mode.Time;
            } else if (mode.Mode == MarketMode.Open && currmode != MarketMode.Open) {
                closedPeriods.add(Range.of(closedtime, mode.Time));
            }
            currmode = mode.Mode;
        }
        return closedPeriods;
    }

    public Range<NDateTime> getPlotTimeRange() {
        return this.getPlotTimeRange(0);
    }

    public Range<NDateTime> getPlotTimeRange(int offset) {
        if (this.mPlotRange.isEmpty()) {
            return Range.empty();
        }
        float plotintvls = (this.mPlotRange.end().floatValue() - this.mPlotRange.start().floatValue()) / this.getIntervalSize();
        float endidx = this.getTimeIndex(this.mScrollTime) - this.mScrollOffset / this.getIntervalSize() + (float)offset;
        NDateTime endtime = this.getIndexTime(endidx);
        float startidx = endidx + plotintvls + (float)offset;
        NDateTime starttime = this.getIndexTime(startidx);
        Range<NDateTime> plottimerange = new Range<NDateTime>(starttime, endtime);
        return plottimerange;
    }

    public float getTimeIndex(NDateTime time) {
        Range<Integer> indexRange = this.mTimePoints.boundingIndexOf(time);
        float idx = 0.0f;
        if (indexRange.isEmpty()) {
            idx = 0.0f;
        } else if (indexRange.start().equals(Integer.MIN_VALUE)) {
            idx = this.mBarInterval.intervalsBetweenF(time, this.mTimePoints.first(), this.mAvgInterval);
        } else if (indexRange.end().equals(Integer.MAX_VALUE)) {
            idx = (float)this.mTimePoints.size() + this.mBarInterval.intervalsBetweenF(time, this.mTimePoints.last(), this.mAvgInterval) - 1.0f;
        } else if (indexRange.start().equals(indexRange.end())) {
            idx = indexRange.start().intValue();
        } else {
            NDateTime dt1 = this.mTimePoints.get(indexRange.start());
            NDateTime dt2 = this.mTimePoints.get(indexRange.end());
            float d = (float)(((double)dt2.getTicks() - (double)time.getTicks()) / ((double)dt2.getTicks() - (double)dt1.getTicks()));
            idx = (float)indexRange.end().intValue() - d;
        }
        return idx;
    }

    public NDateTime getIndexTime(float index) {
        if (index < 0.0f) {
            NDateTime idxtime = this.mBarInterval.addIntervals(this.mTimePoints.first(), index * -1.0f, this.mAvgInterval);
            return idxtime;
        }
        if (index >= (float)(this.mTimePoints.size() - 1)) {
            NDateTime idxtime = this.mBarInterval.addIntervals(this.mTimePoints.last(), (index - (float)this.mTimePoints.size() + 1.0f) * -1.0f, this.mAvgInterval);
            return idxtime;
        }
        if (index % 1.0f == 0.0f) {
            return this.mTimePoints.get((int)index);
        }
        NDateTime t2 = this.mTimePoints.get((int)Math.floor(index));
        NDateTime t1 = this.mTimePoints.get((int)Math.ceil(index));
        double diffMillis = t2.getTicks() - t1.getTicks();
        double frac = index - (float)((int)index);
        NDateTime fracTime = t2.AddTicks(-((long)(diffMillis * frac)));
        return fracTime;
    }

    public float getTimePosition(NDateTime time) {
        float scrolltimeidx = this.getTimeIndex(this.mScrollTime);
        float timeidx = this.getTimeIndex(time);
        float deltaidx = timeidx - scrolltimeidx;
        float pos = this.mPlotRange.end().floatValue() - deltaidx * this.getIntervalSize();
        return pos - this.mScrollOffset;
    }

    public NDateTime getPositionTime(float pos, boolean snapToNearest) {
        float scrollpos = this.getTimePosition(this.mScrollTime);
        float deltapos = (pos - scrollpos) / this.getIntervalSize();
        float scrollidx = this.getTimeIndex(this.mScrollTime);
        float posidx = scrollidx - deltapos;
        if (snapToNearest) {
            posidx = Math.round(posidx);
        }
        NDateTime time = this.getIndexTime(posidx);
        return time;
    }

    public void scrollBy(float amount) {
        this.mScrollOffset += amount;
    }

    private void setDefaultScale() {
        this.setDefaultScale(NDateTime.now());
    }

    private void setDefaultScale(NDateTime currtime) {
        this.mTimePoints.clear();
        this.mLastBarTime = NDateTime.MaxValue;
        this.mDataTimeRange = Range.empty();
        this.mScrollTime = this.mBarInterval.roundToNearestInterval(currtime, this.mAvgInterval);
        this.mLastBarTime = NDateTime.MaxValue;
        this.mScrollOffset = !this.mPlotRange.isEmpty() ? (this.mPlotRange.end().floatValue() - this.mPlotRange.start().floatValue()) * (float)this.mConfig.DefaultScaleMargin / 100.0f : 0.0f;
        this.mTimePoints.add(this.mScrollTime);
        this.commitScroll();
    }

    private void commitScroll() {
        this.commitScroll(true);
    }

    private void commitScroll(boolean expand) {
        if (this.mPlotRange.isEmpty()) {
            return;
        }
        this.mScrollTime = this.getPositionTime(this.mPlotRange.end().floatValue(), false);
        this.mScrollOffset = 0.0f;
        this.onScaleExpanded();
    }

    private void onScaleExpanded() {
        Range<NDateTime> plotRange = this.getPlotTimeRange();
        for (IScaleScrollHandler hnd : this.mScrollHandlers) {
            hnd.onScroll(this, plotRange);
        }
    }

    public static class TimeScaleConfig
    extends Configurable {
        @PropertyConfig(idx=0, name="chart_time_scale_default_margin_name", description="chart_time_scale_default_margin_descr")
        @NumberFormatF(minValue=0.0f, maxValue=50.0f, increment=5.0f, displayDecimals=0)
        @DefaultValue(value="0")
        public int DefaultScaleMargin = 0;

        @Override
        public String configID() {
            return "TimeScale$TimeScaleConfig";
        }

        @Override
        public String configurableName() {
            return Resource.localizeString("chart_time_scale");
        }
    }

    public static enum TimeScaleBreakMethod {
        OpenMarket(0),
        ContinuousScale(1),
        BreakAllGaps(2);

        private final int value;
        private static Map<Integer, TimeScaleBreakMethod> map;

        private TimeScaleBreakMethod(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static TimeScaleBreakMethod get(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, TimeScaleBreakMethod>();
            for (TimeScaleBreakMethod t : TimeScaleBreakMethod.values()) {
                map.put(t.getValue(), t);
            }
        }
    }

    public static interface IScaleScrollHandler {
        public void onScroll(TimeScale var1, Range<NDateTime> var2);
    }
}

