/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.scales;

import com.t4login.application.chart.markets.IChartMarket;
import com.t4login.application.chart.scales.IValueScale;
import com.t4login.util.Range;

public class ChartPriceScale
implements IValueScale {
    private static final String TAG = "ChartPriceScale";
    private final IChartMarket mMarket;
    private double mCenterPrice = 0.0;
    private float mCenterPosition = 0.0f;
    private float mScrollOffset = 0.0f;
    private float mZoomLevel = 1.0f;
    private float mIntervalSize = 1.0f;
    private double mLabelPrice;
    private Range<Float> mPlotRange = Range.empty();
    private float mPlotRangeMarginTop = 0.0f;
    private float mPlotRangeMarginBottom = 0.0f;
    private int mIntervalMultiplier = 1;
    private int mScaleMargin = 25;

    public ChartPriceScale(IChartMarket market) {
        this.mMarket = market;
    }

    public IChartMarket getMarket() {
        return this.mMarket;
    }

    public void setScaleMultiplier(int mult) {
        this.mIntervalMultiplier = mult;
    }

    public double getIntervalValue() {
        return this.mMarket.getMinPriceIncrement().getDoubleValue() * (double)this.mIntervalMultiplier;
    }

    public float getIntervalSize() {
        return this.mIntervalSize * this.mZoomLevel;
    }

    public void setScaleMargin(int value) {
        this.mScaleMargin = value;
    }

    public int getScaleMargin() {
        return this.mScaleMargin;
    }

    public void scrollScale(float amount) {
        double pricedelta = (double)(amount / this.getIntervalSize()) * this.getIntervalValue();
        this.mCenterPrice += pricedelta;
        this.mScrollOffset = 0.0f;
    }

    public void zoomScale(float amount, float anchor) {
        float maxIntvlSz = (this.mPlotRange.end().floatValue() - this.mPlotRange.start().floatValue()) / 4.0f;
        float minIntvlSz = 0.01f;
        double anchorPrice = this.getPositionValue(anchor, false);
        this.mIntervalSize = Math.max(minIntvlSz, Math.min(maxIntvlSz, this.mIntervalSize * amount));
        float anchorPricePos = this.getValuePosition(anchorPrice);
        this.scrollScale(anchor - anchorPricePos);
    }

    public void centerOnValue(Range<Double> centerRange, double offset) {
        if (!centerRange.isEmpty()) {
            double centerval = (centerRange.start() + centerRange.end()) / 2.0;
            this.mCenterPrice = centerval + offset * (centerRange.end() - centerRange.start());
        }
    }

    @Override
    public void setPlotRange(Range<Float> plotRange) {
        this.mPlotRange = plotRange;
        this.mCenterPosition = this.mPlotRange.start().floatValue() + (this.mPlotRange.end().floatValue() - this.mPlotRange.start().floatValue()) / 2.0f;
    }

    @Override
    public Range<Float> getPlotRange() {
        return this.mPlotRange;
    }

    @Override
    public void setPlotRangeMarginTop(float margin) {
        this.mPlotRangeMarginTop = margin;
    }

    @Override
    public float getPlotRangeMarginTop() {
        return this.mPlotRangeMarginTop;
    }

    @Override
    public void setPlotRangeMarginBottom(float margin) {
        this.mPlotRangeMarginBottom = margin;
    }

    @Override
    public float getPlotRangeMarginBottom() {
        return this.mPlotRangeMarginBottom;
    }

    @Override
    public void setScaleValueRange(Range<Double> valueRange) {
        Range<Double> passedValueRange = valueRange;
        if (this.mPlotRange.isEmpty() || this.mPlotRange.end().floatValue() - this.mPlotRange.start().floatValue() <= 0.0f) {
            return;
        }
        if (valueRange.isEmpty()) {
            valueRange = Range.of(0.0, 100.0);
        } else if (valueRange.end().equals(valueRange.start())) {
            valueRange = Range.of(valueRange.start(), valueRange.start() + 1000.0);
        }
        this.mCenterPrice = valueRange.start() + (valueRange.end() - valueRange.start()) / 2.0;
        this.mScrollOffset = 0.0f;
        double pricedelta = valueRange.end() - valueRange.start();
        if (pricedelta == 0.0) {
            pricedelta = 20.0 * this.getIntervalValue();
        }
        double ydelta = (double)(this.mPlotRange.end().floatValue() - this.mPlotRange.start().floatValue()) * (100.0 - (double)this.mScaleMargin) / 100.0;
        double tickdelta = pricedelta / this.getIntervalValue();
        this.mIntervalSize = Math.max(0.01f, (float)(ydelta / tickdelta));
        this.mZoomLevel = 1.0f;
        this.mLabelPrice = this.getPositionValue(this.mCenterPosition, true);
    }

    @Override
    public float getValuePosition(double value) {
        double tickdelta = (this.mCenterPrice - value) / this.getIntervalValue();
        float valpos = (float)((double)(this.mCenterPosition + this.mScrollOffset) + tickdelta * (double)this.getIntervalSize());
        return valpos;
    }

    @Override
    public double getPositionValue(float pos, boolean snapToNearest) {
        float intvldelta = (this.mCenterPosition + this.mScrollOffset - pos) / this.getIntervalSize();
        double posval = this.mCenterPrice + (double)intvldelta * this.getIntervalValue();
        if (snapToNearest) {
            posval = (double)Math.round(posval / this.getIntervalValue()) * this.getIntervalValue();
        }
        return posval;
    }

    @Override
    public double roundToScale(double value) {
        return (double)Math.round(value / this.getIntervalValue()) * this.getIntervalValue();
    }
}

