/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.render;

import com.t4login.application.chart.render.ChartPaintContext;
import com.t4login.application.chart.render.IChartRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CompoundRenderer
implements IChartRenderer {
    private static final String TAG = "CompoundRenderer";
    private List<IChartRenderer> mRenderers = new ArrayList<IChartRenderer>();
    private boolean mHidden = false;

    public CompoundRenderer() {
    }

    public CompoundRenderer(Collection<IChartRenderer> renderers) {
        this.mRenderers.addAll(renderers);
    }

    public CompoundRenderer setHidden(boolean value) {
        this.mHidden = value;
        return this;
    }

    public void addRenderer(IChartRenderer renderer) {
        this.mRenderers.add(renderer);
    }

    public int count() {
        return this.mRenderers.size();
    }

    public IChartRenderer get(int i) {
        return this.mRenderers.get(i);
    }

    @Override
    public void paintToContext(ChartPaintContext context) {
        if (this.mHidden) {
            return;
        }
        for (IChartRenderer r : this.mRenderers) {
            r.paintToContext(context);
        }
    }
}

