/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.markets;

import com.t4login.Log;
import com.t4login.api.Contract;
import com.t4login.api.Market;
import com.t4login.api.T4HostService;
import com.t4login.api.chartdata.request.ActiveMarketRequest;
import com.t4login.api.chartdata.request.ChartDataRequestStatus;
import com.t4login.api.chartdata.request.MarketMapping;
import com.t4login.application.chart.markets.IChartMarket;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.VPT;
import com.t4login.messages.MsgContractDetails2;
import com.t4login.util.Range;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class VolumeContinuationMarket
implements IChartMarket {
    private static final String TAG = "VCMarket";
    private final Contract mContract;
    private Market mMarket = null;
    private List<IChartMarket.OnMarketReadyHandler> mReadyHandlers = new CopyOnWriteArrayList<IChartMarket.OnMarketReadyHandler>();
    private NDateTime mInitializeTradeDate = NDateTime.MinValue;

    public VolumeContinuationMarket(Contract contract) {
        this.mContract = contract;
    }

    @Override
    public String getExchangeID() {
        return this.mContract.getExchangeID();
    }

    @Override
    public String getContractID() {
        return this.mContract.getContractID();
    }

    @Override
    public String getMarketID() {
        return "VC{" + this.mContract.getExchangeID() + "." + this.mContract.getContractID() + "}";
    }

    @Override
    public boolean isContinuation() {
        return true;
    }

    @Override
    public Contract getAPIContract() {
        return this.mContract;
    }

    @Override
    public Market getAPIMarket() {
        return this.mMarket;
    }

    @Override
    public String getDescription() {
        return this.mContract.getDescription() + " (by Volume)";
    }

    @Override
    public String getContractDescription() {
        return this.mContract.getDescription();
    }

    @Override
    public String getExpiryDescription() {
        return "by Volume";
    }

    @Override
    public NDateTime getTradeDate(NDateTime time) {
        return this.mContract.getTradeDate(time);
    }

    @Override
    public synchronized void initialize(T4HostService service) {
        if (!this.mInitializeTradeDate.equals(NDateTime.MinValue)) {
            return;
        }
        if (service == null || service.getMarketData() == null) {
            return;
        }
        this.mInitializeTradeDate = this.mContract.getTradeDate(NDateTime.now());
        ActiveMarketRequest activeMarketRequest = new ActiveMarketRequest(this.mContract);
        activeMarketRequest.processesRequest(service, new ActiveMarketRequest.OnRequestCompleteHandler(){

            @Override
            public void onRequestComplete(ActiveMarketRequest request) {
                VolumeContinuationMarket.this.onActiveMarketRequestComplete(request);
            }
        });
    }

    @Override
    public synchronized boolean isReady(IChartMarket.OnMarketReadyHandler readyHandler) {
        if (this.mMarket == null) {
            if (readyHandler != null && !this.mReadyHandlers.contains(readyHandler)) {
                this.mReadyHandlers.add(readyHandler);
            }
            return false;
        }
        return true;
    }

    @Override
    public List<MarketMapping> createChartDataMarketMapping(Range<NDateTime> dateRange) {
        ArrayList<MarketMapping> mapping = new ArrayList<MarketMapping>();
        mapping.add(new MarketMapping(this.mMarket.getExchangeID(), this.mMarket.getContractID(), "", dateRange));
        if (this.mContract.Msg.ContractType.equals(ContractType.Future)) {
            NDateTime tmpDate = NDateTime.MaxValue;
            for (MsgContractDetails2.Relation r : this.mContract.Msg.Relations) {
                NDateTime relationStartDate = r.startDate;
                NDateTime relationEndDate = r.endDate;
                if (this.mContract.Msg.ContractType != r.contractType || !relationEndDate.isBefore(tmpDate) || r.priority >= 5 || !dateRange.contains(relationStartDate) && !dateRange.contains(relationEndDate)) continue;
                mapping.add(new MarketMapping(r.exchangeID, r.contractID, "", Range.of(relationStartDate, relationEndDate)));
            }
        }
        return mapping;
    }

    @Override
    public int getDenominator() {
        if (this.mMarket == null) {
            return 1;
        }
        return this.mMarket.getDenominator();
    }

    @Override
    public String getPriceCode() {
        if (this.mMarket != null) {
            return this.mMarket.getPriceCode();
        }
        return "";
    }

    @Override
    public Price getMinPriceIncrement() {
        if (this.mMarket != null) {
            return this.mMarket.getMinPriceIncrement();
        }
        return Price.of(1);
    }

    @Override
    public VPT getVPT() {
        if (this.mMarket != null) {
            return this.mMarket.getVPT();
        }
        return null;
    }

    @Override
    public Price getMinCabPrice() {
        if (this.mMarket != null) {
            return this.mMarket.getMinCabPrice();
        }
        return null;
    }

    @Override
    public int getRealDecimals() {
        if (this.mMarket != null) {
            return this.mMarket.getRealDecimals();
        }
        return 0;
    }

    @Override
    public int getClearingDecimals() {
        if (this.mMarket != null) {
            return this.mMarket.getClearingDecimals();
        }
        return 0;
    }

    @Override
    public BigDecimal getPointValue() {
        if (this.mMarket != null) {
            return this.mMarket.getPointValue();
        }
        return BigDecimal.ONE;
    }

    @Override
    public Integer getYieldYears() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldYears();
        }
        return 0;
    }

    @Override
    public Double getYieldParValue() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldParValue();
        }
        return 0.0;
    }

    @Override
    public Double getYieldRate() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldRate();
        }
        return 0.0;
    }

    @Override
    public Integer getYieldValueDenominator() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldValueDenominator();
        }
        return 0;
    }

    @Override
    public Double getYieldRedemption() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldRedemption();
        }
        return 0.0;
    }

    @Override
    public Double getYieldPaymentsPerYear() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldPaymentsPerYear();
        }
        return 0.0;
    }

    @Override
    public Integer getYieldBasis() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldBasis();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof VolumeContinuationMarket) {
            VolumeContinuationMarket that = (VolumeContinuationMarket)o;
            return this.mContract.equals(that.mContract);
        }
        return false;
    }

    public int hashCode() {
        return this.mContract.hashCode();
    }

    public String toString() {
        if (this.mMarket != null) {
            return String.format("[%s.%s]/%s (by Volume)", this.mContract.getExchangeID(), this.mContract.getContractID(), this.mMarket.getMarketID());
        }
        return String.format("[%s.%s] (by Volume)", this.mContract.getExchangeID(), this.mContract.getContractID());
    }

    private void onActiveMarketRequestComplete(ActiveMarketRequest request) {
        if (request.getStatus() == ChartDataRequestStatus.Complete) {
            Log.d(TAG, "onActiveMarketRequestComplete(), MarketID: " + request.getActiveMarketID());
            this.mMarket = request.getActiveMarket();
            for (IChartMarket.OnMarketReadyHandler h : this.mReadyHandlers) {
                try {
                    h.onMarketReady(this);
                }
                catch (Exception ex) {
                    Log.e(TAG, "onActiveMarketRequestComplete(), OnMarketReadyHandler raised an unhandled exception.", ex);
                }
            }
        } else {
            Log.e(TAG, "onActiveMarketRequestComplete(), Request failed. Status: " + String.valueOf((Object)request.getStatus()));
        }
    }
}

