/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.markets;

import com.t4login.api.Contract;
import com.t4login.api.Market;
import com.t4login.api.T4HostService;
import com.t4login.api.chartdata.request.MarketMapping;
import com.t4login.application.chart.markets.IChartMarket;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.VPT;
import com.t4login.util.Range;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ExpiryMarket
implements IChartMarket {
    public static final ExpiryMarket Empty = new ExpiryMarket(null);
    private Market mMarket = Market.Empty;

    public ExpiryMarket(Market market) {
        if (market == null) {
            market = Market.Empty;
        }
        this.mMarket = market;
    }

    @Override
    public String getExchangeID() {
        return this.mMarket.getExchangeID();
    }

    @Override
    public String getContractID() {
        return this.mMarket.getContractID();
    }

    @Override
    public String getMarketID() {
        return this.mMarket.getMarketID();
    }

    @Override
    public boolean isContinuation() {
        return false;
    }

    @Override
    public Contract getAPIContract() {
        return this.mMarket.Contract;
    }

    @Override
    public Market getAPIMarket() {
        return this.mMarket;
    }

    @Override
    public String getDescription() {
        return this.mMarket.getDescription();
    }

    @Override
    public String getContractDescription() {
        return this.mMarket.Contract.getDescription();
    }

    @Override
    public String getExpiryDescription() {
        return this.mMarket.getExpiryDescription();
    }

    @Override
    public NDateTime getTradeDate(NDateTime time) {
        return this.mMarket.Contract.getTradeDate(time);
    }

    @Override
    public void initialize(T4HostService service) {
    }

    @Override
    public boolean isReady(IChartMarket.OnMarketReadyHandler readyHandler) {
        return this.mMarket != null;
    }

    @Override
    public List<MarketMapping> createChartDataMarketMapping(Range<NDateTime> dateRange) {
        ArrayList<MarketMapping> mapping = new ArrayList<MarketMapping>();
        mapping.add(new MarketMapping(this.mMarket.getExchangeID(), this.mMarket.getContractID(), this.mMarket.getMarketID(), dateRange));
        return mapping;
    }

    @Override
    public int getDenominator() {
        if (this.mMarket == null) {
            return 1;
        }
        return this.mMarket.getDenominator();
    }

    @Override
    public String getPriceCode() {
        if (this.mMarket != null) {
            return this.mMarket.getPriceCode();
        }
        return "";
    }

    @Override
    public Price getMinPriceIncrement() {
        if (this.mMarket != null) {
            return this.mMarket.getMinPriceIncrement();
        }
        return Price.of(1);
    }

    @Override
    public VPT getVPT() {
        if (this.mMarket != null) {
            return this.mMarket.getVPT();
        }
        return null;
    }

    @Override
    public Price getMinCabPrice() {
        if (this.mMarket != null) {
            return this.mMarket.getMinCabPrice();
        }
        return null;
    }

    @Override
    public int getRealDecimals() {
        if (this.mMarket != null) {
            return this.mMarket.getRealDecimals();
        }
        return 0;
    }

    @Override
    public int getClearingDecimals() {
        if (this.mMarket != null) {
            return this.mMarket.getClearingDecimals();
        }
        return 0;
    }

    @Override
    public BigDecimal getPointValue() {
        if (this.mMarket != null) {
            return this.mMarket.getPointValue();
        }
        return BigDecimal.ONE;
    }

    @Override
    public Integer getYieldYears() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldYears();
        }
        return 0;
    }

    @Override
    public Double getYieldParValue() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldParValue();
        }
        return 0.0;
    }

    @Override
    public Double getYieldRate() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldRate();
        }
        return 0.0;
    }

    @Override
    public Integer getYieldValueDenominator() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldValueDenominator();
        }
        return 0;
    }

    @Override
    public Double getYieldRedemption() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldRedemption();
        }
        return 0.0;
    }

    @Override
    public Double getYieldPaymentsPerYear() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldPaymentsPerYear();
        }
        return 0.0;
    }

    @Override
    public Integer getYieldBasis() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldBasis();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ExpiryMarket) {
            ExpiryMarket that = (ExpiryMarket)o;
            return this.mMarket.equals(that.mMarket);
        }
        return false;
    }

    public int hashCode() {
        return this.mMarket.hashCode();
    }

    public String toString() {
        return this.mMarket.getMarketID();
    }
}

