/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.markets;

import com.t4login.Log;
import com.t4login.api.Contract;
import com.t4login.api.Market;
import com.t4login.api.T4HostService;
import com.t4login.api.chartdata.request.ActiveMarketRequest;
import com.t4login.api.chartdata.request.ChartDataRequestStatus;
import com.t4login.api.chartdata.request.MarketMapping;
import com.t4login.application.chart.ContractMonth;
import com.t4login.application.chart.markets.IChartMarket;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.VPT;
import com.t4login.util.Range;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ExpiryContinuationMarket
implements IChartMarket {
    private static final String TAG = "ECMarket";
    private final Contract mContract;
    private final int mExpiryRolloverDays;
    private final int mExpiryForwardMonths;
    private final EnumSet<ContractMonth> mExpiryContractMonths;
    private Market mMarket = null;
    private List<IChartMarket.OnMarketReadyHandler> mReadyHandlers = new CopyOnWriteArrayList<IChartMarket.OnMarketReadyHandler>();
    private NDateTime mInitializeTradeDate = NDateTime.MinValue;

    public ExpiryContinuationMarket(Contract contract, int rollDays, int fwdMo, EnumSet<ContractMonth> months) {
        this.mContract = contract;
        this.mExpiryRolloverDays = rollDays;
        this.mExpiryForwardMonths = fwdMo;
        this.mExpiryContractMonths = months;
    }

    public int getExpiryRolloverDays() {
        return this.mExpiryRolloverDays;
    }

    public int getExpiryForwardMonths() {
        return this.mExpiryForwardMonths;
    }

    public EnumSet<ContractMonth> getExpiryContractMonths() {
        return this.mExpiryContractMonths;
    }

    @Override
    public String getExchangeID() {
        return this.mContract.getExchangeID();
    }

    @Override
    public String getContractID() {
        return this.mContract.getContractID();
    }

    @Override
    public String getMarketID() {
        return "EC{" + this.mContract.getExchangeID() + "." + this.mContract.getContractID() + "}";
    }

    @Override
    public boolean isContinuation() {
        return true;
    }

    @Override
    public Contract getAPIContract() {
        return this.mContract;
    }

    @Override
    public Market getAPIMarket() {
        return this.mMarket;
    }

    @Override
    public String getDescription() {
        return this.mContract.getDescription() + " (by Expiry)";
    }

    @Override
    public String getContractDescription() {
        return this.mContract.getDescription() + "(" + this.mContract.getContractID() + ")";
    }

    @Override
    public String getExpiryDescription() {
        return "by Expiry";
    }

    @Override
    public NDateTime getTradeDate(NDateTime time) {
        return this.mContract.getTradeDate(time);
    }

    @Override
    public synchronized void initialize(final T4HostService service) {
        if (!this.mInitializeTradeDate.equals(NDateTime.MinValue)) {
            return;
        }
        if (service == null || service.getMarketData() == null) {
            return;
        }
        this.mInitializeTradeDate = this.mContract.getTradeDate(NDateTime.now());
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ExpiryContinuationMarket.this.beginInitialize(service);
            }
        });
        t.start();
    }

    @Override
    public synchronized boolean isReady(IChartMarket.OnMarketReadyHandler readyHandler) {
        if (this.mMarket == null) {
            if (readyHandler != null && !this.mReadyHandlers.contains(readyHandler)) {
                this.mReadyHandlers.add(readyHandler);
            }
            return false;
        }
        return true;
    }

    @Override
    public List<MarketMapping> createChartDataMarketMapping(Range<NDateTime> dateRange) {
        ArrayList<MarketMapping> mapping = new ArrayList<MarketMapping>();
        return mapping;
    }

    @Override
    public int getDenominator() {
        if (this.mMarket == null) {
            return 1;
        }
        return this.mMarket.getDenominator();
    }

    @Override
    public String getPriceCode() {
        if (this.mMarket != null) {
            return this.mMarket.getPriceCode();
        }
        return "";
    }

    @Override
    public Price getMinPriceIncrement() {
        if (this.mMarket != null) {
            return this.mMarket.getMinPriceIncrement();
        }
        return Price.of(1);
    }

    @Override
    public VPT getVPT() {
        if (this.mMarket != null) {
            return this.mMarket.getVPT();
        }
        return null;
    }

    @Override
    public Price getMinCabPrice() {
        if (this.mMarket != null) {
            return this.mMarket.getMinCabPrice();
        }
        return null;
    }

    @Override
    public int getRealDecimals() {
        if (this.mMarket != null) {
            return this.mMarket.getRealDecimals();
        }
        return 0;
    }

    @Override
    public int getClearingDecimals() {
        if (this.mMarket != null) {
            return this.mMarket.getClearingDecimals();
        }
        return 0;
    }

    @Override
    public BigDecimal getPointValue() {
        if (this.mMarket != null) {
            return this.mMarket.getPointValue();
        }
        return BigDecimal.ONE;
    }

    @Override
    public Integer getYieldYears() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldYears();
        }
        return 0;
    }

    @Override
    public Double getYieldParValue() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldParValue();
        }
        return 0.0;
    }

    @Override
    public Double getYieldRate() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldRate();
        }
        return 0.0;
    }

    @Override
    public Integer getYieldValueDenominator() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldValueDenominator();
        }
        return 0;
    }

    @Override
    public Double getYieldRedemption() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldRedemption();
        }
        return 0.0;
    }

    @Override
    public Double getYieldPaymentsPerYear() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldPaymentsPerYear();
        }
        return 0.0;
    }

    @Override
    public Integer getYieldBasis() {
        if (this.mMarket != null) {
            return this.mMarket.getYieldBasis();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ExpiryContinuationMarket) {
            ExpiryContinuationMarket that = (ExpiryContinuationMarket)o;
            if (this.mExpiryRolloverDays != that.mExpiryRolloverDays) {
                return false;
            }
            if (this.mExpiryForwardMonths != that.mExpiryForwardMonths) {
                return false;
            }
            if (!this.mContract.equals(that.mContract)) {
                return false;
            }
            return this.mExpiryContractMonths.equals(that.mExpiryContractMonths);
        }
        return false;
    }

    public int hashCode() {
        int result = this.mContract.hashCode();
        result = 31 * result + this.mExpiryRolloverDays;
        result = 31 * result + this.mExpiryForwardMonths;
        result = 31 * result + this.mExpiryContractMonths.hashCode();
        return result;
    }

    public String toString() {
        if (this.mMarket != null) {
            return String.format("[%s.%s]/%s (by Expiry)", this.mContract.getExchangeID(), this.mContract.getContractID(), this.mMarket.getMarketID());
        }
        return String.format("[%s.%s] (by Expiry)", this.mContract.getExchangeID(), this.mContract.getContractID());
    }

    private void beginInitialize(T4HostService service) {
    }

    private void onActiveMarketRequestComplete(ActiveMarketRequest request) {
        if (request.getStatus() == ChartDataRequestStatus.Complete) {
            Log.d(TAG, "onActiveMarketRequestComplete(), MarketID: " + request.getActiveMarketID());
            this.mMarket = request.getActiveMarket();
            for (IChartMarket.OnMarketReadyHandler h : this.mReadyHandlers) {
                try {
                    h.onMarketReady(this);
                }
                catch (Exception ex) {
                    Log.e(TAG, "onActiveMarketRequestComplete(), OnMarketReadyHandler raised an unhandled exception.", ex);
                }
            }
        } else {
            Log.e(TAG, "onActiveMarketRequestComplete(), Request failed. Status: " + String.valueOf((Object)request.getStatus()));
        }
    }
}

