/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata.dataprovider.specialized;

import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataProvider;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.datetime.NDateTime;
import com.t4login.util.Range;
import com.t4login.util.RangeType;
import java.util.Iterator;

public class BandDataSourceWrapper
implements IDataSource<IDataPointValue>,
IDataProvider {
    private IDataSource mSource;
    DataField mBaseField;
    DataField mBandField;
    double mFixedDist = 0.0;
    double mMultiplier;
    boolean mIsTickPrice;
    private DataDefinition mDataDef = null;

    public BandDataSourceWrapper(IDataSource src, DataField basefield, DataField bandfield, double multiplier, boolean istickprice) {
        this.mSource = src;
        this.mBaseField = basefield;
        this.mBandField = bandfield;
        this.mMultiplier = multiplier;
        this.mIsTickPrice = istickprice;
    }

    public BandDataSourceWrapper(IDataSource src, DataField basefield, double fixeddist, boolean istickprice) {
        this.mSource = src;
        this.mBaseField = basefield;
        this.mBandField = null;
        this.mFixedDist = fixeddist;
        this.mMultiplier = 0.0;
        this.mIsTickPrice = istickprice;
    }

    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        if (timeRange.isEmpty()) {
            return Range.empty();
        }
        Range<Double> valueRange = Range.empty();
        Iterator baseIt = this.mSource.getPointsBetween(timeRange, RangeType.Enclosed).iterator();
        while (baseIt.hasNext()) {
            BandValue bandval = this.getBandValue((IDataPoint)baseIt.next());
            valueRange = valueRange.expanded(bandval.TopValue);
            valueRange = valueRange.expanded(bandval.BottomValue);
        }
        return valueRange;
    }

    private BandValue getBandValue(IDataPoint dp) {
        if (dp != null) {
            if (this.mBandField != null) {
                double baseval = this.mBaseField.getDataPointValue(dp);
                double bandval = this.mBandField.getDataPointValue(dp);
                BandValue val = new BandValue(dp.getTime(), baseval, baseval + this.mMultiplier * bandval, baseval - this.mMultiplier * bandval);
                return val;
            }
            double baseval = this.mBaseField.getDataPointValue(dp);
            BandValue val = new BandValue(dp.getTime(), baseval, baseval + this.mFixedDist, baseval - this.mFixedDist);
            return val;
        }
        return null;
    }

    @Override
    public int getCount() {
        return this.mSource.getCount();
    }

    @Override
    public IDataPointValue get(int i) {
        return this.getBandValue((IDataPoint)this.mSource.get(i));
    }

    @Override
    public IDataPointValue get(NDateTime dt) {
        return this.getBandValue((IDataPoint)this.mSource.get(dt));
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        return this.mSource.getTimeRange();
    }

    @Override
    public IDataPointValue getFirst() {
        return this.getBandValue((IDataPoint)this.mSource.getFirst());
    }

    @Override
    public IDataPointValue getLast() {
        return this.getBandValue((IDataPoint)this.mSource.getLast());
    }

    @Override
    public IDataPointValue getNext(NDateTime dt) {
        return this.getBandValue((IDataPoint)this.mSource.getNext(dt));
    }

    @Override
    public IDataPointValue getPreceeding(NDateTime dt) {
        return this.getBandValue((IDataPoint)this.mSource.getPreceeding(dt));
    }

    @Override
    public IDataPointValue getNearestTo(NDateTime dt) {
        return this.getBandValue((IDataPoint)this.mSource.getNearestTo(dt));
    }

    @Override
    public IDataPointValue getNearestGreater(NDateTime dt) {
        return this.getBandValue((IDataPoint)this.mSource.getNearestGreater(dt));
    }

    @Override
    public IDataPointValue getNearestSmaller(NDateTime dt) {
        return this.getBandValue((IDataPoint)this.mSource.getNearestSmaller(dt));
    }

    @Override
    public Iterable<IDataPointValue> getPointsBetween(final Range<NDateTime> range, final RangeType rangeType) {
        return new Iterable<IDataPointValue>(){
            Iterator<IDataPointValue> baseIt;
            {
                this.baseIt = BandDataSourceWrapper.this.mSource.getPointsBetween(range, rangeType).iterator();
            }

            @Override
            public Iterator<IDataPointValue> iterator() {
                return new Iterator<IDataPointValue>(){

                    @Override
                    public boolean hasNext() {
                        return baseIt.hasNext();
                    }

                    @Override
                    public IDataPointValue next() {
                        return BandDataSourceWrapper.this.getBandValue(baseIt.next());
                    }

                    @Override
                    public void remove() {
                        baseIt.remove();
                    }
                };
            }
        };
    }

    @Override
    public Iterator<IDataPointValue> iterator() {
        Iterator<IDataPointValue> it = new Iterator<IDataPointValue>(){
            Iterator<IDataPointValue> baseIt;
            {
                this.baseIt = BandDataSourceWrapper.this.mSource.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.baseIt.hasNext();
            }

            @Override
            public IDataPointValue next() {
                return BandDataSourceWrapper.this.getBandValue(this.baseIt.next());
            }

            @Override
            public void remove() {
                this.baseIt.remove();
            }
        };
        return it;
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDataDef == null) {
            this.mDataDef = new DataDefinition("$Band");
            this.mDataDef.addField(new DataField("TOP", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof BandValue) {
                        BandValue banddp = (BandValue)dp;
                        return banddp.TopValue;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    return BandDataSourceWrapper.this.mBaseField.getFormattedValue(value);
                }
            }, false, true));
            this.mDataDef.addField(new DataField("BOTTOM", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof BandValue) {
                        BandValue banddp = (BandValue)dp;
                        return banddp.BottomValue;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    return BandDataSourceWrapper.this.mBaseField.getFormattedValue(value);
                }
            }, false, true));
            this.mDataDef.addField(new DataField("BASE", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof BandValue) {
                        BandValue banddp = (BandValue)dp;
                        return banddp.BaseValue;
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    return BandDataSourceWrapper.this.mBaseField.getFormattedValue(value);
                }
            }, false, true));
        }
        return this.mDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this;
    }

    public static class BandValue
    implements IDataPointValue {
        public final NDateTime Time;
        public final double BaseValue;
        public final double TopValue;
        public final double BottomValue;

        public BandValue(NDateTime time, double baseVal, double top, double bottom) {
            this.Time = time;
            this.BaseValue = baseVal;
            this.TopValue = top;
            this.BottomValue = bottom;
        }

        @Override
        public NDateTime getTime() {
            return this.Time;
        }

        @Override
        public double getValue() {
            return this.TopValue;
        }
    }
}

