/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata.dataprovider;

import com.t4login.api.T4HostService;
import com.t4login.api.chartdata.ChartData;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataLoadArgs;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IBarDataProvider;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.datetime.NDateTime;

public class T4BarDataProvider
implements IBarDataProvider {
    private final DataLoadArgs mDataLoadArgs;
    private final T4HostService mService;

    public T4BarDataProvider(T4HostService service, DataLoadArgs args) {
        this.mDataLoadArgs = args;
        this.mService = service;
    }

    @Override
    public DataLoadArgs args() {
        return this.mDataLoadArgs;
    }

    @Override
    public BarDataSeries getBarData() {
        BarDataSeries series = this.mService.getChartData().getBarDataSeries(this.mDataLoadArgs);
        return series;
    }

    @Override
    public void loadData(NDateTime tradeDate) {
        ChartData cd;
        if (this.mService != null && (cd = this.mService.getChartData()) != null) {
            cd.loadBarData(this.mDataLoadArgs, tradeDate);
        }
    }

    @Override
    public void loadNextTradeDate() {
        ChartData cd;
        if (this.mService != null && (cd = this.mService.getChartData()) != null) {
            cd.loadNextTradeDate(this.mDataLoadArgs);
        }
    }

    @Override
    public boolean isLoading() {
        ChartData cd;
        if (this.mService != null && (cd = this.mService.getChartData()) != null) {
            return cd.isLoading(this.mDataLoadArgs);
        }
        return false;
    }

    @Override
    public DataDefinition getDataDefinition() {
        return this.getBarData().getDataDefinition();
    }

    @Override
    public IDataSource getDataSource() {
        return this.getBarData();
    }

    @Override
    public IBarDataProvider getCustomized(DataLoadArgs args) {
        return new T4BarDataProvider(this.mService, args);
    }
}

