/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata.dataprovider;

import com.t4login.api.Market;
import com.t4login.application.chart.chartdata.BarDataPointF;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataLoadArgs;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IBarDataProvider;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.markets.ExpiryMarket;
import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;
import com.t4login.definitions.priceconversion.Price;
import java.util.Random;

public class RandomizedBarDataProvider
implements IBarDataProvider {
    private final DataLoadArgs mDataLoadArgs;
    private BarDataSeries mBarData = null;

    public RandomizedBarDataProvider() {
        this(new DataLoadArgs.Builder().setMarket(new ExpiryMarket(Market.Empty)).createDataLoadArgs());
    }

    public RandomizedBarDataProvider(DataLoadArgs args) {
        this.mDataLoadArgs = args;
    }

    @Override
    public DataLoadArgs args() {
        return this.mDataLoadArgs;
    }

    @Override
    public BarDataSeries getBarData() {
        if (this.mBarData == null) {
            Random r = new Random();
            this.mBarData = new BarDataSeries(new DataLoadArgs.Builder().setMarket(this.mDataLoadArgs.Market).setBarInterval(this.mDataLoadArgs.Interval).createDataLoadArgs());
            NDateTime barTime = NDateTime.now().AddDays(-4.0);
            barTime = this.mDataLoadArgs.Interval.roundDownToInterval(barTime, NTimeSpan.Zero);
            double open = 1000.0;
            while (barTime.compareTo(NDateTime.now()) < 0) {
                int trds = r.nextInt(50);
                if (trds > 10) {
                    double high = open;
                    double low = open;
                    double close = open;
                    int trdsB = 0;
                    int trdsO = 0;
                    int volB = 0;
                    int volO = 0;
                    while (trdsB + trdsO < trds) {
                        double prcD;
                        int side = r.nextInt(100) % 2;
                        if (side == 0) {
                            ++trdsB;
                            volB += 1 + r.nextInt(50);
                            prcD = r.nextInt(3) - 1;
                            high = Math.max(high, close += prcD);
                            low = Math.min(low, close);
                            continue;
                        }
                        ++trdsO;
                        volO += 1 + r.nextInt(50);
                        prcD = r.nextInt(3) - 1;
                        high = Math.max(high, close += prcD);
                        low = Math.min(low, close);
                    }
                    BarDataPointF bar = new BarDataPointF(barTime, barTime, barTime, Price.of(open), Price.of(high), Price.of(low), Price.of(close), volB + volO, volB, volO, trds, trdsB, trdsO, false);
                    this.mBarData.AddDataPoint(bar);
                    open = close;
                }
                barTime = this.mDataLoadArgs.Interval.addIntervals(barTime, 1, NTimeSpan.Zero);
            }
        }
        return this.mBarData;
    }

    @Override
    public void loadData(NDateTime loadTime) {
    }

    @Override
    public void loadNextTradeDate() {
    }

    @Override
    public boolean isLoading() {
        return false;
    }

    @Override
    public DataDefinition getDataDefinition() {
        return this.mBarData.getDataDefinition();
    }

    @Override
    public IDataSource getDataSource() {
        return this.mBarData;
    }

    @Override
    public IBarDataProvider getCustomized(DataLoadArgs args) {
        return new RandomizedBarDataProvider(args);
    }
}

