/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata.dataprovider;

import com.t4login.api.Market;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataLoadArgs;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.IBarDataProvider;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.markets.ExpiryMarket;
import com.t4login.datetime.NDateTime;

public class EmptyBarDataProvider
implements IBarDataProvider {
    private final DataLoadArgs mDataLoadArgs;
    private final BarDataSeries mSeries;

    public EmptyBarDataProvider(DataLoadArgs args) {
        this.mDataLoadArgs = args;
        this.mSeries = new BarDataSeries(args);
    }

    public EmptyBarDataProvider() {
        this(new DataLoadArgs.Builder().setMarket(new ExpiryMarket(Market.Empty)).createDataLoadArgs());
    }

    public EmptyBarDataProvider(BarDataSeries ser) {
        this.mDataLoadArgs = ser.getArgs();
        this.mSeries = ser;
    }

    @Override
    public DataLoadArgs args() {
        return this.mDataLoadArgs;
    }

    @Override
    public BarDataSeries getBarData() {
        return this.mSeries;
    }

    @Override
    public void loadData(NDateTime loadTime) {
    }

    @Override
    public void loadNextTradeDate() {
    }

    @Override
    public boolean isLoading() {
        return false;
    }

    @Override
    public DataDefinition getDataDefinition() {
        return this.mSeries.getDataDefinition();
    }

    @Override
    public IDataSource getDataSource() {
        return this.mSeries;
    }

    @Override
    public IBarDataProvider getCustomized(DataLoadArgs args) {
        return new EmptyBarDataProvider();
    }
}

