/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata.dataprovider;

import com.t4login.application.chart.chartdata.IDataPoint;

public class DataField {
    private final String mName;
    private final DataFieldReader mFieldReader;
    private final DataFieldFormatter mFieldFormatter;
    private final boolean mIsPrimary;
    private final boolean mIsTickPrice;

    public DataField(String name, DataFieldReader rdr, DataFieldFormatter frmt, boolean isPrimary, boolean isTickPrice) {
        this.mName = name;
        this.mFieldReader = rdr;
        this.mFieldFormatter = frmt;
        this.mIsPrimary = isPrimary;
        this.mIsTickPrice = isTickPrice;
    }

    public String getName() {
        return this.mName;
    }

    public Double getDataPointValue(IDataPoint dp) {
        return this.mFieldReader.getFieldValue(dp);
    }

    public String getFormattedDataPointValue(IDataPoint dp) {
        return this.mFieldFormatter.getFormattedValue(this.mFieldReader.getFieldValue(dp));
    }

    public String getFormattedValue(double value) {
        return this.mFieldFormatter.getFormattedValue(value);
    }

    public boolean isPrimary() {
        return this.mIsPrimary;
    }

    public boolean isTickPrice() {
        return this.mIsTickPrice;
    }

    public static interface DataFieldReader {
        public Double getFieldValue(IDataPoint var1);
    }

    public static interface DataFieldFormatter {
        public String getFormattedValue(double var1);
    }
}

