/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata.dataprovider;

import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.util.TextUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataDefinition
implements Iterable<DataField> {
    private final String mName;
    private final List<DataField> mFields = new ArrayList<DataField>();
    private DataField mPrimaryField = null;
    private Map<String, DataField> mFieldsByName = new HashMap<String, DataField>();

    public DataDefinition(String name) {
        this.mName = name;
    }

    public void addField(DataField field) {
        if (field != null) {
            if (this.mFieldsByName.containsKey(field.getName())) {
                throw new IllegalArgumentException(String.format("[%s], A data field with name '%s' has already been added to this definition.", this.mName, field.getName()));
            }
            this.mFields.add(field);
            this.mFieldsByName.put(field.getName(), field);
            if (field.isPrimary() || this.mPrimaryField == null) {
                this.mPrimaryField = field;
            }
        }
    }

    public String getName() {
        return this.mName;
    }

    public DataField getPrimaryField() {
        return this.mPrimaryField;
    }

    public DataField getField(String fieldName) {
        return this.mFieldsByName.get(fieldName);
    }

    @Override
    public Iterator<DataField> iterator() {
        return this.mFields.iterator();
    }

    public String toString(IDataPoint dp) {
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        parts.add((CallSite)((Object)(this.mPrimaryField.getName() + ": " + this.mPrimaryField.getFormattedDataPointValue(dp))));
        for (DataField fld : this.mFields) {
            if (fld == this.mPrimaryField) continue;
            parts.add((CallSite)((Object)(fld.getName() + ": " + fld.getFormattedDataPointValue(dp))));
        }
        return TextUtils.join((CharSequence)", ", parts);
    }
}

