/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata.aggregators;

import com.t4login.application.chart.BarInterval;
import com.t4login.application.chart.ChartInterval;
import com.t4login.application.chart.SessionTimeRange;
import com.t4login.application.chart.chartdata.BarDataPoint;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.MarketModeDataPoint;
import com.t4login.application.chart.chartdata.SettlementDataPoint;
import com.t4login.application.chart.chartdata.aggregators.IAggregator;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BidOffer;
import com.t4login.definitions.priceconversion.Price;

public class VolumeAggregator
implements IAggregator {
    private final BarDataSeries mSeries;
    private final BarInterval mBarInterval;
    private final SessionTimeRange mSession;
    private IBarDataPoint mPreviousBar = null;

    public VolumeAggregator(BarDataSeries series) {
        this.mSeries = series;
        this.mBarInterval = this.mSeries.getArgs().Interval;
        this.mSession = this.mSeries.getArgs().Session;
    }

    @Override
    public void addTrade(NDateTime time, Price tradePrice, int volume, BidOffer side, NDateTime tradeDate, boolean isLive) {
        IBarDataPoint prevBar;
        int residualvolume = 0;
        int ticks = 1;
        if (!this.mSession.contains(time)) {
            return;
        }
        if (this.mPreviousBar == null && (prevBar = this.mSeries.getLast()) != null) {
            this.mPreviousBar = prevBar;
        }
        do {
            residualvolume = 0;
            if (this.mPreviousBar == null) {
                if (this.mBarInterval.Interval == ChartInterval.Volume && volume > this.mBarInterval.Period) {
                    residualvolume = volume - this.mBarInterval.Period;
                    volume = this.mBarInterval.Period;
                }
                this.mPreviousBar = BarDataPoint.CreateBar(tradeDate, time, time, tradePrice, tradePrice, tradePrice, tradePrice, volume, 0, 0, ticks, 0, 0, isLive);
                this.mSeries.AddDataPoint(this.mPreviousBar);
            } else {
                boolean mergewbar;
                boolean bl = mergewbar = this.mPreviousBar.getVolume() < this.mBarInterval.Period;
                if (time.isBefore(this.mPreviousBar.getTime())) {
                    time = this.mPreviousBar.getTime();
                }
                if (!mergewbar && time.equals(this.mPreviousBar.getTime())) {
                    time = time.AddMilliseconds(1.0);
                }
                if (mergewbar && this.mPreviousBar.getVolume() + volume > this.mBarInterval.Period) {
                    residualvolume = volume - (this.mBarInterval.Period - this.mPreviousBar.getVolume());
                    volume = this.mBarInterval.Period - this.mPreviousBar.getVolume();
                } else if (!mergewbar && volume > this.mBarInterval.Period) {
                    residualvolume = volume - this.mBarInterval.Period;
                    volume = this.mBarInterval.Period;
                }
                if (mergewbar) {
                    if (this.mPreviousBar != null && !this.mPreviousBar.isAggregable()) {
                        this.mPreviousBar = BarDataPoint.CreateAggregableBar(this.mPreviousBar);
                        this.mSeries.AddDataPoint(this.mPreviousBar);
                    }
                    this.mPreviousBar.setCloseTime(time);
                    this.mPreviousBar.setHigh(Math.max(this.mPreviousBar.getHigh(), tradePrice.getDoubleValue()));
                    this.mPreviousBar.setLow(Math.min(this.mPreviousBar.getLow(), tradePrice.getDoubleValue()));
                    this.mPreviousBar.setClose(tradePrice.getDoubleValue());
                    this.mPreviousBar.setVolume(this.mPreviousBar.getVolume() + volume);
                    this.mPreviousBar.setVolumeAtBid(this.mPreviousBar.getVolumeAtBid() + (side.equals(BidOffer.Bid) ? volume : 0));
                    this.mPreviousBar.setVolumeAtOffer(this.mPreviousBar.getVolumeAtOffer() + (side.equals(BidOffer.Offer) ? volume : 0));
                    this.mPreviousBar.setTradeCount(this.mPreviousBar.getTradeCount() + 1);
                    this.mPreviousBar.setTradesAtBid(this.mPreviousBar.getTradesAtBid() + (side.equals(BidOffer.Bid) ? 1 : 0));
                    this.mPreviousBar.setTradesAtOffer(this.mPreviousBar.getTradesAtOffer() + (side.equals(BidOffer.Offer) ? 1 : 0));
                    this.mPreviousBar.setIsLive(isLive);
                    this.mSeries.dataPointUpdated(this.mPreviousBar);
                } else {
                    if (this.mPreviousBar != null && this.mPreviousBar.isLive()) {
                        this.mPreviousBar.setIsLive(false);
                        this.mSeries.dataPointUpdated(this.mPreviousBar);
                    }
                    this.mPreviousBar = BarDataPoint.CreateBar(tradeDate, time, time, tradePrice, tradePrice, tradePrice, tradePrice, volume, 0, 0, ticks, 0, 0, isLive);
                    this.mSeries.AddDataPoint(this.mPreviousBar);
                }
            }
            if (residualvolume <= 0) continue;
            volume = residualvolume;
        } while (residualvolume > 0);
    }

    @Override
    public void addBar(NDateTime time, NDateTime closeTime, Price openPrice, Price highPrice, Price lowPrice, Price closePrice, int volume, int volumeAtBid, int volumeAtOffer, int tradeCount, int tradesAtBid, int tradesAtOffer, NDateTime tradeDate, boolean isLive) {
        this.addBar(time, closeTime, openPrice.getDoubleValue(), highPrice.getDoubleValue(), lowPrice.getDoubleValue(), closePrice.getDoubleValue(), volume, volumeAtBid, volumeAtOffer, tradeCount, tradesAtBid, tradesAtOffer, tradeDate, isLive);
    }

    @Override
    public void addBar(NDateTime time, NDateTime closeTime, double openPrice, double highPrice, double lowPrice, double closePrice, int volume, int bidVolume, int offerVolume, int tradeCount, int tradesAtBid, int tradesAtOffer, NDateTime tradeDate, boolean isLive) {
        IBarDataPoint prevBar;
        int residualvolume = 0;
        if (this.mPreviousBar == null && (prevBar = this.mSeries.getLast()) != null) {
            this.mPreviousBar = prevBar;
        }
        do {
            residualvolume = 0;
            if (this.mPreviousBar == null) {
                if (this.mBarInterval.Interval == ChartInterval.Volume && volume > this.mBarInterval.Period) {
                    residualvolume = volume - this.mBarInterval.Period;
                    volume = this.mBarInterval.Period;
                }
                this.mPreviousBar = BarDataPoint.CreateBar(tradeDate, time, closeTime, openPrice, highPrice, lowPrice, closePrice, volume, 0, 0, tradeCount, 0, 0, isLive);
                this.mSeries.AddDataPoint(this.mPreviousBar);
            } else {
                boolean mergewbar;
                boolean bl = mergewbar = this.mPreviousBar.getVolume() < this.mBarInterval.Period;
                if (time.isBefore(this.mPreviousBar.getTime())) {
                    time = this.mPreviousBar.getTime();
                }
                if (!mergewbar && time.equals(this.mPreviousBar.getTime())) {
                    time = time.AddMilliseconds(1.0);
                }
                if (mergewbar && this.mPreviousBar.getVolume() + volume > this.mBarInterval.Period) {
                    residualvolume = volume - (this.mBarInterval.Period - this.mPreviousBar.getVolume());
                    volume = this.mBarInterval.Period - this.mPreviousBar.getVolume();
                } else if (!mergewbar && volume > this.mBarInterval.Period) {
                    residualvolume = volume - this.mBarInterval.Period;
                    volume = this.mBarInterval.Period;
                }
                if (mergewbar) {
                    if (this.mPreviousBar != null && !this.mPreviousBar.isAggregable()) {
                        this.mPreviousBar = BarDataPoint.CreateAggregableBar(this.mPreviousBar);
                        this.mSeries.AddDataPoint(this.mPreviousBar);
                    }
                    this.mPreviousBar.setCloseTime(time);
                    this.mPreviousBar.setHigh(Math.max(this.mPreviousBar.getHigh(), highPrice));
                    this.mPreviousBar.setLow(Math.min(this.mPreviousBar.getLow(), lowPrice));
                    this.mPreviousBar.setClose(closePrice);
                    this.mPreviousBar.setVolume(this.mPreviousBar.getVolume() + volume);
                    this.mPreviousBar.setVolumeAtBid(this.mPreviousBar.getVolumeAtBid() + bidVolume);
                    this.mPreviousBar.setVolumeAtOffer(this.mPreviousBar.getVolumeAtOffer() + offerVolume);
                    this.mPreviousBar.setTradeCount(this.mPreviousBar.getTradeCount() + tradeCount);
                    this.mPreviousBar.setTradesAtBid(this.mPreviousBar.getTradesAtBid() + tradesAtBid);
                    this.mPreviousBar.setTradesAtOffer(this.mPreviousBar.getTradesAtOffer() + tradesAtOffer);
                    this.mPreviousBar.setIsLive(isLive);
                    this.mSeries.dataPointUpdated(this.mPreviousBar);
                } else {
                    if (this.mPreviousBar != null && this.mPreviousBar.isLive()) {
                        this.mPreviousBar.setIsLive(false);
                        this.mSeries.dataPointUpdated(this.mPreviousBar);
                    }
                    this.mPreviousBar = BarDataPoint.CreateBar(tradeDate, time, time, openPrice, highPrice, lowPrice, closePrice, volume, 0, 0, tradeCount, 0, 0, isLive);
                    this.mSeries.AddDataPoint(this.mPreviousBar);
                }
            }
            if (residualvolume <= 0) continue;
            volume = residualvolume;
            tradeCount = 0;
            highPrice = lowPrice = closePrice;
            openPrice = lowPrice;
        } while (residualvolume > 0);
    }

    @Override
    public void addSettlement(SettlementDataPoint settlement) {
        this.mSeries.addSettlement(settlement);
    }

    @Override
    public void addModeChange(MarketModeDataPoint mode) {
        this.mSeries.addModeChange(mode);
    }
}

