/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata.aggregators;

import com.t4login.application.chart.BarInterval;
import com.t4login.application.chart.ChartInterval;
import com.t4login.application.chart.SessionTimeRange;
import com.t4login.application.chart.chartdata.BarDataPoint;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.MarketModeDataPoint;
import com.t4login.application.chart.chartdata.SettlementDataPoint;
import com.t4login.application.chart.chartdata.aggregators.IAggregator;
import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;
import com.t4login.definitions.BidOffer;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.util.Range;

public class TimeAggregator
implements IAggregator {
    private final BarDataSeries mSeries;
    private final BarInterval mBarInterval;
    private final SessionTimeRange mSession;
    private IBarDataPoint mPreviousBar = null;

    public TimeAggregator(BarDataSeries series) {
        this.mSeries = series;
        this.mBarInterval = this.mSeries.getArgs().Interval;
        this.mSession = this.mSeries.getArgs().Session;
    }

    private boolean getAlignToTradeDate() {
        return this.mBarInterval.compareTo(BarInterval.Bar1Day) >= 0;
    }

    @Override
    public void addTrade(NDateTime time, Price tradePrice, int volume, BidOffer side, NDateTime tradeDate, boolean isLive) {
        IBarDataPoint prevBar;
        NDateTime bartime;
        if (!this.mSession.contains(time)) {
            return;
        }
        NDateTime nDateTime = bartime = this.getAlignToTradeDate() ? this.mBarInterval.roundDownToInterval(tradeDate, NTimeSpan.Zero) : this.mBarInterval.roundDownToInterval(time, NTimeSpan.Zero);
        if (this.mPreviousBar == null && (prevBar = this.mSeries.getLast()) != null) {
            this.mPreviousBar = prevBar;
        }
        if (this.mPreviousBar == null) {
            this.mPreviousBar = BarDataPoint.CreateBar(tradeDate, bartime, time, tradePrice, tradePrice, tradePrice, tradePrice, volume, side.equals(BidOffer.Bid) ? volume : 0, side.equals(BidOffer.Offer) ? volume : 0, 1, side.equals(BidOffer.Bid) ? 1 : 0, side.equals(BidOffer.Offer) ? 1 : 0, isLive);
            this.mSeries.AddDataPoint(this.mPreviousBar);
        } else {
            boolean mergewbar = false;
            if (this.mBarInterval.isTimeBased()) {
                mergewbar = bartime.equals(this.mPreviousBar.getTime());
            } else if (this.mBarInterval.Interval == ChartInterval.Tick) {
                boolean bl = mergewbar = this.mPreviousBar.getTradeCount() < this.mBarInterval.Period;
                if (bartime.compareTo(this.mPreviousBar.getTime()) < 0) {
                    bartime = this.mPreviousBar.getTime();
                }
                if (!mergewbar && bartime.equals(this.mPreviousBar.getTime())) {
                    bartime = bartime.AddMilliseconds(1.0);
                }
            } else if (this.mBarInterval.Interval == ChartInterval.TickRange) {
                Range<Double> tickRange = new Range<Double>(this.mPreviousBar.getLow(), this.mPreviousBar.getHigh());
                boolean bl = mergewbar = (tickRange = tickRange.expanded(tradePrice.getDoubleValue())).end() - tickRange.start() <= (double)this.mBarInterval.Period * this.mSeries.getArgs().Market.getMinPriceIncrement().getDoubleValue();
                if (bartime.compareTo(this.mPreviousBar.getTime()) < 0) {
                    bartime = this.mPreviousBar.getTime();
                }
                if (!mergewbar && bartime.equals(this.mPreviousBar.getTime())) {
                    bartime = bartime.AddMilliseconds(1.0);
                }
            }
            if (mergewbar) {
                if (this.mPreviousBar != null && !this.mPreviousBar.isAggregable()) {
                    this.mPreviousBar = BarDataPoint.CreateAggregableBar(this.mPreviousBar);
                    this.mSeries.AddDataPoint(this.mPreviousBar);
                }
                this.mPreviousBar.setCloseTime(time);
                this.mPreviousBar.setHigh(Math.max(this.mPreviousBar.getHigh(), tradePrice.getDoubleValue()));
                this.mPreviousBar.setLow(Math.min(this.mPreviousBar.getLow(), tradePrice.getDoubleValue()));
                this.mPreviousBar.setClose(tradePrice.getDoubleValue());
                this.mPreviousBar.setVolume(this.mPreviousBar.getVolume() + volume);
                this.mPreviousBar.setVolumeAtBid(this.mPreviousBar.getVolumeAtBid() + (side.equals(BidOffer.Bid) ? volume : 0));
                this.mPreviousBar.setVolumeAtOffer(this.mPreviousBar.getVolumeAtOffer() + (side.equals(BidOffer.Offer) ? volume : 0));
                this.mPreviousBar.setTradeCount(this.mPreviousBar.getTradeCount() + 1);
                this.mPreviousBar.setTradesAtBid(this.mPreviousBar.getTradesAtBid() + (side.equals(BidOffer.Bid) ? 1 : 0));
                this.mPreviousBar.setTradesAtOffer(this.mPreviousBar.getTradesAtOffer() + (side.equals(BidOffer.Offer) ? 1 : 0));
                this.mPreviousBar.setIsLive(isLive);
                this.mSeries.dataPointUpdated(this.mPreviousBar);
            } else {
                if (this.mPreviousBar != null && this.mPreviousBar.isLive()) {
                    if (this.mSeries.getArgs().CloseWithSettlement && !this.mPreviousBar.getTradeDate().equals(tradeDate)) {
                        SettlementDataPoint finalSettlement = (SettlementDataPoint)this.mSeries.getSettlementData().getNearestGreater(this.mPreviousBar.getCloseTime());
                        while (finalSettlement != null && finalSettlement.TradeDate.compareTo(this.mPreviousBar.getTradeDate()) < 0) {
                            finalSettlement = (SettlementDataPoint)this.mSeries.getSettlementData().getNext(finalSettlement.getTime());
                        }
                        if (finalSettlement != null) {
                            if (this.mPreviousBar != null && !this.mPreviousBar.isAggregable()) {
                                this.mPreviousBar = BarDataPoint.CreateAggregableBar(this.mPreviousBar);
                                this.mSeries.AddDataPoint(this.mPreviousBar);
                            }
                            this.mPreviousBar.setClose(finalSettlement.getValue());
                            this.mPreviousBar.setLow(Math.max(this.mPreviousBar.getLow(), this.mPreviousBar.getClose()));
                            this.mPreviousBar.setHigh(Math.min(this.mPreviousBar.getHigh(), this.mPreviousBar.getClose()));
                        }
                    }
                    this.mPreviousBar.setIsLive(false);
                }
                this.mPreviousBar = BarDataPoint.CreateBar(tradeDate, bartime, time, tradePrice, tradePrice, tradePrice, tradePrice, volume, side.equals(BidOffer.Bid) ? volume : 0, side.equals(BidOffer.Offer) ? volume : 0, 1, side.equals(BidOffer.Bid) ? 1 : 0, side.equals(BidOffer.Offer) ? 1 : 0, isLive);
                this.mSeries.AddDataPoint(this.mPreviousBar);
            }
        }
    }

    @Override
    public void addBar(NDateTime time, NDateTime closeTime, Price openPrice, Price highPrice, Price lowPrice, Price closePrice, int volume, int volumeAtBid, int volumeAtOffer, int tradeCount, int tradesAtBid, int tradesAtOffer, NDateTime tradeDate, boolean isLive) {
        this.addBar(time, closeTime, openPrice.getDoubleValue(), highPrice.getDoubleValue(), lowPrice.getDoubleValue(), closePrice.getDoubleValue(), volume, volumeAtBid, volumeAtOffer, tradeCount, tradesAtBid, tradesAtOffer, tradeDate, isLive);
    }

    @Override
    public void addBar(NDateTime time, NDateTime closeTime, double openPrice, double highPrice, double lowPrice, double closePrice, int volume, int volumeAtBid, int volumeAtOffer, int tradeCount, int tradesAtBid, int tradesAtOffer, NDateTime tradeDate, boolean isLive) {
        IBarDataPoint prevBar;
        int residualvolume = 0;
        NDateTime nDateTime = time = this.getAlignToTradeDate() ? this.mBarInterval.roundDownToInterval(tradeDate, NTimeSpan.Zero) : this.mBarInterval.roundDownToInterval(time, NTimeSpan.Zero);
        if (this.mPreviousBar == null && (prevBar = this.mSeries.getLast()) != null) {
            this.mPreviousBar = prevBar;
        }
        if (this.mPreviousBar == null) {
            if (this.mBarInterval.Interval == ChartInterval.Volume && volume > this.mBarInterval.Period) {
                residualvolume = volume - this.mBarInterval.Period;
                volume = this.mBarInterval.Period;
            }
            this.mPreviousBar = BarDataPoint.CreateBar(tradeDate, time, closeTime, openPrice, highPrice, lowPrice, closePrice, volume, volumeAtBid, volumeAtOffer, tradeCount, tradesAtBid, tradesAtOffer, isLive);
            this.mSeries.AddDataPoint(this.mPreviousBar);
        } else {
            boolean mergewbar = false;
            if (this.mBarInterval.isTimeBased()) {
                mergewbar = time.compareTo(this.mPreviousBar.getTime()) <= 0;
            } else if (this.mBarInterval.Interval == ChartInterval.Tick) {
                mergewbar = this.mPreviousBar.getTradeCount() < this.mBarInterval.Period;
            } else if (this.mBarInterval.Interval == ChartInterval.TickRange) {
                Range<Double> tickrange = Range.of(this.mPreviousBar.getLow(), this.mPreviousBar.getHigh());
                tickrange = tickrange.expanded(highPrice);
                mergewbar = (tickrange = tickrange.expanded(lowPrice)).end() - tickrange.start() <= (double)this.mBarInterval.Period;
            } else if (this.mBarInterval.Interval == ChartInterval.Volume) {
                boolean bl = mergewbar = this.mPreviousBar.getVolume() < this.mBarInterval.Period;
            }
            if (mergewbar) {
                if (this.mPreviousBar != null && !this.mPreviousBar.isAggregable()) {
                    this.mPreviousBar = BarDataPoint.CreateAggregableBar(this.mPreviousBar);
                    this.mSeries.AddDataPoint(this.mPreviousBar);
                }
                this.mPreviousBar.setCloseTime(closeTime);
                this.mPreviousBar.setHigh(Math.max(this.mPreviousBar.getHigh(), highPrice));
                this.mPreviousBar.setLow(Math.min(this.mPreviousBar.getLow(), lowPrice));
                this.mPreviousBar.setClose(closePrice);
                this.mPreviousBar.setVolume(this.mPreviousBar.getVolume() + volume);
                this.mPreviousBar.setVolumeAtBid(this.mPreviousBar.getVolumeAtBid() + volumeAtBid);
                this.mPreviousBar.setVolumeAtOffer(this.mPreviousBar.getVolumeAtOffer() + volumeAtOffer);
                this.mPreviousBar.setTradeCount(this.mPreviousBar.getTradeCount() + tradeCount);
                this.mPreviousBar.setTradesAtBid(this.mPreviousBar.getTradesAtBid() + tradesAtBid);
                this.mPreviousBar.setTradesAtOffer(this.mPreviousBar.getVolumeAtOffer() + tradesAtOffer);
                this.mPreviousBar.setIsLive(isLive);
                this.mSeries.dataPointUpdated(this.mPreviousBar);
            } else {
                if (this.mPreviousBar != null && this.mPreviousBar.isLive()) {
                    if (this.mSeries.getArgs().CloseWithSettlement && !this.mPreviousBar.getTradeDate().equals(tradeDate)) {
                        SettlementDataPoint finalSettlement = (SettlementDataPoint)this.mSeries.getSettlementData().getNearestGreater(this.mPreviousBar.getCloseTime());
                        while (finalSettlement != null && finalSettlement.TradeDate.compareTo(this.mPreviousBar.getTradeDate()) < 0) {
                            finalSettlement = (SettlementDataPoint)this.mSeries.getSettlementData().getNext(finalSettlement.getTime());
                        }
                        if (finalSettlement != null) {
                            if (this.mPreviousBar != null && !this.mPreviousBar.isAggregable()) {
                                this.mPreviousBar = BarDataPoint.CreateAggregableBar(this.mPreviousBar);
                                this.mSeries.AddDataPoint(this.mPreviousBar);
                            }
                            this.mPreviousBar.setClose(finalSettlement.getValue());
                            this.mPreviousBar.setLow(Math.max(this.mPreviousBar.getLow(), this.mPreviousBar.getClose()));
                            this.mPreviousBar.setHigh(Math.min(this.mPreviousBar.getHigh(), this.mPreviousBar.getClose()));
                        }
                    }
                    this.mPreviousBar.setIsLive(false);
                }
                this.mPreviousBar = BarDataPoint.CreateBar(tradeDate, time, closeTime, openPrice, highPrice, lowPrice, closePrice, volume, volumeAtBid, volumeAtOffer, tradeCount, tradesAtBid, tradesAtOffer, isLive);
                this.mSeries.AddDataPoint(this.mPreviousBar);
            }
        }
    }

    @Override
    public void addSettlement(SettlementDataPoint settlement) {
        this.mSeries.addSettlement(settlement);
        if (this.mSeries.getArgs().CloseWithSettlement) {
            IBarDataPoint prevBar;
            if (this.mPreviousBar == null && (prevBar = this.mSeries.getLast()) != null) {
                this.mPreviousBar = prevBar;
            }
            if (this.mPreviousBar != null && !this.mPreviousBar.isAggregable()) {
                this.mPreviousBar = BarDataPoint.CreateAggregableBar(this.mPreviousBar);
                this.mSeries.AddDataPoint(this.mPreviousBar);
            }
            if (this.mPreviousBar != null && settlement.TradeDate.compareTo(this.mPreviousBar.getTradeDate()) >= 0) {
                this.mPreviousBar.setClose(settlement.getValue());
                this.mPreviousBar.setLow(Math.min(this.mPreviousBar.getLow(), this.mPreviousBar.getClose()));
                this.mPreviousBar.setHigh(Math.max(this.mPreviousBar.getHigh(), this.mPreviousBar.getLow()));
                this.mSeries.dataPointUpdated(this.mPreviousBar);
            }
        }
    }

    @Override
    public void addModeChange(MarketModeDataPoint mode) {
        this.mSeries.addModeChange(mode);
    }
}

