/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata.aggregators;

import com.t4login.application.chart.ChartInterval;
import com.t4login.application.chart.chartdata.BarDataSeries;
import com.t4login.application.chart.chartdata.DataLoadArgs;
import com.t4login.application.chart.chartdata.aggregators.IAggregator;
import com.t4login.application.chart.chartdata.aggregators.TimeAggregator;
import com.t4login.application.chart.chartdata.aggregators.VolumeAggregator;
import com.t4login.definitions.ChartType;

public class Aggregator {
    private Aggregator() {
    }

    public static IAggregator createAggregator(BarDataSeries series) {
        DataLoadArgs args = series.getArgs();
        if (args.ChartType == ChartType.HeikenAshi) {
            throw new UnsupportedOperationException("HeikenAshi has not been implemented yet.");
        }
        if (args.ChartType == ChartType.Renko) {
            throw new UnsupportedOperationException("Renko has not been implemented yet.");
        }
        if (args.ChartType == ChartType.PointAndFigure) {
            throw new UnsupportedOperationException("PointAndFigure has not been implemented yet.");
        }
        if (args.Interval.Interval == ChartInterval.Volume) {
            return new VolumeAggregator(series);
        }
        return new TimeAggregator(series);
    }
}

