/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata;

import com.t4login.datetime.NDateTime;

public class TradeDateTime
implements Comparable<TradeDateTime> {
    public static final String TradeDateFormat = "MM/dd/yyyy";
    public static final String TimeFormat = "MM/dd/yyyy hh:mm:ss.S a";
    public static final String ShortTimeFormat = "MM/dd hh:mm:ss.S a";
    public final NDateTime TradeDate;
    public final NDateTime Time;

    public TradeDateTime(NDateTime tradeDate, NDateTime time) {
        this.TradeDate = tradeDate;
        this.Time = time;
    }

    @Override
    public int compareTo(TradeDateTime other) {
        int comp = this.TradeDate.compareTo(other.TradeDate);
        if (comp == 0) {
            comp = this.Time.compareTo(other.Time);
        }
        return comp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TradeDateTime) {
            TradeDateTime otherTDT = (TradeDateTime)o;
            return this.TradeDate.equals(otherTDT.TradeDate) && this.Time.equals(otherTDT.Time);
        }
        return super.equals(o);
    }

    public String toString() {
        String tradeDateFmt = String.format("%02d/%02d/%04d", this.TradeDate.getMonth(), this.TradeDate.getDay(), this.TradeDate.getYear());
        String timeFmt = String.format("%02d/%02d %02d:%02d:%02d.%03d", this.Time.getMonth(), this.Time.getDay(), this.Time.getHour(), this.Time.getMinute(), this.Time.getSecond(), this.Time.getMillisecond());
        return tradeDateFmt + " | " + timeFmt;
    }
}

