/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata;

import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.datetime.NDateTime;
import com.t4login.util.Range;

public final class TradeDateDataPoint
implements IDataPoint {
    public final NDateTime tradeDate;
    public final Range<NDateTime> timeRange;

    public TradeDateDataPoint(NDateTime tradedate, Range<NDateTime> timerange) {
        this.tradeDate = tradedate;
        this.timeRange = timerange;
    }

    public TradeDateDataPoint(NDateTime tradedate, NDateTime time) {
        this.tradeDate = tradedate;
        this.timeRange = Range.of(time);
    }

    public TradeDateDataPoint(NDateTime tradedate) {
        this.tradeDate = tradedate;
        this.timeRange = Range.empty();
    }

    @Override
    public NDateTime getTime() {
        return this.tradeDate;
    }

    public TradeDateDataPoint expanded(NDateTime time) {
        return new TradeDateDataPoint(this.tradeDate, this.timeRange.expanded(time));
    }

    public String toString() {
        return String.format("Trade Date: %s, Times: %s", this.tradeDate.toDateString(), this.timeRange);
    }
}

