/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata;

import com.t4login.Log;
import com.t4login.application.chart.chartdata.FillDataPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class FillDataSeries
implements Iterable<FillDataPoint> {
    private static final String TAG = "FillDataSeries";
    private List<FillDataPoint> mFills = new ArrayList<FillDataPoint>();

    public void addFill(FillDataPoint fill) {
        if (fill.getTrade().getVolume() > 0) {
            this.mFills.add(fill);
        } else {
            boolean bustMatched = false;
            if (!fill.getExchangeTradeID().isEmpty()) {
                for (FillDataPoint bustFill : this.mFills) {
                    if (!fill.getExchangeTradeID().equals(bustFill.getExchangeTradeID())) continue;
                    bustFill.setIsBusted(true);
                    bustMatched = true;
                    Log.d(TAG, "OrderManager.addFill(), Busted fill: " + String.valueOf(bustFill));
                    break;
                }
            } else {
                ArrayList<FillDataPoint> bustCandidates = new ArrayList<FillDataPoint>();
                for (FillDataPoint bustFill : this.mFills) {
                    if (!fill.getOrderID().equals(bustFill.getOrderID()) || fill.getPrice() != bustFill.getPrice() || bustFill.getIsBusted()) continue;
                    bustCandidates.add(bustFill);
                }
                Collections.sort(bustCandidates, new Comparator<FillDataPoint>(this){

                    @Override
                    public int compare(FillDataPoint a, FillDataPoint b) {
                        return a.getTime().compareTo(b.getTime());
                    }
                });
                if (bustCandidates.size() > 0) {
                    ((FillDataPoint)bustCandidates.get(0)).setIsBusted(true);
                    bustMatched = true;
                    Log.d(TAG, "OrderManager.addFill(), Busted fill: " + String.valueOf(bustCandidates.get(0)));
                }
            }
            if (!bustMatched) {
                Log.d(TAG, "addFill(), Unable to find a trade to match the bust: " + String.valueOf(fill));
            }
        }
    }

    public void removeFill(FillDataPoint fill) {
        this.mFills.remove(fill);
    }

    public int count() {
        return this.mFills.size();
    }

    @Override
    public Iterator<FillDataPoint> iterator() {
        return this.mFills.iterator();
    }
}

