/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata;

import com.t4login.api.accounts.Trade;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.priceconversion.Price;

public class FillDataPoint
implements IDataPointValue {
    private final Trade mTrade;
    private final long mUniqueOrderID;
    private final int mTradeSeq;
    private boolean mIsBusted = false;

    public FillDataPoint(Trade trade) {
        this.mTrade = trade;
        this.mUniqueOrderID = this.mTrade.getOrder().UniqueOrderID;
        this.mTradeSeq = this.mTrade.getTradeSeq();
    }

    public Trade getTrade() {
        return this.mTrade;
    }

    public boolean getIsBusted() {
        return this.mIsBusted;
    }

    public void setIsBusted(boolean value) {
        this.mIsBusted = value;
    }

    public String getMarketID() {
        return this.mTrade.getMarketID();
    }

    public String getExchangeTradeID() {
        return this.mTrade.getDetails().ExchangeTradeID;
    }

    public BuySell getSide() {
        return this.mTrade.getSide();
    }

    public Price getPrice() {
        return this.mTrade.getPrice();
    }

    public int getVolume() {
        return this.mTrade.getVolume();
    }

    public String getOrderID() {
        return this.mTrade.getOrderID();
    }

    public long getUniqueOrderID() {
        return this.mTrade.getUniqueOrderID();
    }

    public int getTradeSeq() {
        return this.mTrade.getTradeSeq();
    }

    @Override
    public NDateTime getTime() {
        return this.mTrade.getTime();
    }

    @Override
    public double getValue() {
        return this.mTrade.getPrice().getDoubleValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FillDataPoint that = (FillDataPoint)o;
        if (this.mUniqueOrderID != that.mUniqueOrderID) {
            return false;
        }
        return this.mTradeSeq == that.mTradeSeq;
    }

    public int hashCode() {
        int result = (int)(this.mUniqueOrderID ^ this.mUniqueOrderID >>> 32);
        result = 31 * result + this.mTradeSeq;
        return result;
    }

    public String toString() {
        return String.format("%s, %s %d@%s", this.mTrade.getTime(), this.mTrade.getSide().getDescription(), this.mTrade.getVolume(), this.mTrade.getPrice());
    }
}

