/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata;

import com.t4login.application.chart.chartdata.DataPointComparer;
import com.t4login.application.chart.chartdata.IDataPointValue;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.collections.TreeSetDictionary;
import com.t4login.datetime.NDateTime;
import com.t4login.util.Range;
import com.t4login.util.RangeType;
import java.util.Iterator;

public class DataSeries<T extends IDataPointValue>
implements IDataSource<T> {
    private TreeSetDictionary<T, NDateTime> mData;
    private final String Description;
    private int mBeginUpdateCounter = 0;
    private boolean mDestroyed = false;
    private final TreeSetDictionary.DistanceComparer<T, NDateTime> mDistanceComparer = new TreeSetDictionary.DistanceComparer<T, NDateTime>(this){

        @Override
        public int compareDistanceTo(NDateTime target, T value1, T value2) {
            long dv2;
            long targetTicks = target.getTicks();
            long v1Ticks = value1.getTime().getTicks();
            long v2Ticks = value2.getTime().getTicks();
            long dv1 = Math.abs(targetTicks - v1Ticks);
            if (dv1 < (dv2 = Math.abs(targetTicks - v2Ticks))) {
                return -1;
            }
            if (dv1 > dv2) {
                return 1;
            }
            return 0;
        }
    };

    public DataSeries() {
        this.Description = "";
        this.mData = new TreeSetDictionary(DataPointComparer.ASCENDING);
    }

    public DataSeries(String descr) {
        this.Description = descr;
        this.mData = new TreeSetDictionary(DataPointComparer.ASCENDING);
    }

    public void beginUpdate() {
        ++this.mBeginUpdateCounter;
    }

    public void endUpdate() {
        --this.mBeginUpdateCounter;
    }

    public void addDataPoint(T dp) {
        this.mData.add(dp);
    }

    public void removeDataPoint(T dp) {
        this.mData.remove(dp);
    }

    public void clear() {
        this.mData.clear();
    }

    public boolean isEmpty() {
        return this.mData.size() == 0;
    }

    public Range<Double> getValueRange(Range<NDateTime> timeRange) {
        if (timeRange.isEmpty() || this.mData.size() == 0) {
            return Range.empty();
        }
        Range<Double> valueRange = Range.empty();
        Iterator<T> it = this.mData.getValuesBetween(timeRange.start(), timeRange.end(), RangeType.Enclosed);
        while (it.hasNext()) {
            IDataPointValue pt = (IDataPointValue)it.next();
            valueRange = valueRange.expanded(pt.getValue());
        }
        return valueRange;
    }

    @Override
    public int getCount() {
        return this.mData.size();
    }

    @Override
    public T get(int i) {
        return (T)((IDataPointValue)this.mData.get((NDateTime)i));
    }

    @Override
    public T get(NDateTime dt) {
        return (T)((IDataPointValue)this.mData.get(dt));
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        if (this.mData.size() > 0) {
            return Range.of(((IDataPointValue)this.mData.first()).getTime(), ((IDataPointValue)this.mData.last()).getTime());
        }
        return Range.empty();
    }

    @Override
    public T getFirst() {
        return (T)((IDataPointValue)this.mData.first());
    }

    @Override
    public T getLast() {
        return (T)((IDataPointValue)this.mData.last());
    }

    @Override
    public T getNext(NDateTime dt) {
        return (T)((IDataPointValue)this.mData.getNext(dt));
    }

    @Override
    public T getPreceeding(NDateTime dt) {
        return (T)((IDataPointValue)this.mData.getPrevious(dt));
    }

    @Override
    public T getNearestTo(NDateTime dt) {
        return (T)((IDataPointValue)this.mData.nearest(dt, this.mDistanceComparer));
    }

    @Override
    public T getNearestGreater(NDateTime dt) {
        return (T)((IDataPointValue)this.mData.nearestGreater(dt));
    }

    @Override
    public T getNearestSmaller(NDateTime dt) {
        return (T)((IDataPointValue)this.mData.nearestSmaller(dt));
    }

    @Override
    public Iterable<T> getPointsBetween(final Range<NDateTime> range, final RangeType rangeType) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return DataSeries.this.mData.getValuesBetween((NDateTime)range.start(), (NDateTime)range.end(), rangeType);
            }
        };
    }

    @Override
    public Iterator<T> iterator() {
        return this.mData.iterator();
    }
}

