/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata;

import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.collections.TreeSetDictionary;
import com.t4login.datetime.NDateTime;
import com.t4login.util.SortDir;
import java.util.Comparator;

public class DataPointComparer
implements Comparator,
TreeSetDictionary.DistanceComparer<IDataPoint, NDateTime> {
    public static final DataPointComparer ASCENDING = new DataPointComparer(SortDir.Ascending);
    public static final DataPointComparer DESCENDING = new DataPointComparer(SortDir.Descending);
    private final SortDir mSortDir;

    private DataPointComparer(SortDir dir) {
        this.mSortDir = dir;
    }

    public int compare(Object a, Object b) {
        int res = 0;
        NDateTime key1 = null;
        NDateTime key2 = null;
        if (a instanceof NDateTime) {
            key1 = (NDateTime)a;
        } else if (a instanceof IDataPoint) {
            key1 = ((IDataPoint)a).getTime();
        }
        if (b instanceof NDateTime) {
            key2 = (NDateTime)b;
        } else if (b instanceof IDataPoint) {
            key2 = ((IDataPoint)b).getTime();
        }
        if (key1 != null && key2 != null) {
            res = key1.compareTo(key2);
        } else if (key1 == null && key2 == null) {
            res = 0;
        } else if (key1 == null) {
            res = -1;
        } else if (key2 == null) {
            res = 1;
        }
        if (res != 0 && this.mSortDir == SortDir.Descending) {
            res *= -1;
        }
        return res;
    }

    @Override
    public int compareDistanceTo(NDateTime target, IDataPoint value1, IDataPoint value2) {
        long targetTicks = target.getTicks();
        long v1Ticks = value1.getTime().getTicks();
        long v2Ticks = value2.getTime().getTicks();
        if (Math.abs(targetTicks - v1Ticks) < Math.abs(targetTicks - v2Ticks)) {
            return -1;
        }
        if (v1Ticks != v2Ticks) {
            return 1;
        }
        return 0;
    }
}

