/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata;

import com.t4login.application.ConfigContext;
import com.t4login.application.chart.BarInterval;
import com.t4login.application.chart.ChartInterval;
import com.t4login.application.chart.ContractMonth;
import com.t4login.application.chart.SessionTimeRange;
import com.t4login.application.chart.markets.ExpiryContinuationMarket;
import com.t4login.application.chart.markets.ExpiryMarket;
import com.t4login.application.chart.markets.IChartMarket;
import com.t4login.application.chart.markets.VolumeContinuationMarket;
import com.t4login.application.chart.settings.DataSettings;
import com.t4login.application.configuration.UserRole;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BarIntervalBreak;
import com.t4login.definitions.ChartResetInterval;
import com.t4login.definitions.ChartType;
import com.t4login.definitions.ContinuationType;
import com.t4login.definitions.ContractMonths;
import com.t4login.definitions.chartdata.ChartDataType;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public final class DataLoadArgs {
    public final IChartMarket Market;
    public final ChartType ChartType;
    public final BarInterval Interval;
    public final DataSettings.ResetInterval BarResetInterval;
    public final boolean CloseWithSettlement;
    public final SessionTimeRange Session;
    public final boolean AnchorToSession;

    private DataLoadArgs(IChartMarket market, ChartType chartType, BarInterval barInterval, boolean closeWithSettlement, DataSettings.ResetInterval barResetInterval, SessionTimeRange session, boolean anchorToSession) {
        this.Market = market;
        this.ChartType = chartType;
        this.Interval = barInterval;
        this.BarResetInterval = barResetInterval;
        this.CloseWithSettlement = closeWithSettlement;
        this.Session = session;
        this.AnchorToSession = anchorToSession;
    }

    public String toString() {
        return "DataLoadArgs{Market=" + String.valueOf(this.Market) + ", ChartType=" + String.valueOf(this.ChartType) + ", CloseWithSettlement=" + this.CloseWithSettlement + ", Interval=" + String.valueOf(this.Interval) + ", Session=" + String.valueOf(this.Session) + ", Anchor=" + this.AnchorToSession + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataLoadArgs that = (DataLoadArgs)o;
        if (!this.Market.getMarketID().equals(that.Market.getMarketID())) {
            return false;
        }
        if (this.ChartType != that.ChartType) {
            return false;
        }
        if (!this.Interval.equals(that.Interval)) {
            return false;
        }
        if (!this.BarResetInterval.equals((Object)that.BarResetInterval)) {
            return false;
        }
        if (!this.Session.equals(that.Session)) {
            return false;
        }
        if (this.CloseWithSettlement != that.CloseWithSettlement) {
            return false;
        }
        return this.AnchorToSession == that.AnchorToSession;
    }

    public int hashCode() {
        int result = this.Market.getMarketID().hashCode();
        result = 31 * result + this.ChartType.hashCode();
        result = 31 * result + this.Interval.hashCode();
        result = 31 * result + this.BarResetInterval.hashCode();
        result = 31 * result + this.Session.hashCode();
        result = 31 * result + (this.AnchorToSession ? 1 : 0);
        result = 31 * result + (this.CloseWithSettlement ? 1 : 0);
        return result;
    }

    public boolean isInterDay() {
        return this.Interval.compareTo(BarInterval.Bar1Day) >= 0;
    }

    public String getExchangeID() {
        return this.Market.getExchangeID();
    }

    public String getContractID() {
        return this.Market.getContractID();
    }

    public String getMarketID() {
        return this.Market.getMarketID();
    }

    public ContinuationType getContinuationType() {
        if (this.Market instanceof VolumeContinuationMarket) {
            return ContinuationType.Volume;
        }
        if (this.Market instanceof ExpiryContinuationMarket) {
            return ContinuationType.Expiry;
        }
        return ContinuationType.Volume;
    }

    public int getRolloverThreshold() {
        if (this.Market instanceof ExpiryContinuationMarket) {
            ExpiryContinuationMarket cmkt = (ExpiryContinuationMarket)this.Market;
            return cmkt.getExpiryRolloverDays();
        }
        return 0;
    }

    public int getForwardMonths() {
        if (this.Market instanceof ExpiryContinuationMarket) {
            ExpiryContinuationMarket cmkt = (ExpiryContinuationMarket)this.Market;
            return cmkt.getExpiryForwardMonths();
        }
        return 0;
    }

    public Set<ContractMonths> getExpiryContractMonths() {
        if (this.Market instanceof ExpiryContinuationMarket) {
            ExpiryContinuationMarket cmkt = (ExpiryContinuationMarket)this.Market;
            HashSet<ContractMonths> months = new HashSet<ContractMonths>();
            for (ContractMonth m : cmkt.getExpiryContractMonths()) {
                switch (m) {
                    case January: {
                        months.add(ContractMonths.Jan);
                    }
                    case February: {
                        months.add(ContractMonths.Feb);
                    }
                    case March: {
                        months.add(ContractMonths.Mar);
                    }
                    case April: {
                        months.add(ContractMonths.Apr);
                    }
                    case May: {
                        months.add(ContractMonths.May);
                    }
                    case June: {
                        months.add(ContractMonths.Jun);
                    }
                    case July: {
                        months.add(ContractMonths.Jul);
                    }
                    case August: {
                        months.add(ContractMonths.Aug);
                    }
                    case September: {
                        months.add(ContractMonths.Sep);
                    }
                    case October: {
                        months.add(ContractMonths.Oct);
                    }
                    case November: {
                        months.add(ContractMonths.Nov);
                    }
                    case December: {
                        months.add(ContractMonths.Dec);
                    }
                }
            }
            return months;
        }
        return ContractMonths.All;
    }

    public ChartType getChartType() {
        return this.ChartType;
    }

    @Deprecated
    public ChartDataType getDataType() {
        block14: {
            block13: {
                if (this.ChartType == com.t4login.definitions.ChartType.Renko) break block13;
                if (this.ChartType != com.t4login.definitions.ChartType.PointAndFigure) break block14;
            }
            return ChartDataType.Tick;
        }
        if (this.Interval.Interval == ChartInterval.Tick) {
            return ChartDataType.Tick;
        }
        if (this.Interval.Interval == ChartInterval.TickRange) {
            return ChartDataType.Tick;
        }
        if (this.Interval.Interval == ChartInterval.Volume) {
            return ChartDataType.Tick;
        }
        if (this.Interval.Interval == ChartInterval.Second) {
            return ChartDataType.Second;
        }
        if (this.Interval.Interval == ChartInterval.Minute) {
            return ChartDataType.Minute;
        }
        if (this.Interval.Interval == ChartInterval.Hour) {
            return ChartDataType.Hour;
        }
        if (this.Interval.Interval == ChartInterval.Day) {
            return ChartDataType.Day;
        }
        if (this.Interval.Interval == ChartInterval.Week) {
            return ChartDataType.Day;
        }
        if (this.Interval.Interval == ChartInterval.Month) {
            return ChartDataType.Day;
        }
        if (this.Interval.Interval == ChartInterval.Year) {
            return ChartDataType.Day;
        }
        return ChartDataType.Tick;
    }

    public BarIntervalBreak getBarInterval() {
        switch (this.Interval.Interval) {
            case Tick: {
                return BarIntervalBreak.Tick;
            }
            case TickRange: {
                return BarIntervalBreak.TickRange;
            }
            case Volume: {
                return BarIntervalBreak.Volume;
            }
            case Second: {
                return BarIntervalBreak.Second;
            }
            case Minute: {
                return BarIntervalBreak.Minute;
            }
            case Hour: {
                return BarIntervalBreak.Hour;
            }
            case Day: {
                return BarIntervalBreak.Day;
            }
            case Week: {
                return BarIntervalBreak.Week;
            }
            case Month: {
                return BarIntervalBreak.Day;
            }
        }
        return BarIntervalBreak.Day;
    }

    public int getBarPeriod() {
        return this.Interval.Period;
    }

    public ChartResetInterval getBarResetInterval() {
        switch (this.BarResetInterval) {
            case None: {
                return ChartResetInterval.None;
            }
            case TradingDay: {
                return ChartResetInterval.TradingDay;
            }
            case TradingWeek: {
                return ChartResetInterval.TradingWeek;
            }
            case ExpiryChange: {
                return ChartResetInterval.ExpiryChange;
            }
        }
        return ChartResetInterval.TradingWeek;
    }

    public NDateTime getSessionStartTime() {
        return this.Session.startTime().toDateTime(NDateTime.now());
    }

    public NDateTime getSessionEndTime() {
        return this.Session.endTime().toDateTime(NDateTime.now());
    }

    public LinkedHashMap<String, String> getExConfig() {
        LinkedHashMap<String, String> ex = new LinkedHashMap<String, String>();
        if (this.CloseWithSettlement) {
            ex.put("CloseWithSettlement", "1");
        }
        if (!this.Session.isEmpty() && this.AnchorToSession) {
            ex.put("AnchorToSession", "1");
        }
        return ex;
    }

    public static class Builder {
        private IChartMarket market;
        private ChartType chartType = com.t4login.definitions.ChartType.Bar;
        private BarInterval barInterval = BarInterval.Default;
        private boolean closeWithSettlement = false;
        private DataSettings.ResetInterval barResetInterval = DataSettings.ResetInterval.ExpiryChange;
        private SessionTimeRange session = SessionTimeRange.Empty;
        private boolean anchorToSession = false;

        public Builder() {
        }

        public Builder(DataLoadArgs args) {
            this.market = args.Market;
            this.chartType = args.ChartType;
            this.barInterval = args.Interval;
            this.closeWithSettlement = args.CloseWithSettlement;
            this.barResetInterval = args.BarResetInterval;
            this.session = args.Session;
            this.anchorToSession = args.AnchorToSession;
        }

        public Builder setMarket(IChartMarket market) {
            this.market = market;
            return this;
        }

        public Builder setChartType(ChartType chartType) {
            this.chartType = chartType;
            return this;
        }

        public Builder setBarInterval(BarInterval barInterval) {
            this.barInterval = barInterval;
            return this;
        }

        public Builder setCloseWithSettlement(boolean closeWithSettlement) {
            this.closeWithSettlement = closeWithSettlement;
            return this;
        }

        public Builder setBarResetInterval(DataSettings.ResetInterval barResetInterval) {
            this.barResetInterval = barResetInterval;
            return this;
        }

        public Builder setSession(SessionTimeRange session) {
            this.session = session;
            return this;
        }

        public Builder setAnchorToSession(boolean anchorToSession) {
            this.anchorToSession = anchorToSession;
            return this;
        }

        public DataLoadArgs createDataLoadArgs() {
            if (this.market == null) {
                this.market = ExpiryMarket.Empty;
            }
            if (ConfigContext.Default.getUserRole() != UserRole.Standard) {
                this.chartType = com.t4login.definitions.ChartType.Bar;
                if (this.barInterval.Interval.getValue() < ChartInterval.Minute.getValue()) {
                    this.barInterval = BarInterval.Bar15Minute;
                }
                this.session = SessionTimeRange.Empty;
            }
            return new DataLoadArgs(this.market, this.chartType, this.barInterval, this.closeWithSettlement, this.barResetInterval, this.session, this.anchorToSession);
        }
    }
}

