/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.application.chart.chartdata;

import com.t4login.Log;
import com.t4login.application.chart.chartdata.DataLoadArgs;
import com.t4login.application.chart.chartdata.DataPointComparer;
import com.t4login.application.chart.chartdata.DataSeries;
import com.t4login.application.chart.chartdata.DataSource;
import com.t4login.application.chart.chartdata.IBarDataPoint;
import com.t4login.application.chart.chartdata.IDataPoint;
import com.t4login.application.chart.chartdata.MarketModeDataPoint;
import com.t4login.application.chart.chartdata.SettlementDataPoint;
import com.t4login.application.chart.chartdata.TickDataPoint;
import com.t4login.application.chart.chartdata.TradeDateDataPoint;
import com.t4login.application.chart.chartdata.aggregators.Aggregator;
import com.t4login.application.chart.chartdata.aggregators.IAggregator;
import com.t4login.application.chart.chartdata.dataprovider.DataDefinition;
import com.t4login.application.chart.chartdata.dataprovider.DataField;
import com.t4login.application.chart.chartdata.dataprovider.IDataProvider;
import com.t4login.application.chart.chartdata.dataprovider.IDataSource;
import com.t4login.application.chart.markets.ExpiryMarket;
import com.t4login.application.settings.AppSettings;
import com.t4login.collections.TreeSetDictionary;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.PriceFormat;
import com.t4login.util.Range;
import com.t4login.util.RangeType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public final class BarDataSeries
implements IDataSource<IBarDataPoint>,
IDataProvider {
    private static final String TAG = "BarDataSeries";
    private static final int MAX_BARS = 100000;
    public static final BarDataSeries Empty = new BarDataSeries(new DataLoadArgs.Builder().setMarket(ExpiryMarket.Empty).createDataLoadArgs());
    private final String mGenerationID;
    private final DataLoadArgs mArgs;
    private DataSource mSource = DataSource.Unknown;
    private IAggregator mAggregator = null;
    private final TreeSetDictionary<IBarDataPoint, NDateTime> mData;
    private final DataSeries<MarketModeDataPoint> mModeData;
    private final DataSeries<SettlementDataPoint> mSettlementData;
    private final TreeSetDictionary<TradeDateDataPoint, NDateTime> mTradeDays;
    private final Map<String, Object> mExData;
    private NDateTime mTradeDateStart = NDateTime.MinValue;
    private boolean mIsDisposed = false;
    private int mBeginUpdateCounter = 0;
    public IBarDataPoint baseDataPoint = null;
    private final List<DataUpdatedHandler> mDataUpdatedHandlers = new CopyOnWriteArrayList<DataUpdatedHandler>();
    Range<NDateTime> mPendingUpdateTimeRange = Range.empty();
    private static final TreeSetDictionary.DistanceComparer mBarDistanceComparer = new TreeSetDictionary.DistanceComparer<IBarDataPoint, NDateTime>(){

        @Override
        public int compareDistanceTo(NDateTime target, IBarDataPoint value1, IBarDataPoint value2) {
            long dv2;
            long targetTicks = target.getTicks();
            long v1Ticks = value1.getTime().getTicks();
            long v2Ticks = value2.getTime().getTicks();
            long dv1 = Math.abs(targetTicks - v1Ticks);
            if (dv1 < (dv2 = Math.abs(targetTicks - v2Ticks))) {
                return -1;
            }
            if (dv1 > dv2) {
                return 1;
            }
            return 0;
        }
    };
    private DataDefinition mDataDef = null;
    private DataDefinition mSettlmentDataDef = null;

    public BarDataSeries(DataLoadArgs args) {
        this.mGenerationID = UUID.randomUUID().toString();
        this.mArgs = args;
        this.mData = new TreeSetDictionary(DataPointComparer.ASCENDING);
        this.mModeData = new DataSeries("BarDataSeries.ModeData");
        this.mSettlementData = new DataSeries("BarDataSeries.SettlementData");
        this.mTradeDays = new TreeSetDictionary(DataPointComparer.ASCENDING);
        this.mExData = new HashMap<String, Object>();
    }

    public void registerForSubscriptionUpdates(DataUpdatedHandler handler) {
        if (!this.mDataUpdatedHandlers.contains(handler)) {
            this.mDataUpdatedHandlers.add(handler);
        }
    }

    public void unregisterForSubscriptionUpdates(DataUpdatedHandler handler) {
        if (this.mDataUpdatedHandlers.contains(handler)) {
            this.mDataUpdatedHandlers.remove(handler);
        }
    }

    public String getGenerationID() {
        return this.mGenerationID;
    }

    public IAggregator getAggregator() {
        return this.mAggregator;
    }

    public void setAggregator(IAggregator aggregator) {
        this.mAggregator = aggregator;
    }

    @Override
    public int getCount() {
        return this.mData.size();
    }

    public int getMaxCapacity() {
        return 100000;
    }

    public boolean isAtCapacity() {
        return this.mData.size() >= 100000;
    }

    public DataSeries<MarketModeDataPoint> getModeData() {
        return this.mModeData;
    }

    public DataSeries<SettlementDataPoint> getSettlementData() {
        return this.mSettlementData;
    }

    public TreeSetDictionary<TradeDateDataPoint, NDateTime> getTradeDates() {
        return this.mTradeDays;
    }

    public DataLoadArgs getArgs() {
        return this.mArgs;
    }

    public boolean isEmpty() {
        return this.mData.size() == 0;
    }

    public NDateTime getLiveDataPointTime() {
        IBarDataPoint pt = this.mData.last();
        if (pt == null) {
            return null;
        }
        return pt.getCloseTime();
    }

    public Object getExData(String key) {
        return this.mExData.get(key);
    }

    public void SetExData(String key, Object data) {
        this.mExData.put(key, data);
    }

    public synchronized void beingUpdate() {
        ++this.mBeginUpdateCounter;
    }

    public synchronized void endUpdate() {
        --this.mBeginUpdateCounter;
        if (this.mBeginUpdateCounter < 0) {
            Log.e(TAG, "endUpdate(), [" + String.valueOf(this) + "], More calls have been to to EndUpdate() than to BeginUpdate(). Forcing the counter to 0.");
            this.mBeginUpdateCounter = 0;
        }
        if (this.mBeginUpdateCounter == 0) {
            this.onDataUpdated(this.mPendingUpdateTimeRange);
        }
    }

    public void AddDataPoint(IBarDataPoint pt) {
        this.bufferedAddDataPoint(pt);
    }

    public void dataPointUpdated(IBarDataPoint pt) {
        this.onDataUpdated(Range.of(pt.getTime()));
    }

    private void bufferedAddDataPoint(IBarDataPoint pt) {
        if (!pt.getTradeDate().equals(NDateTime.MinValue)) {
            TradeDateDataPoint tdpt;
            if (this.mTradeDateStart.equals(NDateTime.MinValue)) {
                this.mTradeDateStart = pt.getTradeDate();
            }
            if ((tdpt = this.mTradeDays.get(pt.getTradeDate())) != null) {
                tdpt = tdpt.expanded(pt.getTime());
                this.mTradeDays.add(tdpt);
            } else {
                tdpt = new TradeDateDataPoint(pt.getTradeDate(), pt.getTime());
                this.mTradeDays.add(tdpt);
            }
        }
        if (this.mData.Contains(pt)) {
            IBarDataPoint existingpt = this.mData.get(pt.getTime());
            this.mData.remove(existingpt);
            this.mData.add(pt);
        } else {
            this.mData.add(pt);
        }
    }

    public void addModeChange(MarketModeDataPoint mode) {
        if (mode.Time.equals(NDateTime.MinValue) && (mode.Mode == MarketMode.Undefined || mode.Mode == MarketMode.Unavailable)) {
            return;
        }
        if (mode.Time.equals(NDateTime.MinValue)) {
            return;
        }
        this.mModeData.addDataPoint(mode);
    }

    public void addSettlement(SettlementDataPoint settl) {
        this.mSettlementData.addDataPoint(settl);
    }

    public void addLiveTrade(TickDataPoint trade) {
        if (this.mAggregator == null) {
            this.createAggregator();
        }
        try {
            this.mAggregator.addTrade(trade.Time, trade.TradePrice, trade.Volume, trade.Aggressor, trade.TradeDate, trade.IsLive);
        }
        catch (Exception ex) {
            Log.e(TAG, "addLiveTrade(), Error.", ex);
        }
    }

    public void addLiveSettlement(SettlementDataPoint settlement) {
        if (this.mAggregator == null) {
            this.createAggregator();
        }
        try {
            this.mAggregator.addSettlement(settlement);
        }
        catch (Exception ex) {
            Log.e(TAG, "addLiveSettlement(), Error.", ex);
        }
    }

    public void addLiveModeChange(MarketModeDataPoint mode) {
        this.addModeChange(mode);
    }

    public Range<Double> getPriceRange(Range<NDateTime> timeRange) {
        if (timeRange.isEmpty() || this.mData.size() == 0) {
            return Range.empty();
        }
        Double high = null;
        Double low = null;
        for (IBarDataPoint pt : this.getPointsBetween(timeRange, RangeType.Enclosed)) {
            high = high != null ? Double.valueOf(Math.max(high, pt.getHigh())) : Double.valueOf(pt.getHigh());
            if (low != null) {
                low = Math.min(low, pt.getLow());
                continue;
            }
            low = pt.getLow();
        }
        if (high == null && low == null) {
            return Range.empty();
        }
        return Range.of(low, high);
    }

    public int getIndexOf(IBarDataPoint bar) {
        return this.mData.indexOf(bar);
    }

    private synchronized void onDataUpdated(Range<NDateTime> liveUpdateRange) {
        this.mPendingUpdateTimeRange = this.mPendingUpdateTimeRange.expanded(liveUpdateRange);
        if (this.mDataUpdatedHandlers.size() > 0) {
            for (DataUpdatedHandler h : this.mDataUpdatedHandlers) {
                try {
                    if (this.mBeginUpdateCounter != 0) continue;
                    h.onDataUpdated(this.mPendingUpdateTimeRange);
                    this.mPendingUpdateTimeRange = Range.empty();
                }
                catch (Exception ex) {
                    Log.e(TAG, "onDataUpdated(), [" + String.valueOf(this) + "], DataUpdatedHandler raised an unhandled exception.", ex);
                }
            }
        }
    }

    public void checkCapacity() {
    }

    @Override
    public IBarDataPoint get(int i) {
        return this.mData.get((NDateTime)i);
    }

    @Override
    public IBarDataPoint get(NDateTime dt) {
        return this.mData.get(dt);
    }

    @Override
    public Range<NDateTime> getTimeRange() {
        Range<NDateTime> rng = Range.empty();
        if (this.mData.size() > 0) {
            IBarDataPoint first = this.mData.first();
            IBarDataPoint last = this.mData.last();
            rng = rng.expanded(first.getTime());
            rng = rng.expanded(last.getTime());
        }
        return rng;
    }

    @Override
    public IBarDataPoint getFirst() {
        return this.mData.first();
    }

    @Override
    public IBarDataPoint getLast() {
        return this.mData.last();
    }

    @Override
    public IBarDataPoint getNext(NDateTime dt) {
        return this.mData.getNext(dt);
    }

    @Override
    public IBarDataPoint getPreceeding(NDateTime dt) {
        return this.mData.getPrevious(dt);
    }

    @Override
    public IBarDataPoint getNearestTo(NDateTime dt) {
        return this.mData.nearest(dt, mBarDistanceComparer);
    }

    @Override
    public IBarDataPoint getNearestGreater(NDateTime dt) {
        return this.mData.nearestGreater(dt);
    }

    @Override
    public IBarDataPoint getNearestSmaller(NDateTime dt) {
        return this.mData.nearestSmaller(dt);
    }

    @Override
    public Iterable<IBarDataPoint> getPointsBetween(final Range<NDateTime> range, final RangeType rangeType) {
        return new Iterable<IBarDataPoint>(){

            @Override
            public Iterator<IBarDataPoint> iterator() {
                return BarDataSeries.this.mData.getValuesBetween((NDateTime)range.start(), (NDateTime)range.end(), rangeType);
            }
        };
    }

    @Override
    public Iterator<IBarDataPoint> iterator() {
        return this.mData.iterator();
    }

    private void createAggregator() {
        if (this.mAggregator == null) {
            this.mAggregator = Aggregator.createAggregator(this);
        }
    }

    @Override
    public DataDefinition getDataDefinition() {
        if (this.mDataDef == null) {
            this.mDataDef = new DataDefinition("Bars-" + this.getArgs().toString());
            this.mDataDef.addField(new DataField("OPEN", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof IBarDataPoint) {
                        IBarDataPoint bar = (IBarDataPoint)dp;
                        return bar.getOpen();
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    try {
                        return PriceFormat.convertPriceToDisplayFormat(Price.of(value), (IPriceFormatArgs)BarDataSeries.this.mArgs.Market, AppSettings.instance.MarketData.PriceDisplay);
                    }
                    catch (Exception ex) {
                        Log.e("BarMovingAverage.OPEN", "getFormattedValue(), Error.", ex);
                        return Double.toString(value);
                    }
                }
            }, false, true));
            this.mDataDef.addField(new DataField("HIGH", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof IBarDataPoint) {
                        IBarDataPoint bar = (IBarDataPoint)dp;
                        return bar.getHigh();
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    try {
                        return PriceFormat.convertPriceToDisplayFormat(Price.of(value), (IPriceFormatArgs)BarDataSeries.this.mArgs.Market, AppSettings.instance.MarketData.PriceDisplay);
                    }
                    catch (Exception ex) {
                        Log.e("BarMovingAverage.HIGH", "getFormattedValue(), Error.", ex);
                        return Double.toString(value);
                    }
                }
            }, false, true));
            this.mDataDef.addField(new DataField("LOW", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof IBarDataPoint) {
                        IBarDataPoint bar = (IBarDataPoint)dp;
                        return bar.getLow();
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    try {
                        return PriceFormat.convertPriceToDisplayFormat(Price.of(value), (IPriceFormatArgs)BarDataSeries.this.mArgs.Market, AppSettings.instance.MarketData.PriceDisplay);
                    }
                    catch (Exception ex) {
                        Log.e("BarMovingAverage.LOW", "getFormattedValue(), Error.", ex);
                        return Double.toString(value);
                    }
                }
            }, false, true));
            this.mDataDef.addField(new DataField("CLOSE", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof IBarDataPoint) {
                        IBarDataPoint bar = (IBarDataPoint)dp;
                        return bar.getClose();
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    try {
                        return PriceFormat.convertPriceToDisplayFormat(Price.of(value), (IPriceFormatArgs)BarDataSeries.this.mArgs.Market, AppSettings.instance.MarketData.PriceDisplay);
                    }
                    catch (Exception ex) {
                        Log.e("BarMovingAverage.CLOSE", "getFormattedValue(), Error.", ex);
                        return Double.toString(value);
                    }
                }
            }, true, true));
            this.mDataDef.addField(new DataField("VOLUME", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof IBarDataPoint) {
                        IBarDataPoint bar = (IBarDataPoint)dp;
                        return bar.getVolume();
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(this){

                @Override
                public String getFormattedValue(double value) {
                    try {
                        return Integer.toString((int)value);
                    }
                    catch (Exception ex) {
                        Log.e("BarMovingAverage.VOLUME", "getFormattedValue(), Error.", ex);
                        return Double.toString(value);
                    }
                }
            }, true, true));
        }
        return this.mDataDef;
    }

    public DataDefinition getSettlementDataDefinition() {
        if (this.mSettlmentDataDef == null) {
            this.mSettlmentDataDef = new DataDefinition("Settlement-" + this.getArgs().toString());
            this.mSettlmentDataDef.addField(new DataField("SETTL", new DataField.DataFieldReader(this){

                @Override
                public Double getFieldValue(IDataPoint dp) {
                    if (dp instanceof SettlementDataPoint) {
                        SettlementDataPoint settldp = (SettlementDataPoint)dp;
                        return settldp.SettlementPrice.getDoubleValue();
                    }
                    return null;
                }
            }, new DataField.DataFieldFormatter(){

                @Override
                public String getFormattedValue(double value) {
                    try {
                        return PriceFormat.convertPriceToDisplayFormat(Price.of(value), (IPriceFormatArgs)BarDataSeries.this.mArgs.Market, AppSettings.instance.MarketData.PriceDisplay);
                    }
                    catch (Exception ex) {
                        Log.e("BarDataSeries.SETTL", "getFormattedValue(), Error.", ex);
                        return Double.toString(value);
                    }
                }
            }, false, true));
        }
        return this.mSettlmentDataDef;
    }

    @Override
    public IDataSource getDataSource() {
        return this;
    }

    public static interface DataUpdatedHandler {
        public void onDataUpdated(Range<NDateTime> var1);
    }
}

